
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_HTTP_SERVLET_XML_H_
#define _PDEL_HTTP_SERVLET_XML_H_

struct http_request;
struct http_servlet_xml_info;

/*
 * User-supplied handler for http_servlet_xml. Should return the
 * reply structure (having type info->rtype), or NULL (and set errno)
 * if there was an error.
 *
 * Parameters
 *
 *	arg		User-supplied cookie
 *	payload		Incoming request structure (do not free)
 *	pattrs		Incoming request XML document element attributes
 *	rattrs		Reply XML document element attributes (if any)
 *	mtype		Memory type with which to allocate reply and *rattrsp
 */
typedef void	*http_servlet_xml_handler_t(void *arg,
			struct http_request *req, const void *payload,
			const char *pattrs, char **rattrsp, const char *mtype);

/*
 * Information required by http_servlet_xml_create().
 *
 *	handler		User-supplied handler function
 *	ptag		Request XML document element tag expected
 *	ptype		Payload type expected
 *	rtag		Reply XML document element tag
 *	rtype		Reply type returned by handler
 *	allow_post	Allow POST queries
 *	allow_get	Allow GET queries (payload and pattrs will be NULL)
 *	logger		Logging function
 *	flags		Flags for structs_xml_output()
 */
struct http_servlet_xml_info {
	http_servlet_xml_handler_t	*handler;	/* user handler */
	const char			*ptag;		/* payload doc elem */
	const struct structs_type	*ptype;		/* payload type */
	const char			*rtag;		/* reply doc elem */
	const struct structs_type	*rtype;		/* reply type */
	u_char				allow_post;	/* allow POST */
	u_char				allow_get;	/* allow GET */
	http_logger_t			*logger;	/* loggging function */
	int				flags;		/* output flags */
};

__BEGIN_DECLS

/*
 * Create a new XML servlet.
 */
extern struct	http_servlet *http_servlet_xml_create(
			const struct http_servlet_xml_info *info,
			void *arg, void (*destroy)(void *));

__END_DECLS

#endif	/* _PDEL_HTTP_SERVLET_XML_H_ */

