/*
 * Codepage definitions for libcthreads
 *
 * Copyright (C) 2012-2015, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBCTHREADS_CODEPAGE_H )
#define _LIBCTHREADS_CODEPAGE_H

#include <libcthreads/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBCTHREADS_CODEPAGES
{
	LIBCTHREADS_CODEPAGE_ASCII				= 20127,

	LIBCTHREADS_CODEPAGE_ISO_8859_1			= 28591,
	LIBCTHREADS_CODEPAGE_ISO_8859_2			= 28592,
	LIBCTHREADS_CODEPAGE_ISO_8859_3			= 28593,
	LIBCTHREADS_CODEPAGE_ISO_8859_4			= 28594,
	LIBCTHREADS_CODEPAGE_ISO_8859_5			= 28595,
	LIBCTHREADS_CODEPAGE_ISO_8859_6			= 28596,
	LIBCTHREADS_CODEPAGE_ISO_8859_7			= 28597,
	LIBCTHREADS_CODEPAGE_ISO_8859_8			= 28598,
	LIBCTHREADS_CODEPAGE_ISO_8859_9			= 28599,
	LIBCTHREADS_CODEPAGE_ISO_8859_10			= 28600,
	LIBCTHREADS_CODEPAGE_ISO_8859_11			= 28601,
	LIBCTHREADS_CODEPAGE_ISO_8859_13			= 28603,
	LIBCTHREADS_CODEPAGE_ISO_8859_14			= 28604,
	LIBCTHREADS_CODEPAGE_ISO_8859_15			= 28605,
	LIBCTHREADS_CODEPAGE_ISO_8859_16			= 28606,

	LIBCTHREADS_CODEPAGE_KOI8_R			= 20866,
	LIBCTHREADS_CODEPAGE_KOI8_U			= 21866,

	LIBCTHREADS_CODEPAGE_WINDOWS_874			= 874,
	LIBCTHREADS_CODEPAGE_WINDOWS_932			= 932,
	LIBCTHREADS_CODEPAGE_WINDOWS_936			= 936,
	LIBCTHREADS_CODEPAGE_WINDOWS_949			= 949,
	LIBCTHREADS_CODEPAGE_WINDOWS_950			= 950,
	LIBCTHREADS_CODEPAGE_WINDOWS_1250			= 1250,
	LIBCTHREADS_CODEPAGE_WINDOWS_1251			= 1251,
	LIBCTHREADS_CODEPAGE_WINDOWS_1252			= 1252,
	LIBCTHREADS_CODEPAGE_WINDOWS_1253			= 1253,
	LIBCTHREADS_CODEPAGE_WINDOWS_1254			= 1254,
	LIBCTHREADS_CODEPAGE_WINDOWS_1255			= 1255,
	LIBCTHREADS_CODEPAGE_WINDOWS_1256			= 1256,
	LIBCTHREADS_CODEPAGE_WINDOWS_1257			= 1257,
	LIBCTHREADS_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBCTHREADS_CODEPAGE_US_ASCII			LIBCTHREADS_CODEPAGE_ASCII

#define LIBCTHREADS_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBCTHREADS_CODEPAGE_ISO_8859_1
#define LIBCTHREADS_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBCTHREADS_CODEPAGE_ISO_8859_2
#define LIBCTHREADS_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBCTHREADS_CODEPAGE_ISO_8859_3
#define LIBCTHREADS_CODEPAGE_ISO_NORTH_EUROPEAN		LIBCTHREADS_CODEPAGE_ISO_8859_4
#define LIBCTHREADS_CODEPAGE_ISO_CYRILLIC			LIBCTHREADS_CODEPAGE_ISO_8859_5
#define LIBCTHREADS_CODEPAGE_ISO_ARABIC			LIBCTHREADS_CODEPAGE_ISO_8859_6
#define LIBCTHREADS_CODEPAGE_ISO_GREEK			LIBCTHREADS_CODEPAGE_ISO_8859_7
#define LIBCTHREADS_CODEPAGE_ISO_HEBREW			LIBCTHREADS_CODEPAGE_ISO_8859_8
#define LIBCTHREADS_CODEPAGE_ISO_TURKISH			LIBCTHREADS_CODEPAGE_ISO_8859_9
#define LIBCTHREADS_CODEPAGE_ISO_NORDIC			LIBCTHREADS_CODEPAGE_ISO_8859_10
#define LIBCTHREADS_CODEPAGE_ISO_THAI			LIBCTHREADS_CODEPAGE_ISO_8859_11
#define LIBCTHREADS_CODEPAGE_ISO_BALTIC			LIBCTHREADS_CODEPAGE_ISO_8859_13
#define LIBCTHREADS_CODEPAGE_ISO_CELTIC			LIBCTHREADS_CODEPAGE_ISO_8859_14

#define LIBCTHREADS_CODEPAGE_ISO_LATIN_1			LIBCTHREADS_CODEPAGE_ISO_8859_1
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_2			LIBCTHREADS_CODEPAGE_ISO_8859_2
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_3			LIBCTHREADS_CODEPAGE_ISO_8859_3
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_4			LIBCTHREADS_CODEPAGE_ISO_8859_4
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_5			LIBCTHREADS_CODEPAGE_ISO_8859_9
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_6			LIBCTHREADS_CODEPAGE_ISO_8859_10
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_7			LIBCTHREADS_CODEPAGE_ISO_8859_13
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_8			LIBCTHREADS_CODEPAGE_ISO_8859_14
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_9			LIBCTHREADS_CODEPAGE_ISO_8859_15
#define LIBCTHREADS_CODEPAGE_ISO_LATIN_10			LIBCTHREADS_CODEPAGE_ISO_8859_16

#define LIBCTHREADS_CODEPAGE_KOI8_RUSSIAN			LIBCTHREADS_CODEPAGE_KOI8_R
#define LIBCTHREADS_CODEPAGE_KOI8_UKRAINIAN		LIBCTHREADS_CODEPAGE_KOI8_U

#define LIBCTHREADS_CODEPAGE_WINDOWS_THAI			LIBCTHREADS_CODEPAGE_WINDOWS_874
#define LIBCTHREADS_CODEPAGE_WINDOWS_JAPANESE		LIBCTHREADS_CODEPAGE_WINDOWS_932
#define LIBCTHREADS_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBCTHREADS_CODEPAGE_WINDOWS_936
#define LIBCTHREADS_CODEPAGE_WINDOWS_KOREAN		LIBCTHREADS_CODEPAGE_WINDOWS_949
#define LIBCTHREADS_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBCTHREADS_CODEPAGE_WINDOWS_950
#define LIBCTHREADS_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBCTHREADS_CODEPAGE_WINDOWS_1250
#define LIBCTHREADS_CODEPAGE_WINDOWS_CYRILLIC		LIBCTHREADS_CODEPAGE_WINDOWS_1251
#define LIBCTHREADS_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBCTHREADS_CODEPAGE_WINDOWS_1252
#define LIBCTHREADS_CODEPAGE_WINDOWS_GREEK			LIBCTHREADS_CODEPAGE_WINDOWS_1253
#define LIBCTHREADS_CODEPAGE_WINDOWS_TURKISH		LIBCTHREADS_CODEPAGE_WINDOWS_1254
#define LIBCTHREADS_CODEPAGE_WINDOWS_HEBREW		LIBCTHREADS_CODEPAGE_WINDOWS_1255
#define LIBCTHREADS_CODEPAGE_WINDOWS_ARABIC		LIBCTHREADS_CODEPAGE_WINDOWS_1256
#define LIBCTHREADS_CODEPAGE_WINDOWS_BALTIC		LIBCTHREADS_CODEPAGE_WINDOWS_1257
#define LIBCTHREADS_CODEPAGE_WINDOWS_VIETNAMESE		LIBCTHREADS_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif

