#ifndef FRAME_CPP__TEST__FR_STRUCT_HH
#define FRAME_CPP__TEST__FR_STRUCT_HH

#include <memory>

#include "framecpp/Common/FrameSpec.hh"

typedef FrameCPP::Common::FrameSpec::Object FrObject;
typedef FrameCPP::Common::FrameSpec::Info::frame_object_types FrameObjectTypes;
typedef LDASTools::AL::SharedPtr< FrObject > frame_object_type;
typedef frame_object_type mk_frame_object_ret_type;

static FrameCPP::Common::IStream* NULL_ISTREAM
= (FrameCPP::Common::IStream*)NULL;

#define CHECK_STRING_4( P, PA, C, CA, N )		\
	Test.Check( C->CA( ).compare( P->PA( ) ) == 0 ) \
	  << Leader << "field: " #N \
	  << std::endl

#define CHECK_STRING( P, C, A, N )	   \
  CHECK_STRING_4( P, A, C, A, N )

#define CHECK_NUMBER_CONST( V, VA, C, N )	  \
	Test.Check( V->VA( ) == C ) \
	  << Leader << "field: " #N \
	  << std::endl

#define CHECK_NUMBER_4( P, PA, C, CA, N )	   \
	Test.Check( C->CA( ) == P->PA( ) ) \
	  << Leader << "field: " #N \
	  << std::endl

#define CHECK_NUMBER( P, C, A, N )	   \
  CHECK_NUMBER_4( P, A, C, A, N )

inline void
AddressCheck( const void* LHS, const void* RHS,
	      bool Sameness, bool Nullness,
	      const std::string& Leader, LDASTools::Testing::UnitTest& Test )
{
  //---------------------------------------------------------------------
  // Check if the addresses are the same
  //---------------------------------------------------------------------
  Test.Check( ( LHS == RHS ) == Sameness )
    << Leader << " Address Check"
    << std::endl
    ;
  //---------------------------------------------------------------------
      // Check if the addresses is null
  //---------------------------------------------------------------------
  Test.Check( ( LHS == (void*)NULL ) == Nullness )
    << Leader << " Null Check"
    << std::endl
    ;
}

mk_frame_object_ret_type
mk_frame_object( int SpecVersion,
		 FrameCPP::Common::FrameSpec::Info::frame_object_types Type );

template< int V >
mk_frame_object_ret_type
mk_frame_object( FrameObjectTypes Type );

template< int V >
void verify_downconvert( frame_object_type FrameObj,
			 const std::string& Leader,
			 LDASTools::Testing::UnitTest& Test );

template< int V >
void verify_upconvert( frame_object_type FrameObj,
		       const std::string& Leader,
		       LDASTools::Testing::UnitTest& Test );

template< typename FrameObjCurType, typename FrameObjPrevType = FrameObjCurType >
class Demote
{
public:
  typedef typename LDASTools::AL::SharedPtr< FrameObjCurType >	current_type;
  typedef typename current_type::element_type			current_element_type;
  typedef typename LDASTools::AL::SharedPtr< FrameObjPrevType >	previous_type;
  typedef typename previous_type::element_type			previous_element_type;

  inline static void
  OutOfExistance( current_type FrameObj,
		  int PreviousSpecVersion,
		  const std::string& Leader,
		  LDASTools::Testing::UnitTest& Test )
  {
    current_type
      obj( LDASTools::AL::DynamicPointerCast< current_element_type >( FrameObj ) );

    if ( obj )
    {
      LDASTools::AL::SharedPtr< FrObject >
	previous( obj->DemoteObject( PreviousSpecVersion,
				     obj, NULL_ISTREAM ) );
      AddressCheck( previous.get( ), obj.get( ),
		    false, true,
		    Leader, Test );
    }
  }

  inline static previous_type
  Previous( current_type Current,
	    int PreviousSpecVersion,
	    const std::string& Leader,
	    LDASTools::Testing::UnitTest& Test )
  {
    previous_type  previous;

    if ( Current )
    {
      LDASTools::AL::SharedPtr< FrObject >
	previous_object( Current->DemoteObject( PreviousSpecVersion,
						Current, NULL_ISTREAM ) );
      previous = LDASTools::AL::DynamicPointerCast< previous_element_type >
	( previous_object );
      //-----------------------------------------------------------------
      // Address validation
      //-----------------------------------------------------------------
      AddressCheck( previous.get( ), Current.get( ),
		    false, false,
		    Leader, Test );
    }
    return previous;
  };

  inline static void
  ToSame( current_type FrameObj,
	  int PreviousSpecVersion,
	  const std::string& Leader,
	  LDASTools::Testing::UnitTest& Test )
  {
    current_type
      obj( LDASTools::AL::DynamicPointerCast< current_element_type >( FrameObj ) );

    if ( obj )
    {
      LDASTools::AL::SharedPtr< FrObject >
	pobj( obj->DemoteObject( PreviousSpecVersion,
				 obj, NULL_ISTREAM ) );
      previous_type
	previous( LDASTools::AL::DynamicPointerCast< previous_element_type >( pobj ) );
      AddressCheck( previous.get( ), obj.get( ),
		    true, false,
		    Leader, Test );
    }
  }

private:
  inline static void
  demote( current_type Cur,
	  previous_type& Previous,
	  int PreviousSpecVersion,
	  LDASTools::AL::SharedPtr< FrObject >& DemotedObj )
  {
    DemotedObj( Cur->DemoteObject( PreviousSpecVersion, Cur,
				   NULL_ISTREAM ) );
    Previous = LDASTools::AL::DynamicPointerCast< previous_element_type >( DemotedObj );
  }

};

#define DEMOTE_TO_PREVIOUS_DIFF(CUR,PRE) \
      typedef LDASTools::AL::SharedPtr< CUR > cast_type; \
      typedef CUR cur_type; \
      typedef PREVIOUS_NAMESPACE::PRE pre_type; \
\
      cast_type \
      current( LDASTools::AL::DynamicPointerCast< cast_type::element_type >( FrameObj ) ); \
\
      Demote< cur_type, pre_type >::previous_type \
	previous( Demote< cur_type, pre_type >::Previous \
		  ( current, PREVIOUS_TEMPLATE_SPEC, Leader, Test ) )

#define DEMOTE_TO_PREVIOUS(CUR) \
  DEMOTE_TO_PREVIOUS_DIFF(CUR,CUR)

#define DEMOTE_TO_SAME(CUR) \
  LDASTools::AL::SharedPtr< CUR > obj_( LDASTools::AL::DynamicPointerCast< CUR >( FrameObj ) ); \
  \
  Demote< CUR, PREVIOUS_NAMESPACE::CUR >::ToSame		\
    ( obj_, PREVIOUS_TEMPLATE_SPEC, Leader, Test )

#define DEMOTE_TO_NULL(CUR) \
  LDASTools::AL::SharedPtr< CUR > obj_( LDASTools::AL::DynamicPointerCast< CUR >( FrameObj ) ); \
  \
  Demote< CUR, CUR >::OutOfExistance	\
    ( obj_, PREVIOUS_TEMPLATE_SPEC, Leader, Test )

template< typename FrameObjCurType, typename FrameObjPrevType = FrameObjCurType >
class Promote
{
public:
  typedef typename LDASTools::AL::SharedPtr< FrameObjCurType >	current_type;
  typedef typename current_type::element_type			current_element_type;
  typedef typename LDASTools::AL::SharedPtr< FrameObjPrevType >	previous_type;
  typedef typename previous_type::element_type			previous_element_type;

  inline static void
  FromNothing( frame_object_type FrameObj,
	       int SpecVersion,
	       int PreviousSpecVersion,
	       const std::string& Leader,
	       LDASTools::Testing::UnitTest& Test )
  {
    using FrameCPP::Common::FrameSpec;

    //---------------------------------------------------------------------
    //
    //---------------------------------------------------------------------
    current_type
      fr_object( LDASTools::AL::DynamicPointerCast< current_element_type >( FrameObj ) );

    //---------------------------------------------------------------------
    // Create instance of object to promote
    //---------------------------------------------------------------------
    const FrameSpec::Info::frame_object_types
      class_id( FrameSpec::Info::frame_object_types( FrameObj->GetClass( ) ) );

    previous_type
      previous( LDASTools::AL::DynamicPointerCast< previous_element_type >
		( mk_frame_object( PreviousSpecVersion,
				   class_id ) ) );

    current_type
      promoted( LDASTools::AL::DynamicPointerCast< current_element_type >
		( fr_object->PromoteObject( SpecVersion,
					    PreviousSpecVersion,
					    previous,
					    NULL_ISTREAM ) ) );
			 
  
    AddressCheck( previous.get( ), promoted.get( ),
		  true, true,
		  Leader, Test );

  }

  inline static void
  FromPrevious( frame_object_type FrameObj,
		int SpecVersion,
		current_type& Current,
		int PreviousSpecVersion,
		previous_type& Previous,
		const std::string& Leader,
		LDASTools::Testing::UnitTest& Test )
  {
    if ( FrameObj )
    {
      //-------------------------------------------------------------------
      // Handle the promotion
      //-------------------------------------------------------------------
      promote( FrameObj,
	       Current, Previous,
	       PreviousSpecVersion,
	       SpecVersion );
    }
    else
    {
      Test.Message( ) << "WARNING: NULL FrameObj sent to PromoteFromPrevious"
		      << std::endl
	;
    }
			 
    //-------------------------------------------------------------------
    // Address validation
    //-------------------------------------------------------------------
    AddressCheck( Current.get( ), Previous.get( ),
		  false, false,
		  Leader, Test );
  }

  inline static void
  ToSame( frame_object_type FrameObj,
	  int SpecVersion,
	  int PreviousSpecVersion,
	  const std::string& Leader,
	  LDASTools::Testing::UnitTest& Test )
  {
    using FrameCPP::Common::FrameSpec;

    //---------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------
    current_type
      fr_object( LDASTools::AL::DynamicPointerCast< current_element_type >( FrameObj ) );

    //---------------------------------------------------------------------
    //---------------------------------------------------------------------
    const FrameSpec::Info::frame_object_types
      class_id( FrameSpec::Info::frame_object_types( FrameObj->GetClass( ) ) );

    previous_type
      previous( LDASTools::AL::DynamicPointerCast< previous_element_type >
		( mk_frame_object( PreviousSpecVersion,
				   class_id ) ) );

    current_type
      promoted( LDASTools::AL::DynamicPointerCast< current_element_type >
		( fr_object->PromoteObject( SpecVersion,
					    PreviousSpecVersion,
					    previous,
					    NULL_ISTREAM ) ) );
  
    AddressCheck( previous.get( ), promoted.get( ),
		  true, false,
		  Leader, Test );
  }

private:
  inline static void
  promote( frame_object_type FrameObj,
	   current_type& Promoted,
	   previous_type& Previous,
	   int PreviousSpecVersion,
	   int SpecVersion )
  {
    current_type
      typed_obj( LDASTools::AL::DynamicPointerCast< current_element_type >( FrameObj ) );
    
    Previous = LDASTools::AL::DynamicPointerCast< previous_element_type >
	      ( mk_frame_object( PreviousSpecVersion,
				 FrameCPP::Common::FrameSpec::Info::
				 frame_object_types( FrameObj->GetClass( ) ) ) );
    Promoted = LDASTools::AL::DynamicPointerCast< current_element_type >
                 ( typed_obj->PromoteObject( SpecVersion,
					     PreviousSpecVersion,
					     Previous,
					     NULL_ISTREAM ) );
  }

};

#define PROMOTE_FROM_NOTHING(CUR) \
  Promote< CUR >::FromNothing \
      ( FrameObj, TEMPLATE_SPEC, PREVIOUS_TEMPLATE_SPEC, Leader, Test )

#define PROMOTE_FROM_PREVIOUS_DIFF(CUR,PRE) \
      typedef CUR cur_type; \
      typedef PREVIOUS_NAMESPACE::PRE pre_type; \
\
      Promote< cur_type, pre_type >::previous_type	previous; \
      Promote< cur_type, pre_type >::current_type	promoted; \
\
      Promote< cur_type, pre_type >:: \
	FromPrevious( FrameObj, \
		      TEMPLATE_SPEC, promoted, \
		      PREVIOUS_TEMPLATE_SPEC, previous, \
		      Leader, Test )

#define PROMOTE_FROM_PREVIOUS(CUR) \
  PROMOTE_FROM_PREVIOUS_DIFF(CUR,CUR)

#define PROMOTE_TO_SAME_DIFF(CUR,PRE) \
  Promote< CUR, PREVIOUS_NAMESPACE::PRE >::ToSame \
      ( FrameObj, TEMPLATE_SPEC, PREVIOUS_TEMPLATE_SPEC, Leader, Test )

#define PROMOTE_TO_SAME(CUR) \
  PROMOTE_TO_SAME_DIFF(CUR,CUR)



#endif /* FRAME_CPP__TEST__FR_STRUCT_HH */
