#ifndef FrameCPP_VERSION_8_FrSimEvent_HH
#define FrameCPP_VERSION_8_FrSimEvent_HH

#ifndef SWIGIMPORTED
#include <string>
#include <vector>
#endif /* SWIGIMPORTED */

#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version7/FrSimEvent.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/GPSTime.hh"
#include "framecpp/Version8/FrVect.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //===================================================================
    // FrSimEventNPS
    //===================================================================
    typedef Previous::FrSimEvent::FrSimEventNPS FrSimEventNPS;

    //===================================================================
    // FrSimEventPST
    //===================================================================

    typedef Version_4::FrSimEventPST< PTR_STRUCT,
				      FrVect, FrTable >
    FrSimEventPS;

    //===================================================================
    /// \brief Simulated Event Data Structure Definition
    //===================================================================
    class FrSimEvent
      : public ObjectWithChecksum< Common::FrameSpec::Object >,
	public FrSimEventNPS,
	public FrSimEventPS,
	public Common::TOCInfo
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimEvent( );

      //-----------------------------------------------------------------
      /// \brief Copy Constructor
      ///
      /// \param[in] Source
      ///     The object from which to copy the information.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimEvent( const FrSimEvent& Source );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] name
      ///     Name of event.
      /// \param[in] comment
      ///     Descriptor of event.
      /// \param[in] inputs
      ///     Input channels and filter parameters to event process.
      /// \param[in] time
      ///     GPS time corresponding to reference value of event.
      /// \param[in] timeBefore
      ///     Signal duration before time.
      /// \param[in] timeAfter
      ///     Signal duration after time.
      /// \param[in] amplitude
      ///     Continuous output amplitude returned by event.
      /// \param[in] parameters
      ///     Array of additional event parameters.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimEvent( const std::string& name,
		  const std::string& comment,
		  const std::string& inputs,
		  const GPSTime& time,
		  const REAL_4 timeBefore,
		  const REAL_4 timeAfter,
		  const REAL_4 amplitude,
		  const ParamList_type& parameters );

      //-----------------------------------------------------------------
      /// \brief Promotion Constructor
      ///
      /// \param[in] Source
      ///     An FrSimEvent structure from a previous frame specification.
      /// \param[in] Stream
      ///     The stream from which the earliest version of the
      ///     FrSimEvent structure was read.
      ///
      /// \return
      ///     A new instance of the object.
      //-----------------------------------------------------------------
      FrSimEvent( const Previous::FrSimEvent& Source,
		  Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief Retrieve the name of event.
      ///
      /// \return
      ///     The name of event.
      //-----------------------------------------------------------------
      const std::string& GetNameSlow( ) const;

      //-----------------------------------------------------------------
      /// \brief Promote previous version of object to this version
      ///
      /// \param[in] Source
      ///     The frame specification version of the object.
      /// \param[in] Obj
      ///     The previous version of the object.
      /// \param[in] Stream
      ///     Stream from which the origional object was created.
      ///
      /// \return
      ///     A new instance of FrameH based on Obj
      //-----------------------------------------------------------------
      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       Common::IStream* Stream );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

#if WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      //-----------------------------------------------------------------
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      //-----------------------------------------------------------------
      /// \brief Merge with another FrSimEvent
      ///
      /// \param[in] RHS
      ///     The source of the information to append to this FrSimEvent
      ///     structure.
      ///
      /// \return
      ///     A reference to this object
      //-----------------------------------------------------------------
      FrSimEvent& Merge( const FrSimEvent& RHS );

      //-----------------------------------------------------------------
      /// \brief inequality operator
      ///
      /// \param[in] RHS
      ///     The FrSimEvent object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is not equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      bool operator==( const FrSimEvent& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator for abstract data type
      ///
      /// \param[in] RHS
      ///     The object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      cmn_streamsize_type pBytes( const Common::StreamBase& Stream) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      //-----------------------------------------------------------------
      virtual FrSimEvent* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      /// \param[in] vl
      ///     Variable argument list of requested data.
      //-----------------------------------------------------------------
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      //-----------------------------------------------------------------
      /// \brief Object with checksum data.
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrameSpec::Object > object_type;

      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrSimEvent( Common::IStream& Stream );
    };

    inline FrSimEvent::promote_ret_type FrSimEvent::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     Common::IStream* Stream )
    {
      return Object::PromoteObject< Previous::FrSimEvent, FrSimEvent >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrSimEvent::
    StructName( )
    {
      static const char* name = "FrSimEvent";
      return name;
    }

    inline bool FrSimEvent::
    operator==( const FrSimEvent& RHS ) const
    {
      return ( ( this == &RHS )
	       || ( ( m_data == RHS.m_data )
		    && (m_refs == RHS.m_refs )
		    ) );
    }
  } // namespace - Version_8
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_8_FrSimEvent_HH */
