#ifndef FRAME_CPP_INTERFACE__FR_HISTORY_H
#define FRAME_CPP_INTERFACE__FR_HISTORY_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

  /* Begin Group */
  /**
   * \addtogroup CInterface
   * @{
   */

  typedef struct fr_history	fr_history_t;
  typedef INT_4U 		fr_history_time_t;

  /**
   * \brief Allocate a fr_frame structure.
   *
   * \note
   * This method should be used as there may be additional data allocated
   * to properly interface to the C++ layer.
   *
   * \param[out] Error
   *     If an error occurs, Error will be non-NULL and a detailed error
   *     message will be available.
   *
   * \param[in] Name
   *     Name of the history record
   * \param[in] Time
   *     Time of post-processing
   *     (GPS seconds since GPS standard epoch)
   * \param[in] Comment
   *     Program name and relevant comments needed to define
   *     post-processing
   *
   * \return
   *     Pointer to newly allocated frame_h_t.
   *     If a failure happens, a NULL pointer will be returned.
   */
  fr_history_t *FrameCFrHistoryAlloc( FrameCError** Error,
				      const char* Name,
				      fr_history_time_t Time,
				      const char* Comment );

  int FrameCFrHistoryFree( FrameCError** Error,
			   fr_history_t *History );


  /** @} */
  /* End Group */
#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* FRAME_CPP_INTERFACE__FR_HISTORY_H */
