#=========================================================================
# Recursive support
#=========================================================================

abi-check-recursive:

ifneq ($(RECURSIVE_TARGETS),abi-check-recursive)
abi-check-recursive:
	$(MAKE) $(AM_MAKEFLAGS) RECURSIVE_TARGETS=abi-check-recursive abi-check-recursive
endif

abi-check: abi-check-recursive abi-check-am

abi-check-am: all-am

#=========================================================================
# Overrides
#=========================================================================

REPORTS=$(lib_LTLIBRARIES:.la=.abi.rpt)
REPORT_TIMESTAMPS=$(lib_LTLIBRARIES:.la=.rpt.timestamp)

#=========================================================================
# Suplimental rules
#=========================================================================

ifneq ($(ABI_COMPLIANCE_CHECKER),)
ifneq ($(ABI_DUMPER),)
abi-check: $(REPORT_TIMESTAMPS)

lib%.old.dump: $(ABI_OLD_ROOT)/lib/lib%.so
	$(ABI_DUMPER) $< -o $@ -lver 1

lib%.new.dump: .libs/lib%.so
	$(ABI_DUMPER) $< -o $@ -lver 2

compat_reports/lib%.abi.rpt: lib%.new.dump lib%.old.dump
	$(ABI_COMPLIANCE_CHECKER) -l $(@F) -old lib$*.old.dump -new lib$*.new.dump

lib%.rpt.timestamp: compat_reports/lib%.abi.rpt
	touch $@
endif
endif
