#include <framecpp_config.h>

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/Description.hh"
#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/FrameSpec.tcc"

#include "framecpp/Version8/FrSimEvent.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSH.hh"

#include "framecpp/Version8/PTR_STRUCT.hh"

#include "Common/ComparePrivate.hh"

using namespace FrameCPP::Version_8;
using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::IStream;
using FrameCPP::Common::OStream;

#define LM_DEBUG 0

//=======================================================================
// Static
//=======================================================================

static const FrameSpec::Info::frame_object_types s_object_id
= FrameSpec::Info::FSI_FR_SIM_EVENT;

//=======================================================================
// FrSimEvent
//=======================================================================
FrSimEvent::
FrSimEvent( )
  : object_type( s_object_id, StructDescription( ) )
{
}

FrSimEvent::
FrSimEvent( const FrSimEvent& Source )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimEventNPS( Source ),
    FrSimEventPS( Source ),
    Common::TOCInfo( Source )
{
}

FrSimEvent::
FrSimEvent( const std::string& name,
	 const std::string& comment,
	 const std::string& inputs,
	 const GPSTime& time,
	 const REAL_4 timeBefore,
	 const REAL_4 timeAfter,
	 const REAL_4 amplitude,
	 const ParamList_type& parameters )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimEventNPS( name,
		   comment,
		   inputs,
		   time,
		   timeBefore,
		   timeAfter,
		   amplitude,
		   parameters )
    
{
}

FrSimEvent::
FrSimEvent( const Previous::FrSimEvent& Source,
	    Common::IStream* Stream )
  : object_type( s_object_id, StructDescription( ) ),
    FrSimEventNPS( Source )
{
  if ( Stream )
  {
    //-------------------------------------------------------------------
    // Modify references
    //-------------------------------------------------------------------
    Stream->ReplaceRef( RefData( ), Source.RefData( ),
			Previous::FrSimEvent::MAX_REF );
    Stream->ReplaceRef( RefTable( ), Source.RefTable( ),
			Previous::FrSimEvent::MAX_REF );
  }
}

FrSimEvent::
FrSimEvent( Common::IStream& Stream )
  : object_type( s_object_id, StructDescription( ) )
{
  m_data( Stream );
  m_refs( Stream );

  Stream.Next( this );
}

const std::string& FrSimEvent::
GetNameSlow( ) const
{
  return GetName( );
}

FrSimEvent& FrSimEvent::
Merge( const FrSimEvent& RHS )
{
  throw
    Unimplemented( "FrSimEvent& FrSimEvent::Merge( const FrSimEvent& RHS )",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
  return *this;
}

const char* FrSimEvent::
ObjectStructName( ) const
{
  return StructName( );
}

const Description* FrSimEvent::
StructDescription( )
{
  static Description ret;

  if ( ret.size( ) == 0 )
  {
    ret( FrSH( FrSimEvent::StructName( ), s_object_id,
	       "Event Data Structure" ) );

    FrSimEventNPS::storage_type::Describe< FrSE >( ret );
    refs_type::Describe< FrSE >( ret );

    ret( FrSE( "next", PTR_STRUCT::Desc( FrSimEvent::StructName( ) ),
	       "" ) );

    ret( FrSE( "chkSum", CheckSumDataClass( ), CheckSumDataComment( ) ) );
  }

  return &ret;
}

void FrSimEvent::
#if WORKING_VIRTUAL_TOCQUERY
    TOCQuery( int InfoClass, ... ) const
#else /*  WORKING_VIRTUAL_TOCQUERY */
    vTOCQuery( int InfoClass, va_list vl ) const
#endif /*  WORKING_VIRTUAL_TOCQUERY */
{
  using Common::TOCInfo;

#if WORKING_VIRTUAL_TOCQUERY
  va_list	vl;
  va_start( vl, InfoClass );
#endif /*  WORKING_VIRTUAL_TOCQUERY */

  while ( InfoClass != TOCInfo::IC_EOQ )
  {
    int data_type = va_arg( vl, int );
    switch( data_type )
    {
    case TOCInfo::DT_STRING_2:
      {
	STRING* data = va_arg( vl, STRING* );
	switch( InfoClass )
	{
	case TOCInfo::IC_NAME:
	  *data = GetName( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    case TOCInfo::DT_INT_4U:
      {
	INT_4U* data = va_arg( vl, INT_4U* );
	switch( InfoClass )
	{
	case TOCInfo::IC_GTIME_S:
	  *data = GetGTime( ).GetSeconds( );
	  break;
	case TOCInfo::IC_GTIME_N:
	  *data = GetGTime( ).GetNanoseconds( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    case TOCInfo::DT_REAL_4:
      {
	REAL_4* data = va_arg( vl, REAL_4* );
	switch( InfoClass )
	{
	case TOCInfo::IC_AMPLITUDE:
	  *data = GetAmplitude( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    case TOCInfo::DT_REAL_8:
      {
	REAL_8* data = va_arg( vl, REAL_8* );
	switch( InfoClass )
	{
	case TOCInfo::IC_AMPLITUDE:
	  *data = GetAmplitude( );
	  break;
	default:
	  goto cleanup;
	  break;
	}
      }
      break;
    default:
      // Stop processing
      goto cleanup;
    }
    InfoClass = va_arg( vl, int );
  }
 cleanup:
#if WORKING_VIRTUAL_TOCQUERY
  va_end( vl )
#endif /*  WORKING_VIRTUAL_TOCQUERY */
    ;
}

bool FrSimEvent::
operator==( const Common::FrameSpec::Object& RHS ) const
{
  return Common::Compare( *this, RHS );
}

FrSimEvent::demote_ret_type FrSimEvent::
demote( INT_2U Target,
	demote_arg_type Obj,
	Common::IStream* Stream ) const
{
  if ( Target >= DATA_FORMAT_VERSION )
  {
    return Obj;
  }
  try
  {
    //-------------------------------------------------------------------
    // Copy non-reference information
    //-------------------------------------------------------------------
    Previous::FrSimEvent::ParamList_type params;
    for ( ParamList_type::const_iterator
	    cur = GetParam( ).begin( ),
	    last = GetParam( ).end( );
	  cur != last;
	  ++cur )
    {
      params.push_back( Previous::FrSimEvent::Param_type( cur->first,
						       cur->second ) );
    }
    // Do actual down conversion
    LDASTools::AL::SharedPtr< Previous::FrSimEvent >
      retval( new Previous::FrSimEvent( GetName( ),
				     GetComment( ),
				     GetInputs( ),
				     GetGTime( ),
				     GetTimeBefore( ),
				     GetTimeAfter( ),
				     GetAmplitude( ),
				     params
				     ) )
      ;
    if ( Stream )
    {
      //-----------------------------------------------------------------
      // Modify references
      //-----------------------------------------------------------------
      Stream->ReplaceRef( retval->RefData( ), RefData( ), MAX_REF );
      Stream->ReplaceRef( retval->RefTable( ), RefTable( ), MAX_REF );
    }
    //-------------------------------------------------------------------
    // Return demoted object
    //-------------------------------------------------------------------
    return retval;
  }
  catch( ... )
  {
  }
  throw
    Unimplemented( "Object* FrSimEvent::demote( Object* Obj ) const",
		   DATA_FORMAT_VERSION, __FILE__, __LINE__ );
}

FrSimEvent::promote_ret_type FrSimEvent::
promote( INT_2U Target,
	 promote_arg_type Obj,
	 Common::IStream* Stream ) const
{
  return Promote( Target, Obj, Stream );
}

FrameCPP::cmn_streamsize_type FrSimEvent::
pBytes( const Common::StreamBase& Stream ) const
{
  return
    m_data.Bytes( )
    + m_refs.Bytes( Stream )
    + Stream.PtrStructBytes( )	// next
    ;
}

FrSimEvent* FrSimEvent::
pCreate( Common::IStream& Stream ) const
{
  return new FrSimEvent( Stream );
}

void FrSimEvent::
pWrite( Common::OStream& Stream ) const
{
  m_data( Stream );
  m_refs( Stream );
  WriteNext( Stream );
}
