#ifndef FrameCPP__VERSION_8__FrSH_HH
#define FrameCPP__VERSION_8__FrSH_HH

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/FrSH.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version8/FrameSpec.hh"
#include "framecpp/Version8/STRING.hh"

namespace FrameCPP
{
  namespace Version_8
  {
    //-------------------------------------------------------------------
    /// \brief Contains class information of a dictionary structure.
    ///
    /// A dictionary structure is written to the output stream the
    /// imediately preceeding the first occurance of the frame structure
    /// it describes.
    /// This class gives information about the class structure being
    /// described.
    /// In a dictionary structure, there is only one occurance of FrSH.
    /// It must be the first element of the dictionary structure.
    ///
    /// \see FrSE
    //-------------------------------------------------------------------
    class FrSH
      : public ObjectWithChecksum< Common::FrSH >,
	public Common::TOCInfo
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Default constructor
      //-----------------------------------------------------------------
      FrSH( );

      //-----------------------------------------------------------------
      /// \brief constructor
      ///
      /// \param[in] Name
      ///     Name of structure being described by this dictionary
      ///     structure.
      /// \param[in] ClassId
      ///     Class number of structure being described
      /// \param[in] Comment
      ///     Comment describing the class.
      //-----------------------------------------------------------------
      FrSH( const std::string& Name,
	    INT_2U ClassId,
	    const std::string& Comment );

      //-----------------------------------------------------------------
      /// \brief Desctructor
      //-----------------------------------------------------------------
      virtual ~FrSH( );

      //-----------------------------------------------------------------
      /// \brief Dictionary class name
      ///
      /// \return
      ///     The dictionary class name for this structure.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief Return class of object
      //-----------------------------------------------------------------
      INT_2U GetClass( ) const;

      //-----------------------------------------------------------------
      /// \brief Return comment of object
      //-----------------------------------------------------------------
      const std::string& GetComment( ) const;

      //-----------------------------------------------------------------
      /// \brief Return name of object
      //-----------------------------------------------------------------
      const STRING& GetName( ) const;

      //-----------------------------------------------------------------
      /// \brief Create a new instance of the object based on self.
      //-----------------------------------------------------------------
      virtual FrSH* Clone( ) const;

#if NEEDED
      //-----------------------------------------------------------------
      /// \brief Down grade an object
      //-----------------------------------------------------------------
      virtual Object* Demote( Object*, Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Upgrade an object
      //-----------------------------------------------------------------
      virtual Object* Promote( Object*, Common::IStream* Stream ) const;
#endif /* NEEDED */

      //-----------------------------------------------------------------
      /// \brief Return the dictionary name of the structure.
      //-----------------------------------------------------------------
      static const char* StructName( );

#if WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Hook for FrTOC to query the object.
      //-----------------------------------------------------------------
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      //-----------------------------------------------------------------
      /// \brief comparison operator
      //-----------------------------------------------------------------
      bool operator==( const FrSH& RHS ) const;

      //-----------------------------------------------------------------
      /// \brief comparison operator
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Interface method to return name of dictionary class.
      //-----------------------------------------------------------------
      virtual const std::string& name( ) const;

      //-----------------------------------------------------------------
      /// \brief Interface method to return classId of dictionary class.
      //-----------------------------------------------------------------
      virtual INT_2U classId( ) const;

      //-----------------------------------------------------------------
      /// \brief Down grade an object
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Upgrade an object
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      // \brief Return the number of bytes needed to write this object
      //-----------------------------------------------------------------
      virtual INT_8U pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Create a new instance of the object based on the input stream
      //-----------------------------------------------------------------
      virtual FrSH* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      // \brief Write core components to the stream
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      //-----------------------------------------------------------------
      /// \brief Answer requests for information as needed by TOC
      ///
      /// \param[in] InfoClass
      ///     Class of information being requested.
      /// \param[in] vl
      ///     Variable argument list of requested data.
      //-----------------------------------------------------------------
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

      //-----------------------------------------------------------------
      /// \brief Assign the contents of the instance
      ///
      /// \param[in] Stream
      ///     An input stream from which to read information for
      ///     the instance.
      ///
      /// \note
      ///     This has been hidden so programmers are not tempted to
      ///     bypass usage of IFrameStream as the input stream.
      //-----------------------------------------------------------------
      virtual void assign( assign_stream_type& Stream );

    private:
      using Common::FrameSpec::Object::Create;

      //-----------------------------------------------------------------
      /// \brief Dictionary class id for this structure.
      //-----------------------------------------------------------------
      static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FR_SH;

      //-----------------------------------------------------------------
      //-----------------------------------------------------------------
      struct image_t
      {
	//---------------------------------------------------------------
	/// Name of structure being described by this dictionary
	/// structure.
	//---------------------------------------------------------------
	STRING	name;
	//---------------------------------------------------------------
	/// Class number of structure being described
	//---------------------------------------------------------------
	INT_2U	classId;
	//---------------------------------------------------------------
	/// Description of the structure of described.
	//---------------------------------------------------------------
	STRING	comment;
      } m_data;

      FrSH( Common::IStream& Stream );
    }; // class - FrSH

    inline const STRING& FrSH::
    GetName( ) const
    {
      return m_data.name;
    }

    inline INT_2U FrSH::
    GetClass( ) const
    {
      return m_data.classId;
    }

    inline const std::string& FrSH::
    GetComment( ) const
    {
      return m_data.comment;
    }

    inline const char* FrSH::
    StructName( )
    {
      static const CHAR* class_name( "FrSH" );
      return class_name;
    }

  } // namespace - Version_8
} // namespace - FrameCPP
#endif /* FrameCPP__VERSION_8__FrSH_HH */
