/* -*- mode: c++ -*- */
/** \cond IGNORE_BY_DOXYGEN */
#if ! SWIGIMPORTED
%define DOCSTRING
"The frameCPP package for Python allows for Python
developers to interface with the frameCPP library."
"The specification on which this interface is based can be found at:"
"https://dcc.ligo.org/cgi-bin/private/DocDB/ShowDocument?docid=329"
%enddef
#endif /* SWIGIMPORTED */

%module(docstring=DOCSTRING) frameCPP
%feature("autodoc","1");

%begin %{
extern "C"
{
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include <framecpp_config.h>

#include <Python.h>

#if HAVE_NUMPY_ARRAYOBJECT_H
#include <numpy/arrayobject.h>
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
} /* extern "C" */
%}
%{
#include "framecpp/IFrameStream.hh"
#include "framecpp/OFrameStream.hh"
#include "framecpp/GPSTime.hh"

#if HAVE_NUMPY_ARRAYOBJECT_H
#include <numpy/arrayobject.h>
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */

using namespace FrameCPP;

#if HAVE_NUMPY_ARRAYOBJECT_H
#define FRAMECPP_INIT_RETVAL PyMODINIT_FUNC
#else /* HAVE_NUMPY_ARRAYOBJECT_H */
#define FRAMECPP_INIT_RETVAL static void
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
FRAMECPP_INIT_RETVAL
framecpp_init( )
{
#if HAVE_NUMPY_ARRAYOBJECT_H
  import_array( );
#endif /* HAVE_NUMPY_ARRAYOBJECT_H */
}
%}

%{
#include "framecpp/FrVect.hh"

#if 0
  static bool data_type_validation_error = false;

  template< class T, class V>
  inline
  void validate_data_type( const char* ClassInfo, const char* Member )
  {
    if ( typeid( T ) != typeid( V ) )
    {
      std::cerr << "ERROR: " << ClassInfo << "::" << Member
		<< " is of the wrong type"
#if WORKING
		<< " ( " << typeid(T).name( )
		<< " != " << typeid(V).name( ) << " )"
#endif /* WORKING */
		<< std::endl;
      data_type_validation_error = true;
    }
  }

#define VALIDATE_DATA_TYPE(CLASS,MEMBER,REF)	\
  validate_data_type<CLASS::MEMBER, REF>( #CLASS , #MEMBER )
#endif /* 0 */
%}
%init {
  framecpp_init( );
}

%include "frameCPPPython.i"

%include "ldastoolsal/SharedPtr.i"
%include "DataTypes.i"
%include "GPSTime.i"
%include "STRING.i"
%include "Dimension.i"

%include "Container.i"
/* %include "SearchContainer.i" */


%SharedPtr(FrameH)
%SharedPtr(FrAdcData)
%SharedPtr(FrDetector)
%SharedPtr(FrEvent)
%SharedPtr(FrHistory)
%SharedPtr(FrProcData)
%SharedPtr(FrSimData)
%SharedPtr(FrVect)

%include "FrAdcData.i"
%include "FrDetector.i"
%include "FrEvent.i"
%include "FrHistory.i"
%include "FrProcData.i"
%include "FrSimData.i"
%include "FrTOC.i"
%include "FrVect.i"


%include "FrameH.i"

%include "Detectors.i"

%include "IFrameFStream.i"
%include "OFrameFStream.i"
/** \endcond IGNORE_BY_DOXYGEN */
