#include <framecpp_config.h>

#include <stdexcept>

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/IOStream.hh"

#include "framecpp/Detectors.hh"

namespace {
  using ::FrameCPP::FrDetector;

  //---------------------------------------------------------------------
  // HANFORD - Derived from:
  // /archive/frames/S5/L3/LHO/H-RDS_R_L3-8766/H-RDS_R_L3-876699904-256.gwf
  //---------------------------------------------------------------------
  static FrDetector	H1 = FrDetector( "LHO_4k",
					 "H1",
					 -2.08406, 0.810795, 142.554, /* long, lat, elevation */
					 5.65488, 4.084808, /* azimuth */
					 -0.0006195, 0.0000125, /* altitude */
					 1997.54, 1997.52, /* midpoint */
					 0 /* LocalTime */ );
  static FrDetector	H2 = FrDetector( "LHO_2k",
					 "H2",
					 -2.08406, 0.810795, 142.554, /* long, lat, elevation */
					 5.65488, 4.084808, /* azimuth */
					 -0.0006195, 0.0000125, /* altitude */
					 1004.5, 1004.5, /* midpoint */
					 0 /* LocalTime */ );
  //---------------------------------------------------------------------
  // LIVINGSTON - Derived from:
  // /archive/frames/S5/L3/LLO/L-RDS_R_L3-8766/L-RDS_R_L3-876699904-256.gwf
  //---------------------------------------------------------------------
  static FrDetector	L1 = FrDetector( "LLO_4k",
					 "L1",
					 -1.58431, 0.533423, -6.574, /* long, lat, elevation */
					 4.40318, 2.83238, /* azimuth */
					 -0.0003121, -0.0006107, /* altitude */
					 1997.57, 1997.57, /* midpoint */
					 0 /* LocalTime */ );
  //---------------------------------------------------------------------
  // VIRGO - Derived from:
  // /archive/frames/WSR8/HrecV3/Virgo/V-HrecV3-855/V-HrecV3-855302400-2240.gwf
  //---------------------------------------------------------------------
  static FrDetector	V1 = FrDetector( "Virgo",
					 "V1",
					 -10.5045, 43.6316, 51.884, /* long, lat, elevation */
					 -0.3229, 4.3895, /* azimuth */
					 0.0, 0.0, /* altitude */
					 1500.0, 1500.0, /* midpoint */
					 3600 /* LocalTime */ );
}

namespace FrameCPP
{
  const FrDetector&
  GetDetector( detector_location_type Location,
	       const GPSTime& Time )
  {
    switch( Location )
    {
    case DETECTOR_LOCATION_H1:
      return H1;
    case DETECTOR_LOCATION_H2:
      return H2;
    case DETECTOR_LOCATION_L1:
      return L1;
    case DETECTOR_LOCATION_V1:
      return V1;
    default:
      break;
    }
    throw std::range_error( "Unknown detector requested" );
  }
}
