#ifndef FRAME_CPP__COMMON__FR_VECT_HH
#define FRAME_CPP__COMMON__FR_VECT_HH

#include "ldastoolsal/autoarray.hh"
#include "ldastoolsal/SharedArray.hh"

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/Compression.hh"

namespace FrameCPP
{
  namespace Common
  {
    class FrVect
    {
    public:
      typedef INT_4U cmn_compression_scheme_type;
      typedef INT_2U cmn_compression_level_type;

      virtual ~FrVect( );

      virtual Compression::compression_base_type
      Compression( ) const = 0;

      virtual void CompressData( cmn_compression_scheme_type Scheme,
				 cmn_compression_level_type Level ) = 0;

      virtual FrameSpec::Object*
      CloneCompressed( cmn_compression_scheme_type Scheme,
		       cmn_compression_level_type Level ) const = 0;

    protected:
      void compressToBuffer( const Compression::compress_type_mapping&
			     CompressionMapping,
			     const Compression::compress_type_reverse_mapping&
			     CompressionReverseMapping,
			     const Compression::data_type_mapping&
			     DataTypeMapping,
			     const INT_4U DataType,
			     const INT_8U NData,
			     const CHAR_U* Source,
			     const INT_8U SourceNBytes,
			     const INT_4U SourceCompressionMode,
			     LDASTools::AL::AutoArray< CHAR_U >& Dest,
			     INT_8U& DestNBytes,
			     INT_4U& DestCompressionMode,
			     const INT_4U Level ) const;

      void compressToBuffer( const Compression::compress_type_mapping&
			     CompressionMapping,
			     const Compression::compress_type_reverse_mapping&
			     CompressionReverseMapping,
			     const Compression::data_type_mapping&
			     DataTypeMapping,
			     const INT_4U DataType,
			     const INT_8U NData,
			     const CHAR_U* Source,
			     const INT_8U SourceNBytes,
			     const INT_4U SourceCompressionMode,
			     LDASTools::AL::SharedArray< CHAR_U >& Dest,
			     INT_8U& DestNBytes,
			     INT_4U& DestCompressionMode,
			     const INT_4U Level ) const;

      void expandToBuffer( const Compression::compress_type_mapping&
			   CompressionMapping,
			   const Compression::data_type_mapping&
			   DataTypeMapping,
			   const INT_4U DataType,
			   const INT_8U NData,
			   const CHAR_U* Source,
			   const INT_8U SourceNBytes,
			   const INT_4U SourceCompressionMode,
			   const INT_4U SourceByteOrder,
			   LDASTools::AL::AutoArray< CHAR_U >& Dest,
			   INT_8U& DestNBytes ) const;

      void expandToBuffer( const Compression::compress_type_mapping&
			   CompressionMapping,
			   const Compression::data_type_mapping&
			   DataTypeMapping,
			   const INT_4U DataType,
			   const INT_8U NData,
			   const CHAR_U* Source,
			   const INT_8U SourceNBytes,
			   const INT_4U SourceCompressionMode,
			   const INT_4U SourceByteOrder,
			   LDASTools::AL::SharedArray< CHAR_U >& Dest,
			   INT_8U& DestNBytes ) const;

    };

#if ! defined(SWIG)
    inline FrVect::
    ~FrVect( )
    {
    }
#endif /* ! defined(SWIG) */

  } // namespace - Common
} // namespace - FrameCPP

#endif /* FRAME_CPP__COMMON__FR_VECT_HH */
