#include <list>

#include "ConditionData.hh"

using namespace FrameAPI;

enum ifo_type {
  IFO_LHO,
  IFO_LLO,
  IFO_MAX
};

enum run_type {
  RUN_S3,
  RUN_S4
};

struct channel_info_type {
  std::string	s_name;
  int		s_q;

  inline
  channel_info_type( )
  {
  }

  inline
  channel_info_type( const std::string& Name, int Q )
    : s_name( Name ),
      s_q( Q )
  {
  }
};

struct test_data_type {
  ConditionData::frame_files_type			s_files;
  std::list< ConditionData::channel_input_type >	s_channels;
};

typedef std::list< channel_info_type > channel_list;

extern std::list< test_data_type >	test_data;
    
extern void init_tests( );

extern INT_4U GetReduceStartTime( const ifo_type IFO,
				  const unsigned int Frame );
extern INT_4U GetReduceEndTime( const ifo_type IFO,
				const unsigned int Frame );
extern INT_4U GetResampleStartTime( const ifo_type IFO,
				    const unsigned int Frame );
extern INT_4U GetResampleEndTime( const ifo_type IFO,
				  const unsigned int Frame );
extern std::string GetFrameName( const ifo_type IFO, const unsigned int Frame );
extern void GetFrameNames( bool Resample,
			   INT_4U StartTime,
			   INT_4U EndTime,
			   const ifo_type IFO,
			   const run_type Run,
			   int Level,
			   std::list< std::string >& Filenames );
			   
extern void GetChannelList( const ifo_type IFO,
			    const run_type Run,
			    int Level,
			    channel_list& Channels );
