#ifndef FRAMEAPI__UTIL_HH
#define FRAMEAPI__UTIL_HH

#include <string.h>

#include "ldastoolsal/unordered_map.hh"
#include "ldastoolsal/gpstime.hh"

#include "framecpp/FrVect.hh"

//!ignore_begin:


//-----------------------------------------------------------------------------
//
//: Case-Sensitive Compare Operator.
//
struct eqstr
{
    //: Overloaded operator().
    //
    //!param: const char* s1 - First string.
    //!param: const char* s2 - Second string.
    //
    //!return: bool - True if strings are equal, false otherwise.
    //
    bool operator()( const char* s1, const char* s2 ) const
        {
            return strcmp(s1, s2) == 0;
        }
};

typedef LDASTools::AL::unordered_map< std::string, int > QueryHash;

namespace LDASTools
{
  namespace AL
  {
    class GPSTime;
  }
}

namespace FrameCPP
{
  namespace Common
  {
    class MD5Sum;
  }
}

#if HAVE_LDAS_PACKAGE_ILWD
namespace ILwd
{
  class LdasContainer;
}
#endif /* HAVE_LDAS_PACKAGE_ILWD */

namespace FrameAPI
{
  const REAL_8 NANO_SECOND = 1.0e-9;
  const REAL_8 TIME_TOLERANCE = ( 1000 * NANO_SECOND );

  extern int	EnableMemoryMappedIO;
  extern int	StreamBufferSize;

#if HAVE_LDAS_PACKAGE_ILWD
  bool Continuous( const ILwd::LdasContainer& C1,
		   const ILwd::LdasContainer& C2 );
#endif /* HAVE_LDAS_PACKAGE_ILWD */
  bool Continuous( const LDASTools::AL::GPSTime& T1,
		   const LDASTools::AL::GPSTime& T2 );

#if HAVE_LDAS_PACKAGE_ILWD
  LDASTools::AL::GPSTime
  GetEndTime( const ILwd::LdasContainer& C );
#endif /* HAVE_LDAS_PACKAGE_ILWD */
  
#if HAVE_LDAS_PACKAGE_ILWD
  LDASTools::AL::GPSTime
  GetStartTime( const ILwd::LdasContainer& C );
#endif /* HAVE_LDAS_PACKAGE_ILWD */

  FrameCPP::FrVect::compression_scheme_type
  StrToCompressionScheme( const char* Method );

  void LogMD5Sum( const std::string& FrameFilename,
		  const FrameCPP::Common::MD5Sum& MD5,
		  const std::string& OutputDir );

  template <typename Channel>
  REAL_8 SampleRate( const Channel& C );
}

//!ignore_end:
#endif /* FRAMEAPI__UTIL_HH */
