#ifndef DISKCACHE__STREAMS__FSTREAM_HH
#define DISKCACHE__STREAMS__FSTREAM_HH

// General Header Files
#include "ldastoolsal/fstream.hh"

namespace diskCache
{
  namespace Streams
  {
    //-------------------------------------------------------------------
    /// \brief File stream
    ///
    /// This handles a file stream.
    /// As part of handling an output file stream,
    /// this class creates a temporary file.
    /// If there is no issues with the file,
    /// then the temporary file will be renamed.
    //-------------------------------------------------------------------
    class IFStream
      : private ::LDASTools::AL::ifstream
    {
    public:
      typedef ::LDASTools::AL::ifstream	stream_type;

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Filename
      ///     The source filename.
      //-----------------------------------------------------------------
      IFStream( const std::string& Filename );

    private:
      std::string	m_filename;
    };

    //-------------------------------------------------------------------
    /// \brief File stream
    ///
    /// This handles a file stream.
    /// As part of handling an output file stream,
    /// this class creates a temporary file.
    /// If there is no issues with the file,
    /// then the temporary file will be renamed.
    //-------------------------------------------------------------------
    class OFStream
      : public ::LDASTools::AL::ofstream
    {
    public:
      typedef ::LDASTools::AL::ofstream	stream_type;

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Filename
      ///     The destination filename.
      //-----------------------------------------------------------------
      OFStream( const std::string& Filename );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      ~OFStream( );

    private:
      //-----------------------------------------------------------------
      /// \brief Destination filename
      ///
      /// This is the name of the file.
      /// It is used as the base for the temporary name of the file.
      //-----------------------------------------------------------------
      std::string	m_filename;
      //-----------------------------------------------------------------
      /// \brief Temporary filename
      ///
      /// This is the name of the temporary file.
      /// This makes the file creation atomic as the file
      /// is not available till after all the data is written
      /// without encountering an error.
      //-----------------------------------------------------------------
      std::string	m_filename_tmp;
    };

  } /* namespace - Streams */
} /* namespace - diskCache */

#endif /* DISKCACHE__STREAMS__FSTREAM_HH */
