#include <string>

#include "ldastoolsal/unordered_map.hh"

#include "diskcacheAPI/Common/Variables.hh"

SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< diskCache::Common::Variables > )

namespace diskCache
{
  namespace Common
  {
    class Variables::pdata_storage_type
    {
    public:
      struct var_info
      {
	std::string	cache_value;
	reader_ss	reader_ss_func;
	writer_str	writer_str_func;

	var_info( )
	  : reader_ss_func( NULL ),
	    writer_str_func( NULL )
	{
	}
      };

      typedef LDASTools::AL::unordered_map< std::string, var_info > var_container_type;

      var_container_type	vars;

      pdata_storage_type( )
      {
      }

      ~pdata_storage_type( )
      {
      }

    };
    
    Variables::
    Variables( )
      : pdata( new pdata_type::element_type )
    {
    }

    Variables::
    ~Variables( )
    {
    }

    void Variables::
    Cache( const std::string& Name, const std::string& Value )
    {
      pdata_storage_type::var_container_type::iterator
	pos = Instance( ).pdata->vars.find( Name );
      if ( pos == Instance( ).pdata->vars.end( ) )
      {
	std::ostringstream	msg;

	msg << "Unable to locate variable: " << Name;

	throw std::invalid_argument( msg.str( ) );
      }
      pos->second.cache_value = Value;
    }

    void Variables::
    Get( const std::string& Name, std::ostringstream& Value )
    {
      pdata_storage_type::var_container_type::const_iterator
	pos = Instance( ).pdata->vars.find( Name );
      if ( pos == Instance( ).pdata->vars.end( ) )
      {
	std::ostringstream	msg;

	msg << "Unable to locate variable: " << Name;

	throw std::invalid_argument( msg.str( ) );
      }
      if ( pos->second.reader_ss_func )
      {
	(*(pos->second.reader_ss_func))( Value );
      }
    }

    void Variables::
    Init( const std::string& Var,
	  reader_ss RFunc, 
	  writer_str WFunc,
	  const std::string& Default )
    {
      if ( ! Instance( ).pdata )
      {
	Instance( ).pdata.reset( new pdata_type::element_type );
      }

      Instance( ).pdata->vars[ Var ].cache_value = Default;
      Instance( ).pdata->vars[ Var ].reader_ss_func = RFunc;
      Instance( ).pdata->vars[ Var ].writer_str_func = WFunc;
    }

    void Variables::
    Set( const std::string& Name )
    {
      pdata_storage_type::var_container_type::const_iterator
	pos = Instance( ).pdata->vars.find( Name );
      if ( pos == Instance( ).pdata->vars.end( ) )
      {
	std::ostringstream	msg;

	msg << "Unable to locate variable: " << Name;

	throw std::invalid_argument( msg.str( ) );
      }

      if ( pos->second.writer_str_func )
      {
	(*(pos->second.writer_str_func))
	  ( pos->second.cache_value );
      }
    }

    void Variables::
    Set( const std::string& Name, const std::string& Value )
    {
      pdata_storage_type::var_container_type::const_iterator
	pos = Instance( ).pdata->vars.find( Name );
      if ( pos == Instance( ).pdata->vars.end( ) )
      {
	std::ostringstream	msg;

	msg << "Unable to locate variable: " << Name;

	throw std::invalid_argument( msg.str( ) );
      }
      if ( pos->second.writer_str_func )
      {
	(*(pos->second.writer_str_func))( Value );
      }
    }

    void Variables::
    SetReader( const std::string& Var, reader_ss Func )
    {
      if ( ! Instance( ).pdata )
      {
	Instance( ).pdata.reset( new pdata_type::element_type );
      }

      Instance( ).pdata->vars[ Var ].reader_ss_func = Func;
    }

    void Variables::
    SetWriter( const std::string& Var, writer_str Func )
    {
      if ( ! Instance( ).pdata )
      {
	Instance( ).pdata.reset( new pdata_type::element_type );
      }

      Instance( ).pdata->vars[ Var ].writer_str_func = Func;
    }

  }
}
