#ifndef DISKCACHE_API__COMMON__LOGGING_HH
#define DISKCACHE_API__COMMON__LOGGING_HH

#include "genericAPI/Logging.hh"

namespace diskCache
{
  namespace Common
  {
    class LogMessage
    {
    public:
      typedef std::ostringstream ostream;

      enum message_type {
	LM_DEBUG = GenericAPI::LogEntryGroup_type::MT_DEBUG,
	LM_NOTE = GenericAPI::LogEntryGroup_type::MT_NOTE,
	LM_MAIL = GenericAPI::LogEntryGroup_type::MT_MAIL
      };

      //---------------------------------------------------------------------------
      /// \brief Default constructor
      //---------------------------------------------------------------------------
      LogMessage( );

      message_type MessageType( ) const;

      void MessageType( message_type Type );

      const ostream& Message( ) const;

      ostream& operator()( );

      ostream& operator()( message_type Type );

    private:
      message_type	m_message_type;
      ostream		m_message;
    };

    inline LogMessage::message_type LogMessage::
    MessageType( ) const
    {
      return m_message_type;
    }

    inline void LogMessage::
    MessageType( message_type Type )
    {
      switch( m_message_type )
      {
      case LM_DEBUG:
	if ( Type == LM_NOTE )
	{
	  m_message_type = Type;
	}
	//-----------------------------------------------------------------
	// Fall through for higher values of Type
	//-----------------------------------------------------------------
      case LM_NOTE:
	if ( Type == LM_MAIL )
	{
	  m_message_type = Type;
	}
	//-----------------------------------------------------------------
	// Fall through for higher values of Type
	//-----------------------------------------------------------------
      case LM_MAIL:
	//-----------------------------------------------------------------
	// Nothing to do because the error level has already been
	// set to the highest value
	//-----------------------------------------------------------------
	break;
      }
    }

    inline const LogMessage::ostream& LogMessage::
    Message( ) const
    {
      return m_message;
    }

    inline LogMessage::ostream& LogMessage::
    operator()( )
    {
      return m_message;
    }

    inline LogMessage::ostream& LogMessage::
    operator()( message_type Type )
    {
      MessageType( Type );
      return m_message;
    }
  } // namespace - diskCache::Common
} // namespace - diskCache

#endif /* DISKCACHE_API__COMMON__LOGGING_HH */
