# -*- mode: RPM-SPEC; indent-tabs-mode: nil -*-
%define _docdir %{_datadir}/doc/ldas-tools-%{version}

Summary: LDAS tools libdiskcacheAPI toolkit runtime files
Name: ldas-tools-diskcacheAPI
Version: 2.5.0
Release: 1%{?dist}
License: ?
URL: http://www.ligo.caltech.edu
Group: Application/Scientific
BuildRoot: %{buildroot}
Source0: http://software.ligo.org/lscsoft/source/ldas-tools-diskcacheAPI-%{version}.tar.gz
Requires: ldas-tools-al
Requires: ldas-tools-ldasgen
Buildrequires: autoconf
Buildrequires: automake
Buildrequires: bison
Buildrequires: doxygen
Buildrequires: flex
Buildrequires: ldas-tools-al-devel
Buildrequires: libtool
Buildrequires: openssl-devel
Buildrequires: pkgconfig
Buildrequires: python-devel
Buildrequires: swig
Buildrequires: zlib-devel
Buildrequires: ldas-tools-ldasgen-devel >= 2.4.99

%description
This provides the runtime libraries for the diskcacheAPI library.

%package python
Group: Application/Scientific
Summary: Python% extension for the disk cache
Requires: ldas-tools-diskcacheAPI
%description python
This provides the libraries needed to utilize the disk cache library
from within Python

%package devel
Group: Development/Scientific
Summary: LDAS tools libdiskcacheAPI toolkit development files
Requires: ldas-tools-ldasgen-devel
Requires: ldas-tools-diskcacheAPI
%description devel
This provides the develpement files the diskcacheAPI library.

%prep

%setup -q

%build

#------------------------------------------------------------------------
# This works around a bug in the current rpmbuild system whereby the
#   PKG_CONFIG_PATH is set by the system and does not allow for
#   user preference.
# This work around should be fixed in RH 7.1 or so
#------------------------------------------------------------------------
export PKG_CONFIG_PATH="${LDASTOOLSDEV_PKG_CONFIG_PATH:-}${LDASTOOLSDEV_PKG_CONFIG_PATH:+:}$PKG_CONFIG_PATH"

%configure --with-optimization=high --disable-tcl --enable-python --docdir=%{_docdir}
make V=1 %{?_smp_mflags}
make V=1 check

%install
rm -rf %{buildroot}
#--------------------------------------------------------------
# install lscsoft specific files
#--------------------------------------------------------------
make V=1 install DESTDIR=%{buildroot}
#--------------------------------------------------------------
#--------------------------------------------------------------
find %{buildroot} -name \*.la -exec rm -f {} \;
rm -f %{buildroot}%{python_sitearch}/LDAStools/_*.*a
rm -f %{buildroot}%{python_sitearch}/LDAStools/libdiskcacheAPI_python.*a

%post
ldconfig
%postun
ldconfig

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{_bindir}/diskcache
%{_bindir}/ldas-cache-dump-verify
%{_libdir}/ldas-tools/libdiskcache*.so.*
%{_sysconfdir}/initd.d/diskcached
%{_docdir}/diskcache_poller
%{_docdir}/diskcache_server

%files python
%defattr(-,root,root,-)
%{python_sitearch}/LDAStools/diskCache.py*
%{python_sitearch}/LDAStools/_diskCache.so*
%{python_sitearch}/LDAStools/Stream.py*
%{python_sitearch}/LDAStools/_Stream.so*
%{python_sitearch}/LDAStools/libdiskcacheAPI_python.so*

%files devel
%defattr(-,root,root)
%{_includedir}/diskcacheAPI
%{_libdir}/ldas-tools/libdiskcache.*a
%{_libdir}/ldas-tools/libdiskcache*.so
%{_docdir}/diskcache
%{_libdir}/pkgconfig/ldas-tools-diskcache.pc

%post python
/bin/touch %{python_sitearch}/LDAStools/__init__.py

%postun python
if [ -d %{python_sitearch}/LDAStools ];
then
        if [ `ls -1 %{python_sitearch}/LDAStools | wc -l` -le 1 ];
        then
                rm -rf %{python_sitearch}/LDAStools
        fi
fi

%changelog
* Wed Mar 23 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.4-1
- Made build be verbose

* Fri Mar 11 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.1-1
- Corrections for RPM build

* Thu Mar 03 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.0-1
- Breakout into separate source package

* Tue Oct 11 2011 Edward Maros <ed.maros@ligo.org> - 1.19.13-1
- Initial build.
