#ifndef LDASTOOLSAL__PS_INFO_HH
#define LDASTOOLSAL__PS_INFO_HH

#include <sys/types.h>
#include <unistd.h>

#include <string>

namespace LDASTools
{
  namespace AL
  {
    /// \brief  Class to retrieve process information.
    class PSInfo
    {
    public:
      /// \brief  Structure to hold information about a process.
      struct psinfo_type {
	pid_t		s_pid;
	char		s_state;
	std::string	s_user;
	size_t		s_vsz;
	size_t		s_rsz;
	float		s_pcpu;
	float		s_pmem;
	int		s_etime;
	std::string	s_fname;
	std::string	s_args;
      };

      /// \brief  Constructor
      PSInfo( pid_t PID = getpid( ) );

      /// \brief  Obtain information about a process
      void operator()( psinfo_type& Query ) const;

    private:
      /// \brief  Process identification.
      pid_t	m_pid;
    };
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__PS_INFO_HH */
