#ifndef LDAS_TOOLS_AL__CONFIG_HH
#define LDAS_TOOLS_AL__CONFIG_HH

#include <iosfwd>

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// \brief Support reading and parsing of configuration streams.
    ///
    /// This class supports reading from a stream and parses.
    //-------------------------------------------------------------------
    class Config
    {
    public:
      //-----------------------------------------------------------------
      /// \brief The various types of parsing understood by the parser
      //-----------------------------------------------------------------
      enum {
	ASSIGNMENT,	///< %<var%> = %<value%>
	BLOCK,		///< [%<var%>]
	WORD		///< %<word%>
      };

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      //-----------------------------------------------------------------
      Config( );

      //-----------------------------------------------------------------
      /// \brief Parse the input stream
      ///
      /// \param[in] Stream
      ///     Input stream.
      //-----------------------------------------------------------------
      virtual void Parse( std::istream& Stream );

      virtual void ParseBlock( const std::string& Value ) = 0;

      virtual void ParseKeyValue( const std::string& Key,
				  const std::string& Value ) = 0;

      virtual void ParseWord( const std::string& Value ) = 0;

    private:
    };
  }
}

#endif /* LDAS_TOOLS_AL__CONFIG_HH */
