dnl ---------------------------------------------------------------------
dnl  AX_LDAS_CXX_TEMPLATE_AS_TEMPLATE_PARAMETER
dnl     Check if C++ supports templates as parameters
dnl ---------------------------------------------------------------------
AC_DEFUN([AX_LDAS_CXX_TEMPLATE_AS_TEMPLATE_PARAMETER],
[ AC_MSG_CHECKING([if the C++ compiler supports template as template parameter])
  AC_LANG_PUSH([C++])
  AC_TRY_COMPILE([
  #include <algorithm>

  template< class T >
  inline T* DeletePtr( T* Ptr )
  {
    delete Ptr;
    return (T*)0;
  }

  template< class O, template<class> class C >
  inline void Purge( C< O* >& Container )
  {
    std::transform( Container.begin( ), Container.end( ),
		    Container.begin( ), DeletePtr< O > );
  }  
  ],[
  std::list< int* >	s;

  Purge( s );
  ],[
  AC_DEFINE([SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS],[1],[Defined if C++ supports templates as template parameters])
  AC_MSG_RESULT([yes])
  SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS=1
  ],[
  AC_MSG_RESULT([no])
  SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS=0
  ])
  AC_SUBST([SUPPORTED_TEMPLATES_AS_TEMPLATE_PARAMETERS])
  AC_LANG_POP([C++])
])
