dnl ---------------------------------------------------------------------
dnl  AX_LDAS_CXX_EXCEPTIONS_RETHROW
dnl     Check if C++ supports exceptions rethrowing
dnl ---------------------------------------------------------------------
AC_DEFUN([AX_LDAS_CXX_EXCEPTIONS_RETHROW],[
  dnl -------------------------------------------------------------------------
  dnl Check how well compiler handles exceptions
  dnl -------------------------------------------------------------------------

  AC_MSG_CHECKING(if compiler supports rethrowing of exceptions)
  AC_TRY_RUN([
  #include <iostream>
  #include <stdexcept>

  //
  // Extended bad_exception class with info on exception no handled in the
  // throw specifier
  //

  class unhandled: public std::bad_exception
  {
  public:
    unhandled( const std::string& what )
      : m_what( what )
    {
    }
  
    ~unhandled() throw() {}
  
    virtual const char*
    what() const throw()
    {
      return m_what.c_str();
    }
  
  private:
    std::string m_what;
  };

  //
  // New handler for unexpected exceptions
  //

  void
  handle_unexpected( void )
  {
    try {
      throw;
    }
    catch( const std::logic_error& e )
    {
	exit( 0 );
    }
  }

  //
  // Problem do to logic_error not being in throw specification
  //

  void
  c3( void ) throw ( std::bad_exception )
  {
    throw std::logic_error("c3");
  }

  int
  main()
  {
    std::set_unexpected( handle_unexpected );
  
    try {
      c3();
    }
    catch ( const std::logic_error& e )
    {
      exit (1);
    }
    catch ( const std::bad_exception& e )
    {
      exit (0);
    }
    return( 1 );
  }
  ],[AC_DEFINE([HAVE_RETHROW_WORKING_IN_BAD_EXCEPTION],
               [1],
	       [Defined if retrow works in bad_exception])
  AC_MSG_RESULT(yes)],[AC_MSG_RESULT(no)])

])
