/* -*- mode: c++; c-basic-offset: 2; indent-tabs-mode: nil; -*- */

#ifndef GENERAL__SHARED_ARRAY_HH
#define GENERAL__SHARED_ARRAY_HH
   
#if defined(SWIG)
%include <SharedPtr.i>
#else
#include "ldastoolsal/Memory.hh"
#endif /* ! defined(SWIG) */

#define SHARED_ARRAY_NAMESPACE NAMESPACE_GENERAL_MEMORY

#define SHARED_ARRAY_CLASS shared_ptr

namespace LDASTools
{
  namespace AL
  {
    template< typename T >
    class SharedArray
      : public SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >
    {
    public:
      typedef SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >     base_type;

      typedef typename base_type::element_type element_type;

      inline explicit SharedArray( T* Array = (T*)NULL )
        : SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >( Array, deleter( ) )
      {
      }

      template< typename D >
      inline SharedArray( T* Array, D del )
        : SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >( Array, del )
      {
      }

      inline SharedArray( SharedArray< T > const & Array )
        : SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >( Array )
      {
      }

      inline void reset( T* Array = (T*)NULL )
      {
        SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >::reset( Array, deleter( ) );
      }

      template< typename D >
      inline void reset( T* Array, D del )
      {
        SHARED_ARRAY_NAMESPACE::SHARED_ARRAY_CLASS< T >::reset( Array, del );
      }

      inline void swap( SharedArray< T >& RHS )
      {
        base_type::swap( RHS );
      }

      inline T& operator[]( std::ptrdiff_t Index ) const
      {
        return this->get( )[ Index ];
      }

    private:
      struct deleter
      {
        void operator( )( T* Ptr )
        {
          delete[] Ptr;
        }
      };

    };
  } // namespace - AL
} // namespace - LDASTools

template< typename T >
inline bool
operator==( LDASTools::AL::SharedArray< T > const& LHS,
            LDASTools::AL::SharedArray< T > const& RHS )
{
  return typename LDASTools::AL::SharedArray< T >::base_type( LHS )
    == typename LDASTools::AL::SharedArray< T >::base_type( RHS );
}

template< typename T >
inline bool
operator==( LDASTools::AL::SharedArray< T > const& LHS,
            typename LDASTools::AL::SharedArray< T >::base_type const& RHS )
{
  return typename LDASTools::AL::SharedArray< T >::base_type( LHS ) == RHS;
}

template< typename T >
inline bool
operator==( typename LDASTools::AL::SharedArray< T >::base_type const& LHS,
            LDASTools::AL::SharedArray< T > const& RHS )
{
  return LHS == typename LDASTools::AL::SharedArray< T >::base_type( RHS );
}

template< typename T >
inline bool
operator!=( LDASTools::AL::SharedArray< T > const& LHS,
            LDASTools::AL::SharedArray< T > const& RHS )
{
  return ! ( LHS == RHS );
}

template< typename T >
inline bool
operator!=( LDASTools::AL::SharedArray< T > const& LHS,
            typename LDASTools::AL::SharedArray< T >::base_type const& RHS )
{
  return ! ( LHS == RHS );
}

template< typename T >
inline bool
operator!=( typename LDASTools::AL::SharedArray< T >::base_type const& LHS,
            LDASTools::AL::SharedArray< T > const& RHS )
{
  return ! ( LHS == RHS );
}

template< typename T >
inline bool
operator<( LDASTools::AL::SharedArray< T > const& LHS,
           LDASTools::AL::SharedArray< T > const& RHS )
{
  return typename LDASTools::AL::SharedArray< T >::base_type( LHS )
    < typename LDASTools::AL::SharedArray< T >::base_type( RHS );
}

template< typename T >
inline bool
operator<( LDASTools::AL::SharedArray< T > const& LHS,
           typename LDASTools::AL::SharedArray< T >::base_type const& RHS )
{
  return typename LDASTools::AL::SharedArray< T >::base_type( LHS )
    < RHS;
}

template< typename T >
inline bool
operator<( typename LDASTools::AL::SharedArray< T >::base_type const& LHS,
           LDASTools::AL::SharedArray< T > const& RHS )
{
  return LHS
    < typename LDASTools::AL::SharedArray< T >::base_type( RHS );
}

template< typename T >
inline void
swap( LDASTools::AL::SharedArray< T > const& LHS,
      LDASTools::AL::SharedArray< T > const& RHS )
{
  LHS.swap( RHS );
}

#endif /* GENERAL__SHARED_ARRAY_HH */
