#ifndef General__PtrHash_HH
#define General__PtrHash_HH

#include "ldastoolsal/unordered_map.hh"

namespace LDASTools
{
  namespace AL
  {
    struct PtrHash
      : std::unary_function< const void*, size_t>
    {
      size_t operator()( const void* Key ) const
      {
#if SIZEOF_VOIDP == SIZEOF_LONG_LONG
	typedef unsigned long long hash_type;
#elif SIZEOF_VOIDP == SIZEOF_LONG
	typedef unsigned long hash_type;
#endif
	union {
	  const void*	s_ptr;
	  hash_type	s_hash_key;
	} hk;

	LDASTools::AL::hash< hash_type >	h;

	hk.s_ptr = Key;
	hk.s_hash_key >>= 3; // Shift down since data should be byte aligned.
	return h( hk.s_hash_key );
      }
    };
  } // namespace - AL
} // namespace - LDASTools
#endif /* General__PtrHash_HH */
