/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__POOL_HH
#define LDASTOOLSAL__POOL_HH

#include <stdexcept>
#include <list>

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/SharedPtr.hh"

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------
    /// \brief Maintain a collection system calls
    //-------------------------------------------------------------
    template< typename T >
    class Pool
    {
    public:
      typedef T	value_type;

      Pool( );

      void		Relinquish( value_type Source );

      value_type	Request( value_type (*CreateFunc)( ) );

    private:
      typedef std::list< value_type > pool_type;
    
      pool_type			m_available;
      MutexLock::baton_type	m_baton;
    };

    template< typename T >
    Pool< T >::
    Pool( )
      : m_baton( __FILE__, __LINE__ )
    {
    }

    template< typename T >
    void Pool< T >::
    Relinquish( value_type Source )
    {
      MutexLock	l( m_baton,
		   __FILE__, __LINE__ );

      m_available.push_back( Source );
    }
  
    template< typename T >
    T Pool< T >::
    Request( value_type (*CreateFunc)( ) )
    {
      MutexLock	l( m_baton,
		   __FILE__, __LINE__ );

      value_type	retval;
      if ( m_available.empty( ) )
      {
	retval = (*CreateFunc)( );
      }
      else
      {
	retval = m_available.back( );
	m_available.pop_back( );
      }

      return retval;
    }
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__POOL_HH */
