/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERAL__CONDITIONAL_VARIABLE_HH
#define GENERAL__CONDITIONAL_VARIABLE_HH

#include "ldastoolsal/types.hh"
#include "ldastoolsal/SharedPtr.hh"
#include "ldastoolsal/mutexlock.hh"

namespace LDASTools
{
  namespace AL
  {
    //---------------------------------------------------------------------
    /// \brief Thread syncronization based on condition
    //---------------------------------------------------------------------
    class ConditionalVariable
    {
    public:
      //-------------------------------------------------------------------
      /// \brief Constructor - Default
      //-------------------------------------------------------------------
      ConditionalVariable( );
      //-------------------------------------------------------------------
      /// \brief Destructor
      //-------------------------------------------------------------------
      ~ConditionalVariable( );
      //-------------------------------------------------------------------
      /// \brief Awaken some thread waiting on condition
      //-------------------------------------------------------------------
      void Broadcast( );
      //-------------------------------------------------------------------
      /// \brief Return the lock associated with condition
      //-------------------------------------------------------------------
      MutexLock::baton_type Mutex( );
      //-------------------------------------------------------------------
      /// \brief Release lock associated with condition.
      //-------------------------------------------------------------------
      void Release( );
      //-------------------------------------------------------------------
      /// \brief Awaken a blocked thread
      //-------------------------------------------------------------------
      void Signal( );
      //-------------------------------------------------------------------
      /// \brief Timed block on condition
      //-------------------------------------------------------------------
      bool TimedWait( INT_4U Seconds );
      //-------------------------------------------------------------------
      /// \brief Block on condition
      //-------------------------------------------------------------------
      void Wait( );

    private:

      class impl;
      SharedPtr< impl > pimpl_;

      ConditionalVariable( const ConditionalVariable& Source );
      ConditionalVariable& operator=( const ConditionalVariable& Source );
    };
  } // namespace - AL
} // namespace - LDASTools

#endif /* GENERAL__CONDITIONAL_VARIABLE_HH */

