%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts %{nil}

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalburst
Version: 1.5.5
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Burst Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: lal-devel >= 7.0.0
BuildRequires: lalmetaio-devel >= 1.6.0
BuildRequires: lalsimulation-devel >= 2.1.0
BuildRequires: libmetaio-devel
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: pytest
BuildRequires: python-devel
BuildRequires: python-pathlib
BuildRequires: python2-glue
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-lalmetaio >= 1.6.0
BuildRequires: python2-lalsimulation >= 2.1.0
BuildRequires: python2-ligo-lw
BuildRequires: python2-matplotlib
BuildRequires: python2-mock
BuildRequires: python2-numpy
BuildRequires: python2-rpm-macros
BuildRequires: python2-scipy

# python3x
BuildRequires: epel-rpm-macros
BuildRequires: python-srpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-glue
BuildRequires: python%{python3_pkgversion}-lal >= 7.0.0
BuildRequires: python%{python3_pkgversion}-lalmetaio >= 1.6.0
BuildRequires: python%{python3_pkgversion}-lalsimulation >= 2.1.0
BuildRequires: python%{python3_pkgversion}-ligo-lw
BuildRequires: python%{python3_pkgversion}-matplotlib
BuildRequires: python%{python3_pkgversion}-numpy
BuildRequires: python%{python3_pkgversion}-pytest
BuildRequires: python%{python3_pkgversion}-scipy
BuildRequires: python3-rpm-macros

# octave
BuildRequires: lal-octave >= 7.0.0
BuildRequires: lalmetaio-octave >= 1.6.0
BuildRequires: lalsimulation-octave >= 2.1.0
BuildRequires: octave-devel

# -- packages ---------------

# lalburst
Requires: gsl
Requires: libmetaio
Requires: lal >= 7.0.0
Requires: lalmetaio >= 1.6.0
Requires: lalsimulation >= 2.1.0

%description
The LSC Algorithm Burst Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Burst library.

# lalburst-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL Burst
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: libmetaio-devel
Requires: lal-devel >= 7.0.0
Requires: lalmetaio-devel >= 1.6.0
Requires: lalsimulation-devel >= 2.1.0
%description devel
The LSC Algorithm Burst Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Burst
library.

# python2-lalburst
%package -n python2-%{name}
Summary: Python %{python2_version} Bindings for LALBurst
Group: LAL
Requires: %{name} = %{version}
Requires: gsl
Requires: python
Requires: python2-glue
Requires: python2-lal >= 7.0.0
Requires: python2-lalmetaio >= 1.6.0
Requires: python2-lalsimulation >= 2.1.0
Requires: python2-ligo-lw
Requires: python2-ligo-segments
Requires: python2-numpy
Requires: python2-scipy
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings for LALBurst.

# python3x-lalburst
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python2_version} Bindings for LALBurst
Group: LAL
Requires: %{name} = %{version}
Requires: gsl
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-glue
Requires: python%{python3_pkgversion}-lal >= 7.0.0
Requires: python%{python3_pkgversion}-lalmetaio >= 1.6.0
Requires: python%{python3_pkgversion}-lalsimulation >= 2.1.0
Requires: python%{python3_pkgversion}-ligo-lw
Requires: python%{python3_pkgversion}-ligo-segments
Requires: python%{python3_pkgversion}-numpy
Requires: python%{python3_pkgversion}-scipy
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALBurst.

# lalburst-octave
%package octave
Summary: Octave Bindings for LALBurst
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.0.0
Requires: lalmetaio-octave >= 1.6.0
Requires: lalsimulation-octave >= 2.1.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALBurst.

# -- build-stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
[ -d %py3dir/test/python ] && %{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalburst_version
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalburst.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 1.5.5-1
- Update for 1.5.5

* Fri Dec 20 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.4-1
- snglcoinc: fix rate_factors for more than two detector cases

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.3-3
- Packaging updates

* Thu Dec 05 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.3-2
- Packaging updates

* Mon Nov 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.3-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.2-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.5.1-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.4.4-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.3-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.2-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.4.1-1
- Pre O2 packaging test release
