/*
 * LALVCSInfo.h - LAL VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALVCSINFO_H
#define _LALVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalVCSVersion;
extern const char *const lalVCSId;
extern const char *const lalVCSDate;
extern const char *const lalVCSBranch;
extern const char *const lalVCSTag;
extern const char *const lalVCSAuthor;
extern const char *const lalVCSCommitter;
extern const char *const lalVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalVCSIdentId;
extern const char *const lalVCSIdentDate;
extern const char *const lalVCSIdentBranch;
extern const char *const lalVCSIdentTag;
extern const char *const lalVCSIdentAuthor;
extern const char *const lalVCSIdentCommitter;
extern const char *const lalVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalVCSInfo;

/* configure arguments */
extern const char *const lalConfigureArgs;

/* configure date */
extern const char *const lalConfigureDate;

/* build date */
extern const char *const lalBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
