/*====================================================================

 	ǡ١Ͽ
						S.Kurohashi 92/11/05

	Usage: make_db database_name [-append string|-and|-or]

	-append  Ʊ쥭ä append (default)
		 (string϶ڤʸ defaultϤʤ)
	-and     Ʊ쥭ä merge  (ǡ0-1٥ȥ)
	-or      Ʊ쥭ä merge  (ǡ0-1٥ȥ)

====================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dbm.h"

#ifndef DBM_KEY_MAX
#define DBM_KEY_MAX 	1024
#endif
#ifndef DBM_CON_MAX
#define DBM_CON_MAX	1638400
#endif

extern DBM_FILE db_write_open(char *filename);
extern int db_put(DBM_FILE db, char *buf, char *value, char *Separator, int mode);
extern void DB_close(DBM_FILE db);

int content_process(char *content, char **pre_content, int *pre_content_size, 
		    int Type, char *Separator)
{
    int content_len = strlen(content);

    if (Type == DBM_OVERRIDE) {
	if (*pre_content_size == 0) {
	    *pre_content_size = DBM_CON_MAX;
	    *pre_content = (char *)malloc(*pre_content_size);
	}

	while (content_len >= *pre_content_size) {
	    *pre_content = (char *)realloc(*pre_content, *pre_content_size *= 2);
	}
	strcpy(*pre_content, content);
    }
    else if (Type == DBM_APPEND) {
	content_len += strlen(*pre_content);
	if (Separator) {
	    content_len += strlen(Separator);
	}
	while (content_len >= *pre_content_size) {
	    *pre_content = (char *)realloc(*pre_content, *pre_content_size *= 2);
	}
	if (Separator) {
	    strcat(*pre_content, Separator);
	}
	strcat(*pre_content, content);
    }
    else if (Type == DBM_OR) {
	int i;

	for (i = 0; i < strlen(*pre_content); i++) {
	    if (*(content + i) == '1') {
		*(*pre_content + i) = '1';
	    }
	}
    }
    else if (Type == DBM_AND) {
	int i;

	for (i = 0; i < strlen(*pre_content); i++) {
	    if (*(content + i) == '0') {
		*(*pre_content + i) = '0';
	    }
	}
    }
}

int main(int argc, char *argv[])
{
    DBM_FILE db;
    int Type, num, pre_content_size = 0;
    char *Separator = NULL, *cp;
    char key[DBM_KEY_MAX], content[DBM_CON_MAX];
    char buffer[DBM_CON_MAX], pre_key[DBM_KEY_MAX], *pre_content;

    if (argc == 2) {
	Type = DBM_APPEND;
    } else if (argc == 3 && !strcmp(argv[2], "-append")) {
	Type = DBM_APPEND;
    } else if (argc == 4 && !strcmp(argv[2], "-append")) {
	Type = DBM_APPEND;
	Separator = strdup(argv[3]);
    } else if (argc == 3 && !strcmp(argv[2], "-and")) {
	Type = DBM_AND;
    } else if (argc == 3 && !strcmp(argv[2], "-or")) {
	Type = DBM_OR;
    } else {
	fprintf(stderr,"usage: %s database_name [-append string|-and|-or]\n",argv[0]);
	exit(1);
    }

    /* ǡ١ */
    db = db_write_open(argv[1]);
    fprintf(stderr, "Create Database <%s>.\n", argv[1]);

    pre_key[0] = '\0';
    buffer[DBM_CON_MAX - 1] = '\n';
    num = 0;
    while (fgets(buffer, DBM_CON_MAX, stdin) != NULL) {
	/* ԤĹå */
	if (buffer[DBM_CON_MAX - 1] != '\n') {
	    fprintf(stderr, "Line %d is larger than %d bytes.\n", num, DBM_CON_MAX);
	    exit(1);
	}

	/* Ĺå */
	if (cp = strchr(buffer, ' ')) {
	    if (cp - buffer >= DBM_KEY_MAX) {
		fprintf(stderr, "Key is too long (in %s).\n", buffer);
		exit(1);
	    }
	}
	else {
	    /* ڡʤȤ (ڡ\0ޤҤä) */
	    fprintf(stderr, "Line %d is strange.\n", num);
	    if ((num++ % 1000) == 0) fputc('*', stderr);
	    continue;
	}

	/* keycontentʬΥ */
	sscanf(buffer, "%s %[^\n]", key, content);
	if ((num++ % 1000) == 0) fputc('*', stderr);

	/* ľkeyƱʤϢ뤷¸ */
	if (!strcmp(pre_key, key)) {
	    content_process(content, &pre_content, &pre_content_size, Type, Separator);
	}
	else {
	    /* 񤭹 */
	    if (pre_key[0]) {
		db_put(db, pre_key, pre_content, Separator, Type);
	    }

	    strcpy(pre_key, key);
	    content_process(content, &pre_content, &pre_content_size, DBM_OVERRIDE, Separator);
	}
    }

    if (pre_key[0]) {
	db_put(db, pre_key, pre_content, Separator, Type);
    }

    if (pre_content_size > 0) {
	free(pre_content);
    }
    if (Separator) {
	free(Separator);
    }

    fputc('\n', stderr);

    DB_close(db);
    return 0;
}
