/*====================================================================

			     FEATURE

                                               S.Kurohashi 96. 7. 4

    $Id: feature.c,v 1.77.2.1 2009/10/19 23:34:31 kawahara Exp $
====================================================================*/
#include "knp.h"

/*
  FEATUREνˤϼΣब

  	(1) ե(Sޤʸ) ==ԡ==> 롼빽¤

	(2) 롼빽¤ ==Ϳ==> Ǥޤʸṽ¤
        	<:><:>ȤFEATUREؤξ (ʤп)
                <^><:>κ (ʤ̵)
		<&>ϴؿƽ
			&ɽ:Ϳ -- ˤɽسͿ
			&ɽ: -- ٤Ƥɽسʺ
			&ɽ: -- Ϳ
			&ɽ:^ -- ʺ
			&MEMO: -- MEMOؤν񤭹

	(3) 롼빽¤ <==ȹ==> Ǥޤʸṽ¤
	       	<><:>ȤFEATUREOK
	    	<^><:>ȤFEATUREʤOK
	    	<&>ϴؿƽ
			&ѿ -- ɽ,ʸ,, ()
			& -- ɽ ()
	    		&ɽ: -- ʤ (ʸ)
	    		&ɽ:ȹ -- ɽسʤˤ ()
			&D:n -- ¤δ֤Υn ()
			&٥: -- ʾ ()
			&٥:l -- Ȥlʾ ()
			&¦: -- ˡ ()

	 ץǷǤޤʸṽ¤ΤFEATUREͿ
	(2)Τʤ assign_cfeature Ѥ롥

	 ץǷǤޤʸṽ¤ΤFEATURE
	ɤĴ٤(3)Τʤ check_feature Ѥ롥
*/

char feature_buffer[DATA_LEN];

/*==================================================================*/
	    void print_one_feature(char *cp, FILE *filep)
/*==================================================================*/
{
    if (!strncmp(cp, "Ϳ:", strlen("Ϳ:"))) { /* ͿΤɽȤ(-nbest) */
	if (OptExpress == OPT_TABLE)
	    fprintf(filep, "%s", cp + strlen("Ϳ:")); 
	else
	    fprintf(filep, "<%s>", cp + strlen("Ϳ:")); 
    }
    else {
	if (OptExpress == OPT_TABLE)
	    fprintf(filep, "%s", cp);
	else
	    fprintf(filep, "<%s>", cp);
    }
}

/*==================================================================*/
	      void print_feature(FEATURE *fp, FILE *filep)
/*==================================================================*/
{
    /* <f1><f2> ... <f3> Ȥν 
       (ԤǤϤޤfeatureɽʤ) */

    while (fp) {
	if (fp->cp && 
	    (strncmp(fp->cp, "", strlen("")) ||
	     OptDisplay == OPT_DEBUG))
	    print_one_feature(fp->cp, filep);
	fp = fp->next;
    }
}

/*==================================================================*/
	  void print_some_feature(FEATURE *fp, FILE *filep)
/*==================================================================*/
{
    /* <f1><f2> ... <f3> Ȥν 
       ꤷΤɽ */

    while (fp) {
	if (fp->cp && strncmp(fp->cp, "", strlen("")) && !strncmp(fp->cp, "C", 1))
	    print_one_feature(fp->cp, filep);
	fp = fp->next;
    }
}
/*==================================================================*/
	      void print_feature2(FEATURE *fp, FILE *filep)
/*==================================================================*/
{
    /* (f1 f2 ... f3) Ȥν
       (ԤǤϤޤfeatureɽʤ) */
    if (fp) {
	fprintf(filep, "("); 
	while (fp) {
	    if (fp->cp && strncmp(fp->cp, "", strlen(""))) {
		fprintf(filep, "%s", fp->cp); 
		if (fp->next) fprintf(filep, " "); 		
	    }
	    fp = fp->next;
	}
	fprintf(filep, ")"); 
    } else {
	fprintf(filep, "NIL"); 
    }
}

/*==================================================================*/
		   void clear_feature(FEATURE **fpp)
/*==================================================================*/
{
    FEATURE *fp, *next;

    fp = *fpp;
    *fpp = NULL;

    while (fp) {
	next = fp->next;
	free(fp->cp);
	free(fp);
	fp = next;
    }
}

/*==================================================================*/
	   void delete_cfeature(FEATURE **fpp, char *type)
/*==================================================================*/
{
    FEATURE *prep = NULL;

    while (*fpp) {
	if (comp_feature((*fpp)->cp, type) == TRUE) {
	    FEATURE *next;
	    free((*fpp)->cp);
	    if (prep == NULL) {
		next = (*fpp)->next;
		free(*fpp);
		*fpp = next;
	    }
	    else {
		next = (*fpp)->next;
		free(*fpp);
		prep->next = next;
	    }
	    return;
	}
	prep = *fpp;
	fpp = &(prep->next);
    }
}

/*==================================================================*/
		void delete_alt_feature(FEATURE **fpp)
/*==================================================================*/
{
    /* <ALT-...> */

    FEATURE *prep = NULL;

    while (*fpp) {
	if (!strncmp((*fpp)->cp, "ALT-", 4)) {
	    FEATURE *next;
	    free((*fpp)->cp);
	    if (prep == NULL) {
		next = (*fpp)->next;
		free(*fpp);
		*fpp = next; /* prepNULLΤޤ */
	    }
	    else { /* prepȤ */
		next = (*fpp)->next;
		free(*fpp);
		prep->next = next; /* prepϸݻ */
		fpp = &(prep->next);
	    }
	}
	else {
	    prep = *fpp;
	    fpp = &(prep->next);
	}
    }
}

/*==================================================================*/
void delete_cfeature_from_mrphs(MRPH_DATA *m_ptr, int length, char *type)
/*==================================================================*/
{
    int i;

    for (i = 0; i < length; i++) {
	delete_cfeature(&((m_ptr + i)->f), type);
    }
}

/*==================================================================*/
	       void delete_temp_feature(FEATURE **fpp)
/*==================================================================*/
{
    /* Ϳfeature */

    FEATURE *prep = NULL;

    while (*fpp) {
	if (comp_feature((*fpp)->cp, "Ϳ") == TRUE) {
	    FEATURE *next;
	    free((*fpp)->cp);
	    if (prep == NULL) {
		next = (*fpp)->next;
		free(*fpp);
		*fpp = next;
	    }
	    else {
		next = (*fpp)->next;
		free(*fpp);
		prep->next = next;
	    }
	    fpp = &(prep->next);
	    continue;
	}
	prep = *fpp;
	fpp = &(prep->next);
    }
}    

/*
 *
 *  ե(Sޤʸ) ==ԡ==> 롼빽¤
 *
 */

/*==================================================================*/
	   void copy_cfeature(FEATURE **fpp, char *fname)
/*==================================================================*/
{
    while (*fpp) fpp = &((*fpp)->next);

    if (!((*fpp) = (FEATURE *)(malloc(sizeof(FEATURE)))) ||
	!((*fpp)->cp = (char *)(malloc(strlen(fname) + 1)))) {
	fprintf(stderr, "Can't allocate memory for FEATURE\n");
	exit(-1);
    }
    strcpy((*fpp)->cp, fname);
    (*fpp)->next = NULL;
}

/*==================================================================*/
	      void list2feature(CELL *cp, FEATURE **fpp)
/*==================================================================*/
{
    while (!Null(car(cp))) {
	copy_cfeature(fpp, _Atom(car(cp)));
	fpp = &((*fpp)->next);
	cp = cdr(cp);	    
    }
}

/*==================================================================*/
      void list2feature_pattern(FEATURE_PATTERN *f, CELL *cell)
/*==================================================================*/
{
    /* ꥹ ((ʸƬ)(θ)()) ʤɤFEATURE_PATTERNѴ */

    int nth = 0;

    while (!Null(car(cell))) {
	clear_feature(f->fp+nth);		/* ?? &(f->fp[nth]) */ 
	list2feature(car(cell), f->fp+nth);	/* ?? &(f->fp[nth]) */ 
	cell = cdr(cell);
	nth++;
    }
    f->fp[nth] = NULL;
}

/*==================================================================*/
      void string2feature_pattern_OLD(FEATURE_PATTERN *f, char *cp)
/*==================================================================*/
{
    /* ʸ "ʸƬ|θ|" ʤɤFEATURE_PATTERNѴ
       list2feature_patternбΤ,
       ORANDϥݡȤƤʤ */

    int nth = 0;
    char *scp, *ecp;

    if (cp == NULL || cp[0] == '\0') {
	f->fp[nth] = NULL;
	return;
    }

    strcpy(feature_buffer, cp);
    scp = ecp = feature_buffer;
    while (*ecp) {
	if (*ecp == '|') {
	    *ecp = '\0';
	    clear_feature(f->fp+nth);		/* ?? &(f->fp[nth]) */
	    copy_cfeature(f->fp+nth, scp);	/* ?? &(f->fp[nth]) */
	    nth++;
	    scp = ecp + 1; 
	}
	ecp ++;
    }
    
    clear_feature(f->fp+nth);			/* ?? &(f->fp[nth]) */ 
    copy_cfeature(&(f->fp[nth]), scp);
    nth++;

    f->fp[nth] = NULL;
}

/*==================================================================*/
      void string2feature_pattern(FEATURE_PATTERN *f, char *cp)
/*==================================================================*/
{
    /* ʸ "ʸƬ|θ|" ʤɤFEATURE_PATTERNѴ
       list2feature_patternбΤ,
       ORANDϥݡȤƤʤ */

    int nth;
    char *start_cp, *loop_cp;
    FEATURE **fpp;
    
    if (!*cp) {
	f->fp[0] = NULL;
	return;
    }

    strcpy(feature_buffer, cp);
    nth = 0;
    clear_feature(f->fp+nth);
    fpp = f->fp+nth;
    loop_cp = feature_buffer;
    start_cp = loop_cp;
    while (*loop_cp) {
	if (*loop_cp == '&' && *(loop_cp+1) == '&') {
	    *loop_cp = '\0';
	    copy_cfeature(fpp, start_cp);
	    fpp = &((*fpp)->next);
	    loop_cp += 2;
	    start_cp = loop_cp;
	}
	else if (*loop_cp == '|' && *(loop_cp+1) == '|') {
	    *loop_cp = '\0';
	    copy_cfeature(fpp, start_cp);
	    nth++;
	    clear_feature(f->fp+nth);
	    fpp = f->fp+nth;
	    loop_cp += 2;
	    start_cp = loop_cp;
	}
	else {
	    loop_cp ++;
	}
    }
    copy_cfeature(fpp, start_cp);

    nth++;
    f->fp[nth] = NULL;
}

/*
 *
 * 롼빽¤ ==Ϳ==> Ǥޤʸṽ¤
 *
 */

/*==================================================================*/
	   void append_feature(FEATURE **fpp, FEATURE *afp)
/*==================================================================*/
{
    while (*fpp) {
	fpp = &((*fpp)->next);
    }
    *fpp = afp;
}    

/*==================================================================*/
void assign_cfeature(FEATURE **fpp, char *fname, int temp_assign_flag)
/*==================================================================*/
{
    /* temp_assign_flag: TRUEΤȤֲͿפƬˤĤ */

    /* 񤭤βǽå */

    sscanf(fname, "%[^:]", feature_buffer);	/*  fname":"ʤ
						   feature_bufferfnameΤˤʤ */

    /* quote('"')":"ڤäƤСȤ᤹ */
    if (strcmp(feature_buffer, fname)) {
	int i, count = 0;

	for (i = 0; i < strlen(feature_buffer); i++) {
	    if (feature_buffer[i] == '"') {
		count++;
	    }
	}
	if (count % 2 == 1) { /* '"' */
	    strcpy(feature_buffer, fname);
	}
    }

    while (*fpp) {
	if (comp_feature((*fpp)->cp, feature_buffer) == TRUE) {
	    free((*fpp)->cp);
	    if (!((*fpp)->cp = (char *)(malloc(strlen(fname) + 1)))) {
		fprintf(stderr, "Can't allocate memory for FEATURE\n");
		exit(-1);
	    }
	    strcpy((*fpp)->cp, fname);
	    return;	/* 񤭤ǽλ */
	}
	fpp = &((*fpp)->next);
    }

    /* 񤭤Ǥʤɲ */

    if (!((*fpp) = (FEATURE *)(malloc(sizeof(FEATURE)))) ||
	!((*fpp)->cp = (char *)(malloc(strlen(fname) + 8)))) {
	fprintf(stderr, "Can't allocate memory for FEATURE\n");
	exit(-1);
    }
    if (temp_assign_flag) {
	strcpy((*fpp)->cp, "Ϳ:");
	strcat((*fpp)->cp, fname);
    }
    else {
	strcpy((*fpp)->cp, fname);
    }
    (*fpp)->next = NULL;
}    

/*==================================================================*/
void assign_feature(FEATURE **fpp1, FEATURE **fpp2, void *ptr, int offset, int length, int temp_assign_flag)
/*==================================================================*/
{
    /*
     *  롼ŬѤη̡롼뤫鹽¤ΤFEATUREͿ
     *  ¤μȤФǽȤƤ
     */

    int i;
    char *cp, *pat, buffer[DATA_LEN];
    FEATURE **fpp, *next;

    while (*fpp2) {

	if (*((*fpp2)->cp) == '^') {	/* ξ */
	    
	    fpp = fpp1;
	    
	    while (*fpp) {
		if (comp_feature((*fpp)->cp, &((*fpp2)->cp[1])) == TRUE) {
		    free((*fpp)->cp);
		    next = (*fpp)->next;
		    free(*fpp);
		    *fpp = next;
		} else {
		    fpp = &((*fpp)->next);
		}
	    }
	
	} else if (*((*fpp2)->cp) == '&') {	/* ؿξ */

	    if (!strcmp((*fpp2)->cp, "&ɽ:Ϳ")) {
		set_pred_voice((BNST_DATA *)ptr + offset);	/*  */
		get_scase_code((BNST_DATA *)ptr + offset);	/* ɽس */
	    }
	    else if (!strcmp((*fpp2)->cp, "&ɽ:")) {
		for (i = 0, cp = ((BNST_DATA *)ptr + offset)->SCASE_code; 
		     i < SCASE_CODE_SIZE; i++, cp++) 
		    *cp = 0;		
	    }
	    else if (!strncmp((*fpp2)->cp, "&ɽ:^", strlen("&ɽ:^"))) {
		((BNST_DATA *)ptr + offset)->
		    SCASE_code[case2num((*fpp2)->cp + strlen("&ɽ:^"))] = 0;
	    }
	    else if (!strncmp((*fpp2)->cp, "&ɽ:", strlen("&ɽ:"))) {
		((BNST_DATA *)ptr + offset)->
		    SCASE_code[case2num((*fpp2)->cp + strlen("&ɽ:"))] = 1;
	    }
	    else if (!strncmp((*fpp2)->cp, "&MEMO:", strlen("&MEMO:"))) {
		strcat(PM_Memo, " ");
		strcat(PM_Memo, (*fpp2)->cp + strlen("&MEMO:"));
	    }
	    else if (!strncmp((*fpp2)->cp, "&ʻѹ:", strlen("&ʻѹ:"))) {
		change_mrph((MRPH_DATA *)ptr + offset, *fpp2);
	    }
	    else if (!strncmp((*fpp2)->cp, "&ɽɽѹ:", strlen("&ɽɽѹ:"))) {
		change_one_mrph_rep((MRPH_DATA *)ptr + offset, 1, *((*fpp2)->cp + strlen("&ɽɽѹ:")));
	    }
	    else if (!strncmp((*fpp2)->cp, "&̣Ϳ:", strlen("&̣Ϳ:"))) {
		assign_sm((BNST_DATA *)ptr + offset, (*fpp2)->cp + strlen("&̣Ϳ:"));
	    }
	    else if (!strncmp((*fpp2)->cp, "&ʣ缭ʲ", strlen("&ʣ缭ʲ"))) {
		cp = make_fukugoji_case_string((TAG_DATA *)ptr + offset + 1);
		if (cp) {
		    assign_cfeature(&(((TAG_DATA *)ptr + offset)->f), cp, temp_assign_flag);
		}
	    }
	    else if (!strncmp((*fpp2)->cp, "&ʣ缭IDͿ", strlen("&ʣ缭IDͿ"))) {
		cp = make_fukugoji_id((BNST_DATA *)ptr + offset);
		if (cp) {
		    assign_cfeature(&(((BNST_DATA *)ptr + offset)->f), cp, temp_assign_flag);
		}
	    }
	    else if (!strncmp((*fpp2)->cp, "&Ϳ:", strlen("&Ϳ:"))) {
		sprintf(buffer, "%s:%s", 
			(*fpp2)->cp + strlen("&Ϳ:"), 
			((MRPH_DATA *)matched_ptr)->Goi);
		assign_cfeature(&(((BNST_DATA *)ptr + offset)->f), buffer, temp_assign_flag);
	    }
	    /* &:n:FEATURE : FEATURE  */
	    else if (!strncmp((*fpp2)->cp, "&:", strlen("&:"))) {
		pat = (*fpp2)->cp + strlen("&:");
		sscanf(pat, "%d", &i);
		pat = strchr(pat, ':');
		pat++;
		if ((cp = check_feature(((TAG_DATA *)ptr + offset)->f, pat))) {
		    assign_cfeature(&(((TAG_DATA *)ptr + offset + i)->f), cp, temp_assign_flag);
		}
		else { /* ʤʤ顢Ȥ餢Τ */
		    delete_cfeature(&(((TAG_DATA *)ptr + offset + i)->f), pat);
		}
		if (((TAG_DATA *)ptr + offset)->bnum >= 0) { /* ʸڤǤ⤢Ȥ */
		    if ((cp = check_feature((((TAG_DATA *)ptr + offset)->b_ptr)->f, pat))) {
			assign_cfeature(&((((TAG_DATA *)ptr + offset)->b_ptr + i)->f), cp, temp_assign_flag);
		    }
		    else {
			delete_cfeature(&((((TAG_DATA *)ptr + offset)->b_ptr + i)->f), pat);
		    }
		}
	    }
	    /* ° : °򤹤٤<°>ˤ
	       ϡ&feature:^Ω Τ褦˰Ȥ٤ */
	    else if (!strncmp((*fpp2)->cp, "&°", strlen("&°"))) {
		for (i = 0; i < ((TAG_DATA *)ptr + offset)->mrph_num; i++) {
		    delete_cfeature(&((((TAG_DATA *)ptr + offset)->mrph_ptr + i)->f), "Ω");
		    delete_cfeature(&((((TAG_DATA *)ptr + offset)->mrph_ptr + i)->f), "Ƹ");
		    delete_cfeature(&((((TAG_DATA *)ptr + offset)->mrph_ptr + i)->f), "Ƹ");
		    assign_cfeature(&((((TAG_DATA *)ptr + offset)->mrph_ptr + i)->f), "°", temp_assign_flag);
		}
	    }
	    /* ư : ưå (ޥåʬ) */
	    else if (!strncmp((*fpp2)->cp, "&ư:", strlen("&ư:"))) {
		if (offset == 0 && check_auto_dic((MRPH_DATA *)ptr, length, (*fpp2)->cp + strlen("&ư:"))) {
		    for (i = 0; i < length; i ++) {
			assign_cfeature(&(((MRPH_DATA *)ptr + i)->f), (*fpp2)->cp + strlen("&ư:"), temp_assign_flag);
		    }
		}
	    }
	} else {			/* ɲäξ */
	    assign_cfeature(fpp1, (*fpp2)->cp, temp_assign_flag);	
	}

	fpp2 = &((*fpp2)->next);
    }
}

/*==================================================================*/
	void copy_feature(FEATURE **dst_fpp, FEATURE *src_fp)
/*==================================================================*/
{
    while (src_fp) {
	assign_cfeature(dst_fpp, src_fp->cp, FALSE);
	src_fp = src_fp->next;
    }
}

/*
 *
 * 롼빽¤ <==ȹ==> Ǥޤʸṽ¤
 *
 */

/*==================================================================*/
	     int comp_feature(char *data, char *pattern)
/*==================================================================*/
{
    /* 
     *   ޤ ʬ(patternû,ʸ':')ʤޥå
     */
    if (data && !strcmp(data, pattern)) {
	return TRUE;
    } else if (data && !strncmp(data, pattern, strlen(pattern)) &&
	       data[strlen(pattern)] == ':') {
	return TRUE;
    } else {
	return FALSE;
    }
}

/*==================================================================*/
	     int comp_feature_NE(char *data, char *pattern)
/*==================================================================*/
{
    char decision[9];

    decision[0] = '\0';
    sscanf(data, "%*[^:]:%*[^:]:%s", decision);

    if (decision[0] && !strcmp(decision, pattern))
	return TRUE;
    else
	return FALSE;
}

/*==================================================================*/
	    char *check_feature(FEATURE *fp, char *fname)
/*==================================================================*/
{
    while (fp) {
	if (comp_feature(fp->cp, fname) == TRUE) {
	    return fp->cp;
	}
	fp = fp->next;
    }
    return NULL;
}

/*==================================================================*/
	    char *check_feature_NE(FEATURE *fp, char *fname)
/*==================================================================*/
{
    while (fp) {
	if (comp_feature_NE(fp->cp, fname) == TRUE) {
	    return fp->cp;
	}
	fp = fp->next;
    }
    return NULL;
}

/*==================================================================*/
	     int check_category(FEATURE *fp, char *fname)
/*==================================================================*/
{
    char *cp;

    if (0 && strlen(fname) == 1) {
	/* fname'a'ޤ'v'ξ */
	/* <ɽɽ:...[av]>⥫ƥΰȤư */
	if (!check_feature(fp, "ɽɽ") && (cp = check_feature(fp, "ɽɽ")) &&
	    *(cp + strlen(cp) - 1) == *fname) {
	    return TRUE;
	}
    }
    else if ((cp = check_feature(fp, "ƥ"))) {
	while ((cp = strchr(cp, ':'))) {
	    cp++;
	    if (!strcmp(cp, fname) ||
		!strncmp(cp, fname, strlen(fname)) && 
		*(cp + strlen(fname)) == ':') {
		return TRUE;
	    }
	}
    }

    return FALSE;
}

/*==================================================================*/
	int compare_threshold(int value, int threshold, char *eq)
/*==================================================================*/
{
    if (str_eq(eq, "lt")) {
	if (value < threshold)
	    return TRUE;
	else
	    return FALSE;
    }
    else if (str_eq(eq, "le")) {
	if (value <= threshold)
	    return TRUE;
	else
	    return FALSE;
    }
    else if (str_eq(eq, "gt")) {
	if (value > threshold)
	    return TRUE;
	else
	    return FALSE;
    }
    else if (str_eq(eq, "ge")) {
	if (value >= threshold)
	    return TRUE;
	else
	    return FALSE;
    }
    return FALSE;
}

/*==================================================================*/
      int check_Bunrui(MRPH_DATA *mp, char *class, int flag)
/*==================================================================*/
{
    char string[14];

    if (str_eq(Class[6][mp->Bunrui].id, class))
	return flag;

    sprintf(string, "ۣ-%s", class);
    if (check_feature(mp->f, string))
	return flag;

    return 1-flag;
}

/*==================================================================*/
		    int check_char_type(int code)
/*==================================================================*/
{
    /* ʤ "" */
    if ((0xa5a0 < code && code < 0xa6a0) || code == 0xa1bc) {
	return TYPE_KATAKANA;
    }
    /* Ҥ餬 */
    else if (0xa4a0 < code && code < 0xa5a0) {
	return TYPE_HIRAGANA;
    }
    /*  */
    else if (0xb0a0 < code || code == 0xa1b9) {
	return TYPE_KANJI;
    }
    /* (-)Τ (""(0xa1a6)""(0xa1a5)оݳ) */
    else if (0xa3af < code && code < 0xa3ba) {
	return TYPE_SUUJI;
    }
    /* ե٥å */
    else if (0xa3c0 < code && code < 0xa3fb) {
	return TYPE_EIGO;
    }
    /*  */
    else {
	return TYPE_KIGOU;
    }
}

/*==================================================================*/
		int check_str_type(unsigned char *ucp)
/*==================================================================*/
{
    int code = 0, precode = 0;

    while (*ucp) {
	code = (*ucp << 8) + *(ucp + 1);
	code = check_char_type(code);
	if (precode && precode != code) {
	    return 0;
	}
	precode = code;
	ucp += BYTES4CHAR;
    }

    return code;
}

/*==================================================================*/
 int check_function(char *rule, FEATURE *fd, void *ptr1, void *ptr2)
/*==================================================================*/
{
    /* rule : 롼
       fd : ǡ¦FEATURE
       p1 : ξ硤¦ι¤(MRPH_DATA,BNST_DATAʤ)
       p2 : ǡι¤(MRPH_DATA,BNST_DATAʤ)
    */

    int i, code, type, pretype, flag, length;
    char *cp;
    unsigned char *ucp; 

    /* &ѿ : ѿ å (ʳ) (ǥ٥) */

    if (!strcmp(rule, "&ѿ")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    if (!(0xa1a5 < code && code < 0xa4a0) && /* ϰ */
		!(0xa5a0 < code && code < 0xb0a0))
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* & :  å (ǥ٥) */

    else if (!strcmp(rule, "&")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    if (code >= 0xb0a0 ||	/* ϰ */
		code == 0xa1b9 || 	/*  */
		(code == 0xa4ab && ucp == (unsigned char *)((MRPH_DATA *)ptr2)->Goi2) ||	/*  */
		(code == 0xa5ab && ucp == (unsigned char *)((MRPH_DATA *)ptr2)->Goi2) ||	/*  */
		(code == 0xa5f6 && ucp == (unsigned char *)((MRPH_DATA *)ptr2)->Goi2))		/*  */
	      ;
	    else 
	      return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* &ʴ : ʴå (ǥ٥) */

    else if (!strcmp(rule, "&ʴ")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    code = check_char_type(code);
	    if (!(code == TYPE_KANJI || code == TYPE_HIRAGANA))
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* &Ҥ餬 : Ҥ餬 å (ǥ٥) */

    else if (!strcmp(rule, "&Ҥ餬")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    if (check_char_type(code) != TYPE_HIRAGANA)
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* &Ҥ餬 : ΰʸҤ餬ʤ å (ǥ٥) */

    else if (!strcmp(rule, "&Ҥ餬")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;	/* ɽå */
	ucp += strlen(ucp) - BYTES4CHAR;
	code = (*ucp)*0x100+*(ucp+1);
	if (check_char_type(code) != TYPE_HIRAGANA)
	    return FALSE;
	return TRUE;
    }

    /* &ʸ : ʸ å (ǥ٥) */

    else if (!strncmp(rule, "&ʸ:", strlen("&ʸ:"))) {
	cp = rule + strlen("&ʸ:");

	/* ѥ礭FALSE */
	if (strlen(cp) > strlen(((MRPH_DATA *)ptr2)->Goi2))
	    return FALSE;

	ucp = ((MRPH_DATA *)ptr2)->Goi2;	/* ɽå */
	ucp += strlen(ucp)-strlen(cp);
	if (strcmp(ucp, cp))
	    return FALSE;
	return TRUE;
    }

    /* & :  å (ǥ٥) */

    else if (!strcmp(rule, "&")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    if (check_char_type(code) != TYPE_KATAKANA)
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* & :  å (ǥ٥) */

    else if (!strcmp(rule, "&")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    if (check_char_type(code) != TYPE_SUUJI)
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* &ѵ : ѵ å (ǥ٥) */

    else if (!strcmp(rule, "&ѵ")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    type = check_char_type(code);
	    if (type != TYPE_EIGO && type != TYPE_KIGOU)
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* & :  å (ǥ٥) */

    else if (!strcmp(rule, "&")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    type = check_char_type(code);
	    if (type != TYPE_KIGOU)
		return FALSE;
	    ucp += BYTES4CHAR;
	}	    
	return TRUE;
    }

    /* & :  (+...) å (ǥ٥) */

    else if (!strcmp(rule, "&")) { /* euc-jp */
	ucp = ((MRPH_DATA *)ptr2)->Goi2;
	pretype = 0;
	while (*ucp) {
	    code = (*ucp)*0x100+*(ucp+1);
	    type = check_char_type(code);
	    if (pretype && pretype != type)
		return TRUE;
	    pretype = type;
	    ucp += BYTES4CHAR;
	}
	return FALSE;
    }

    /* &ʸ : ʸ å (ǥ٥) */

    else if (!strcmp(rule, "&ʸ")) {
	if (strlen(((MRPH_DATA *)ptr2)->Goi2) == BYTES4CHAR)
	    return TRUE;
	else 
	    return FALSE;
    }

    /* &̣: ̣ǥå () */

    else if (!strncmp(rule, "&̣:", strlen("&̣:"))) {
	if (Thesaurus != USE_NTT || ((MRPH_DATA *)ptr2)->SM == NULL) {
	    return FALSE;
	}

	cp = rule + strlen("&̣:");
	/* ạ̈°̾, ʳʤ饳ɤΤޤ */
	if (*cp & 0x80) { /* euc-jp */
	    if (SM2CODEExist == TRUE)
		cp = sm2code(cp);
	    else
		cp = NULL;
	    flag = SM_NO_EXPAND_NE;
	}
	else {
	    flag = SM_CHECK_FULL;
	}

	if (cp) {
	    for (i = 0; ((MRPH_DATA *)ptr2)->SM[i]; i+=SM_CODE_SIZE) {
		if (_sm_match_score(cp, 
				    &(((MRPH_DATA *)ptr2)->SM[i]), flag))
		    return TRUE;
	    }
	}
	return FALSE;
    }

    /* &ʸ̣: ̣ǥå (ʸ) */

    else if (!strncmp(rule, "&ʸ̣:", strlen("&ʸ̣:"))) {
	if (Thesaurus != USE_NTT && Thesaurus != USE_BGH) {
	    return FALSE;
	}

	cp = rule + strlen("&ʸ̣:");
	/* ạ̈°̾, ʳʤ饳ɤΤޤ */
	if (*cp & 0x80) { /* euc-jp */
	    if (SM2CODEExist == TRUE)
		cp = sm2code(cp);
	    else
		cp = NULL;
	    flag = SM_NO_EXPAND_NE;
	}
	else {
	    flag = SM_CHECK_FULL;
	}

	if (cp) {
	    if (Thesaurus == USE_NTT) {	
		if (sm_match_check(cp, (((BNST_DATA *)ptr2)->SM_code), flag))
		    return TRUE;
	    }
	    else if (Thesaurus == USE_BGH) {
		if (bgh_match_check(cp, ((BNST_DATA *)ptr2)->BGH_code))
		    return TRUE;
	    }
	}
	return FALSE;
    }

    /* &ʸ̣: ʸΤ٤Ƥΰ̣Ǥ̣ǰʲˤ뤫ɤ */

    else if (!strncmp(rule, "&ʸ̣:", strlen("&ʸ̣:"))) {
	if (Thesaurus != USE_NTT && Thesaurus != USE_BGH) {
	    return FALSE;
	}

	cp = rule + strlen("&ʸ̣:");
	/* ạ̈°̾, ʳʤ饳ɤΤޤ */
	if (*cp & 0x80) { /* euc-jp */
	    if (SM2CODEExist == TRUE)
		cp = sm2code(cp);
	    else
		cp = NULL;
	}

	if (Thesaurus == USE_NTT) {	
	    if (cp && ((BNST_DATA *)ptr2)->SM_code[0] && 
		sm_all_match(((BNST_DATA *)ptr2)->SM_code, cp)) {
		return TRUE;
	    }
	}
	else if (Thesaurus == USE_BGH) {
	    if (cp && ((BNST_DATA *)ptr2)->BGH_code[0] && 
		sm_all_match(((BNST_DATA *)ptr2)->BGH_code, cp)) {
		return TRUE;
	    }
	}
	return FALSE;
    }

    /* ǤĹ */
    
    else if (!strncmp(rule, "&Ĺ:", strlen("&Ĺ:"))) {
	cp = rule + strlen("&Ĺ:");
	if (*(cp + strlen(cp) - 1) == '-') { /* θ"-"ĤƤ */
	    flag = 1; /* ĹʾOK */
	    *(cp + strlen(cp) - 1) = '\0';
	}
	else {
	    flag = 0;
	}
	code = atoi(cp);

	length = strlen(((MRPH_DATA *)ptr2)->Goi2);
	if (length == code * BYTES4CHAR || (flag && length > code * BYTES4CHAR)) {
	    return TRUE;
	}
	return FALSE;
    }

    else if (!strncmp(rule, "&:", strlen("&:"))) {
	cp = rule + strlen("&:");
	i = strlen(((MRPH_DATA *)ptr2)->Goi2) - strlen(cp);
	if (*cp && i >= 0 && !strcmp((((MRPH_DATA *)ptr2)->Goi2)+i, cp)) {
	    return TRUE;
	}
	return FALSE;
    }

    /* &ɽ: ɽسʥå (ʸ٥,٥) */

    else if (!strncmp(rule, "&ɽ:", strlen("&ɽ:"))) {
	if (!strcmp(rule + strlen("&ɽ:"), "ȹ")) {
	    if ((cp = check_feature(((BNST_DATA *)ptr1)->f, "")) == NULL) {
		return FALSE;
	    }
	    if (((BNST_DATA *)ptr2)->
		SCASE_code[case2num(cp + strlen(":"))]) {
		return TRUE;
	    }
	    else {
		return FALSE;
	    }
	}
	else if (((BNST_DATA *)ptr2)->
		 SCASE_code[case2num(rule + strlen("&ɽ:"))]) {
	    return TRUE;
	}
	else {
	    return FALSE;
 	}
    }

    /* &D : Υ (٥) */

    else if (!strncmp(rule, "&D:", strlen("&D:"))) {
	if (((BNST_DATA *)ptr2 - (BNST_DATA *)ptr1)
	    <= atoi(rule + strlen("&D:"))) {
	    return TRUE;
	}
	else {
	    return FALSE;
	}
    }

    /* &٥: : ѸΥ٥ (٥) */

    else if (!strcmp(rule, "&٥:")) {
	return subordinate_level_comp((BNST_DATA *)ptr1, 
				      (BNST_DATA *)ptr2);
    }

    /* &٥:X : Ѹ٥XʾǤ뤫ɤ */

    else if (!strncmp(rule, "&٥:", strlen("&٥:"))) {
	return subordinate_level_check(rule + strlen("&٥:"), fd);
	/* (BNST_DATA *)ptr2); */
    }

    /* &¦ : ¦FEATUREå (٥) */
    
    else if (!strncmp(rule, "&¦:", strlen("&¦:"))) {
	cp = rule + strlen("&¦:");
	if ((*cp != '^' && check_feature(((BNST_DATA *)ptr1)->f, cp)) ||
	    (*cp == '^' && !check_feature(((BNST_DATA *)ptr1)->f, cp))) {
	    return TRUE;
	} else {
	    return FALSE;
	}
    }

    /* &¦å : ¦FEATUREå (ʸ롼) */
    
    else if (!strncmp(rule, "&¦å:", strlen("&¦å:"))) {
	cp = rule + strlen("&¦å:");
	for (i = 0; ((BNST_DATA *)ptr2)->child[i]; i++) {
	    if (check_feature(((BNST_DATA *)ptr2)->child[i]->f, cp)) {
		return TRUE;
	    }
	}
	return FALSE;
    }

    /* &¦å : ¦FEATUREå (ʸ롼) */
    
    else if (!strncmp(rule, "&¦å:", strlen("&¦å:"))) {
	cp = rule + strlen("&¦å:");
	if (((BNST_DATA *)ptr2)->parent &&
	    check_feature(((BNST_DATA *)ptr2)->parent->f, cp)) {
	    return TRUE;
	} else {
	    return FALSE;
	}
    }

    /* &Ω : Ω줬Ʊɤ */
    
    else if (!strncmp(rule, "&Ω", strlen("&Ω"))) {
	/* if (!strcmp(((BNST_DATA *)ptr1)->head_ptr->Goi, 
	   ((BNST_DATA *)ptr2)->head_ptr->Goi)) { */
	if (!strcmp(((BNST_DATA *)ptr1)->Jiritu_Go, 
		    ((BNST_DATA *)ptr2)->Jiritu_Go)) {
	    return TRUE;
	} else {
	    return FALSE;
	}
    }


    /* &ʸȹ : Ȥʸʬޥå by kuro 00/12/28 */
    
    else if (!strncmp(rule, "&ʸȹ:", strlen("&ʸȹ:"))) {
      	cp = rule + strlen("&ʸȹ:");
	if (strstr(((MRPH_DATA *)ptr2)->Goi, cp)) {
	    return TRUE;
	} else {
	    return FALSE;
	}
    }

    /* &ST : ¤ϤǤ٤ (Ǥ̵) */
    
    else if (!strncmp(rule, "&ST", strlen("&ST"))) {
	return TRUE;
    }

    /* &OPTCHECK : ץΥå */
    
    else if (!strncmp(rule, "&OptCheck:", strlen("&OptCheck:"))) {
	char **opt;

	cp = rule + strlen("&OptCheck:");
	if (*cp == '-') { /* '-'ޤǤФ */
	    cp++;
	}

	for (opt = Options; *opt != NULL; opt++) {
	    if (!strcasecmp(cp, *opt)) {
		return TRUE;	    
	    }
	}
	return FALSE;
    }

    /*
    else if (!strncmp(rule, "&", strlen("&"))) {
	if (sm_all_match(((BNST_DATA *)ptr2)->SM_code, "1128********")) {
	    return TRUE;
	}
	else {
	    return FALSE;
	}
    } */

    /* & : ֤å */

    else if (!strncmp(rule, "&:", strlen("&:"))) {
	cp = rule + strlen("&:");
	if ((!strcmp(cp, "ǽư") && ((BNST_DATA *)ptr2)->voice == 0) || 
	    (!strcmp(cp, "ư") && (((BNST_DATA *)ptr2)->voice & VOICE_UKEMI || 
				     ((BNST_DATA *)ptr2)->voice & VOICE_SHIEKI_UKEMI)) || 
	    (!strcmp(cp, "") && (((BNST_DATA *)ptr2)->voice & VOICE_SHIEKI || 
				     ((BNST_DATA *)ptr2)->voice & VOICE_SHIEKI_UKEMI))) {
	    return TRUE;
	}
	else {
	    return FALSE;
	}
    }

    /* & : ǤޤʸΥݥ󥿤򵭲 */

    else if (!strcmp(rule, "&")) {
	matched_ptr = ptr2;
	return TRUE;
    }

    else {
#ifdef DEBUG
	fprintf(stderr, "Invalid Feature-Function (%s)\n", rule);
#endif
	return TRUE;
    }
}

/*==================================================================*/
 int feature_AND_match(FEATURE *fp, FEATURE *fd, void *p1, void *p2)
/*==================================================================*/
{
    int value;

    while (fp) {
	if (fp->cp[0] == '^' && fp->cp[1] == '&') {
	    value = check_function(fp->cp+1, fd, p1, p2);
	    if (value == TRUE) {
		return FALSE;
	    }
	} else if (fp->cp[0] == '&') {
	    value = check_function(fp->cp, fd, p1, p2);
	    if (value == FALSE) {
		return FALSE;
	    }
	} else if (fp->cp[0] == '^') {
	    if (check_feature(fd, fp->cp+1)) {
		return FALSE;
	    }
	} else {
	    if (!check_feature(fd, fp->cp)) {
		return FALSE;
	    }
	}
	fp = fp->next;
    }
    return TRUE;
}

/*==================================================================*/
int feature_pattern_match(FEATURE_PATTERN *fr, FEATURE *fd,
			  void *p1, void *p2)
/*==================================================================*/
{
    /* fr : 롼¦FEATURE_PATTERN,
       fd : ǡ¦FEATURE
       p1 : ξ硤¦ι¤(MRPH_DATA,BNST_DATAʤ)
       p2 : ǡ¦ι¤(MRPH_DATA,BNST_DATAʤ)
    */

    int i, value;

    /* PATTERNʤХޥå */
    if (fr->fp[0] == NULL) return TRUE;

    /* ORγƾĴ٤ */
    for (i = 0; fr->fp[i]; i++) {
	value = feature_AND_match(fr->fp[i], fd, p1, p2);
	if (value == TRUE) 
	    return TRUE;
    }
    return FALSE;
}

/*====================================================================*/
                 char* get_feature_for_chi (BNST_DATA *p_ptr)
/*====================================================================*/
{
    char* feature;
    if (check_feature(p_ptr->f, "AD")) {
	feature = "AD";
    }
    else if (check_feature(p_ptr->f, "AS")) {
	feature = "AS";
    }
    else if (check_feature(p_ptr->f, "BA")) {
	feature = "BA";
    }
    else if (check_feature(p_ptr->f, "CC")) {
	feature = "CC";
    }
    else if (check_feature(p_ptr->f, "CD")) {
	feature = "CD";
    }
    else if (check_feature(p_ptr->f, "CS")) {
	feature = "CS";
    }
    else if (check_feature(p_ptr->f, "DEC")) {
	feature = "DEC";
    }
    else if (check_feature(p_ptr->f, "DEG")) {
	feature = "DEG";
    }
    else if (check_feature(p_ptr->f, "DER")) {
	feature = "DER";
    }
    else if (check_feature(p_ptr->f, "DEV")) {
	feature = "DEV";
    }
    else if (check_feature(p_ptr->f, "DT")) {
	feature = "DT";
    }
    else if (check_feature(p_ptr->f, "ETC")) {
	feature = "ETC";
    }
    else if (check_feature(p_ptr->f, "FW")) {
	feature = "FW";
    }
    else if (check_feature(p_ptr->f, "IJ")) {
	feature = "IJ";
    }
    else if (check_feature(p_ptr->f, "JJ")) {
	feature = "JJ";
    }
    else if (check_feature(p_ptr->f, "LB")) {
	feature = "LB";
    }
    else if (check_feature(p_ptr->f, "LC")) {
	feature = "LC";
    }
    else if (check_feature(p_ptr->f, "M")) {
	feature = "M";
    }
    else if (check_feature(p_ptr->f, "MSP")) {
	feature = "MSP";
    }
    else if (check_feature(p_ptr->f, "NN")) {
	feature = "NN";
    }
    else if (check_feature(p_ptr->f, "NR")) {
	feature = "NR";
    }
    else if (check_feature(p_ptr->f, "NT")) {
	feature = "NT";
    }
    else if (check_feature(p_ptr->f, "OD")) {
	feature = "OD";
    }
    else if (check_feature(p_ptr->f, "ON")) {
	feature = "ON";
    }
    else if (check_feature(p_ptr->f, "P")) {
	feature = "P";
    }
    else if (check_feature(p_ptr->f, "PN")) {
	feature = "PN";
    }
    else if (check_feature(p_ptr->f, "PU")) {
	feature = "PU";
    }
    else if (check_feature(p_ptr->f, "SB")) {
	feature = "SB";
    }
    else if (check_feature(p_ptr->f, "SP")) {
	feature = "SP";
    }
    else if (check_feature(p_ptr->f, "VV")) {
	feature = "VV";
    }
    else if (check_feature(p_ptr->f, "VA")) {
	feature = "VA";
    }
    else if (check_feature(p_ptr->f, "VC")) {
	feature = "VC";
    }
    else if (check_feature(p_ptr->f, "VE")) {
	feature = "VE";
    }
    else {
	feature = "";
    }
    
    return feature;
}

/*====================================================================
                               END
====================================================================*/
