/*====================================================================

                                 ¸¤
 
                                                S.Kurohashi 93. 5.31

       $Id: dpnd_analysis.c,v 1.165.2.1 2009/10/19 23:34:31 kawahara Exp $

====================================================================*/
#include "knp.h"

int Possibility;	/* ¸¤βǽβܤ */
static int dpndID = 0;

/*==================================================================*/
             void assign_dpnd_rule(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int 	i, j;
  BNST_DATA	*b_ptr;
  DpndRule 	*r_ptr;

  for (i = 0, b_ptr = sp->bnst_data; i < sp->Bnst_num; i++, b_ptr++) {
    for (j = 0, r_ptr = DpndRuleArray; j < CurDpndRuleSize; j++, r_ptr++) {
      if (feature_pattern_match(&(r_ptr->dependant), b_ptr->f, NULL, b_ptr) 
	  == TRUE) {
	b_ptr->dpnd_rule = r_ptr; 
	break;
      }
    }

    if (b_ptr->dpnd_rule == NULL) {
      fprintf(stderr, ";; No DpndRule for %dth bnst (", i);
      print_feature(b_ptr->f, stderr);
      fprintf(stderr, ")\n");

      /* DpndRuleArray[0] ϥޥåʤ */
      b_ptr->dpnd_rule = DpndRuleArray;
    }
  }
}

/*==================================================================*/
              void calc_dpnd_matrix(SENTENCE_DATA *sp)
/*==================================================================*/
{
    int i, j, k, value, first_uke_flag;
    BNST_DATA *k_ptr, *u_ptr;

    for (i = 0; i < sp->Bnst_num; i++) {
	k_ptr = sp->bnst_data + i;
	first_uke_flag = 1;
	for (j = i + 1; j < sp->Bnst_num; j++) {
	    u_ptr = sp->bnst_data + j;
	    Dpnd_matrix[i][j] = 0;
	    for (k = 0; k_ptr->dpnd_rule->dpnd_type[k]; k++) {
		value = feature_pattern_match(&(k_ptr->dpnd_rule->governor[k]),
					      u_ptr->f, k_ptr, u_ptr);
		if (value == TRUE) {
		    Dpnd_matrix[i][j] = (int)k_ptr->dpnd_rule->dpnd_type[k];
		    first_uke_flag = 0;
		    break;
		}
	    }
	}
    }
}

/*==================================================================*/
           int relax_dpnd_matrix(SENTENCE_DATA *sp)
/*==================================================================*/
{
  /* 褬ʤδ

  ̤ˤޥͥ褷˷褦ѹ

   šš֡šššššסšţ (ʸ)
   ššš֣ššţ¡סšš (̽)
   ššš֣ţ¡šסšš (:ʸ)
   šššţ¡֡šššţá (¤˷ȤϤʤ
  äȤδطϲϤн)
  */

  int i, j, ok_flag, relax_flag, last_possibility;
  
  relax_flag = FALSE;

  for (i = 0; i < sp->Bnst_num - 1  ; i++) {
    ok_flag = FALSE;
    last_possibility = i;
    for (j = i + 1; j < sp->Bnst_num ; j++) {
      if (Quote_matrix[i][j]) {
	if (Dpnd_matrix[i][j] > 0) {
	  ok_flag = TRUE;
	  break;
	} else if (check_feature(sp->bnst_data[j].f, ":ʸ")) {
	  last_possibility = j;
	  break;
	} else {
	  last_possibility = j;
	}
      }
    }

    if (ok_flag == FALSE) {
      if (check_feature(sp->bnst_data[last_possibility].f, "ʸ") ||
	  check_feature(sp->bnst_data[last_possibility].f, ":ʸ") ||
	  check_feature(sp->bnst_data[last_possibility].f, "̽")) {
	Dpnd_matrix[i][last_possibility] = 'R';
	relax_flag = TRUE;
      }
    }
  }

  return relax_flag;
}

/*==================================================================*/
int check_uncertain_d_condition(SENTENCE_DATA *sp, DPND *dp, int gvnr)
     /*==================================================================*/
{
  /* (å) d η

   βǽʷ(D)İʾ ( d - - D ʤ )
   긵dθƱ	) ܤǺǽ˵ԤǹԤ줿
   d()dθƱ	) Ƿײ˵Ԥѹ줿

   dפȤd򷸤ȤΤŬ
  ) ֤ĤܤľѤˤʤ褦ˡϤ碌Ρ
  */

  int i, next_D;
  char *dpnd_cp, *gvnr_cp, *next_cp;

  next_D = 0;
  for (i = gvnr + 1; i < sp->Bnst_num ; i++) {
    if (Mask_matrix[dp->pos][i] &&
	Quote_matrix[dp->pos][i] &&
	dp->mask[i] &&
	Dpnd_matrix[dp->pos][i] == 'D') {
      next_D = i;
      break;
    }
  }
  dpnd_cp = check_feature(sp->bnst_data[dp->pos].f, "");
  gvnr_cp = check_feature(sp->bnst_data[gvnr].f, "");
  if (gvnr < sp->Bnst_num-1) {
    next_cp = check_feature(sp->bnst_data[gvnr+1].f, "");	
  }
  else {
    next_cp = NULL;
  }

  if (next_D == 0 ||
      gvnr + 2 < next_D ||
      (gvnr + 2 == next_D && gvnr < sp->Bnst_num-1 &&
       check_feature(sp->bnst_data[gvnr+1].f, "θ") &&
       ((dpnd_cp && next_cp && !strcmp(dpnd_cp, next_cp)) ||
	(gvnr_cp && next_cp && !strcmp(gvnr_cp, next_cp))))) {
    /* fprintf(stderr, "%d -> %d OK\n", i, j); */
    return 1;
  } else {
    return 0;
  }
}

/*==================================================================*/
int compare_dpnd(SENTENCE_DATA *sp, TOTAL_MGR *new_mgr, TOTAL_MGR *best_mgr)
     /*==================================================================*/
{
  int i;

  return FALSE;

  if (Possibility == 1 || new_mgr->dflt < best_mgr->dflt) {
    return TRUE;
  } else {
    for (i = sp->Bnst_num - 2; i >= 0; i--) {
      if (new_mgr->dpnd.dflt[i] < best_mgr->dpnd.dflt[i]) 
	return TRUE;
      else if (new_mgr->dpnd.dflt[i] > best_mgr->dpnd.dflt[i]) 
	return FALSE;
    }
  }

  fprintf(stderr, ";; Error in compare_dpnd !!\n");
  exit(1);
}


/*==================================================================*/
       void dpnd_info_to_bnst(SENTENCE_DATA *sp, DPND *dp)
/*==================================================================*/
{
  /* ˴ؤξ DPND  BNST_DATA ˥ԡ */

  int		i;
  BNST_DATA	*b_ptr;

  for (i = 0, b_ptr = sp->bnst_data; i < sp->Bnst_num; i++, b_ptr++) {
    if (Language != CHINESE && (dp->type[i] == 'd' || dp->type[i] == 'R')) {
      b_ptr->dpnd_head = dp->head[i];
      b_ptr->dpnd_type = 'D';	/* relaxD */
    } else {
      b_ptr->dpnd_head = dp->head[i];
      b_ptr->dpnd_type = dp->type[i];
    }
    b_ptr->dpnd_dflt = dp->dflt[i];
  }
}

/*==================================================================*/
       void dpnd_info_to_tag_raw(SENTENCE_DATA *sp, DPND *dp)
/*==================================================================*/
{
  /* ˴ؤξ DPND  TAG_DATA ˥ԡ */

  int		i, j, last_b, offset, check_ac, rep_length;
  char	*cp, *strp, buf[16];
  TAG_DATA	*t_ptr, *ht_ptr;

  for (i = 0, t_ptr = sp->tag_data; i < sp->Tag_num; i++, t_ptr++) {
    /* äȤᤤʸԤ򵭲 */
    if (t_ptr->bnum >= 0) {
      last_b = t_ptr->bnum;
    }

    /* ʸ */
    if (i == sp->Tag_num - 1) {
      t_ptr->dpnd_head = -1;
      t_ptr->dpnd_type = 'D';
    }
    /* ٤ˤ */
    else if (t_ptr->inum != 0) {
      t_ptr->dpnd_head = t_ptr->num + 1;
      t_ptr->dpnd_type = 'D';
    }
    /* ʸǸΥñ (inum == 0) */
    else {
      if ((!check_feature((sp->bnst_data + last_b)->f, "ñ̵̼")) &&
	  (cp = check_feature((sp->bnst_data + dp->head[last_b])->f, "ñ̼"))) {
	  offset = atoi(cp + strlen("ñ̼:"));
	if (offset > 0 || (sp->bnst_data + dp->head[last_b])->tag_num <= -1 * offset) {
	  offset = 0;
	}
      }
      else {
	offset = 0;
      }

      /* Σ£äʤɤäϡäγʥե졼ˣ¸ߤ
	 ġ¤γʥե졼ˣ¸ߤϡ¤ˤȹͤ */
      if ((!check_feature((sp->bnst_data + last_b)->f, "ñ̵̼")) &&
	  check_feature(t_ptr->f, ":γ") && dp->head[last_b] - last_b == 1) {

	if (OptCaseFlag & OPT_CASE_USE_REP_CF) {
	  strp = get_mrph_rep(t_ptr->head_ptr);
	  rep_length = get_mrph_rep_length(strp);
	}
	else {
	  strp = t_ptr->head_ptr->Goi2;
	  rep_length = strlen(strp);
	}

	/* ֣Σáפå */
	ht_ptr = (sp->bnst_data + dp->head[last_b])->tag_ptr + 
	  (sp->bnst_data + dp->head[last_b])->tag_num - 1 + offset;	
	if (ht_ptr->cf_ptr) {
	  check_ac = check_examples(strp, rep_length,
				 ht_ptr->cf_ptr->ex_list[0],
				 ht_ptr->cf_ptr->ex_num[0]);
	}
	else {
	  check_ac = -1;
	}
	if (OptDisplay == OPT_DEBUG) {
	    fprintf(Outfp, "ľȽAC: %6s  %6s: %d\n",
		    t_ptr->head_ptr->Goi2, ht_ptr->head_ptr->Goi2, check_ac);	    
	}

	/* ¤ʣΤΥ롼 */
	for (j = 0, ht_ptr = (sp->bnst_data + dp->head[last_b])->tag_ptr; 
	     j < (sp->bnst_data + dp->head[last_b])->tag_num - 1 + offset;
	     j++, ht_ptr++) {
		    
	  if (OptCaseFlag & OPT_CASE_USE_REP_CF) {
	    strp = get_mrph_rep(t_ptr->head_ptr);
	    rep_length = get_mrph_rep_length(strp);
	  }
	  else {
	    strp = t_ptr->head_ptr->Goi2;
	    rep_length = strlen(strp);
	  }

	  /* ֣Σ¡פå */
	  if (OptDisplay == OPT_DEBUG && ht_ptr->cf_ptr) {
	      fprintf(Outfp, "ľȽAB: %6s  %6s: %d\n",
		      t_ptr->head_ptr->Goi2, ht_ptr->head_ptr->Goi2,
		      check_examples(strp, rep_length,
				     ht_ptr->cf_ptr->ex_list[0],
				     ht_ptr->cf_ptr->ex_num[0]));
	  }

	  if (check_ac == -1 && ht_ptr->cf_ptr &&
	      check_examples(strp, rep_length,
			     ht_ptr->cf_ptr->ex_list[0],
			     ht_ptr->cf_ptr->ex_num[0]) != -1) {
	      
	      offset = j - ((sp->bnst_data + dp->head[last_b])->tag_num - 1);
	      sprintf(buf, "ľ:%d", offset);
	      assign_cfeature(&((sp->bnst_data + dp->head[last_b])->f), buf, FALSE);
	      assign_cfeature(&(ht_ptr->f), buf, FALSE);
	      break;
	  }
	}		 
      }

      if (dp->head[last_b] == -1) {
	t_ptr->dpnd_head = -1;
      }
      else {
	t_ptr->dpnd_head = ((sp->bnst_data + dp->head[last_b])->tag_ptr + 
			    (sp->bnst_data + dp->head[last_b])->tag_num - 1 + offset)->num;
      }

      if (Language != CHINESE && (dp->type[last_b] == 'd' || dp->type[last_b] == 'R')) {
	t_ptr->dpnd_type = 'D';
      }
      else {
	t_ptr->dpnd_type = dp->type[last_b];
      }
    }
  }
}

/*==================================================================*/
         void dpnd_info_to_tag(SENTENCE_DATA *sp, DPND *dp)
/*==================================================================*/
{
  if (OptInput == OPT_RAW || 
      (OptInput & OPT_INPUT_BNST) ||
      OptUseNCF) {
    dpnd_info_to_tag_raw(sp, dp);
  }
  else {
    dpnd_info_to_tag_pm(sp);
  }
}

/*==================================================================*/
	    void dpnd_info_to_mrph_raw(SENTENCE_DATA *sp)
/*==================================================================*/
{
    int i, j, last_t, offset, head, proj_table[MRPH_MAX];
    MRPH_DATA *m_ptr, *head_ptr;

    /* initialize proj_table */
    memset(proj_table, 0, sizeof(int) * MRPH_MAX);

    for (i = 0, m_ptr = sp->mrph_data; i < sp->Mrph_num; i++, m_ptr++) {
	/* äȤᤤܶԤ򵭲 */
	if (m_ptr->tnum >= 0) {
	    last_t = m_ptr->tnum;
	}

	/* ʸ */
	if (i == sp->Mrph_num - 1) {
	    m_ptr->dpnd_head = -1;
	    m_ptr->dpnd_type = 'D';
	}
	/* ٤ˤ */
	else if (m_ptr->inum != 0) {
	    m_ptr->dpnd_head = m_ptr->num + 1;
	    m_ptr->dpnd_type = 'D';
	}
	/* ܶǸη (inum == 0) */
	else {
	    offset = 0;
	    head = (sp->tag_data + last_t)->dpnd_head;
	    m_ptr->dpnd_type = (sp->tag_data + last_t)->dpnd_type;

	    if (head == -1) {
		m_ptr->dpnd_head = -1;
	    }
	    else {
		/* m_ptr->dpnd_head = (sp->tag_data + head)->head_ptr->num; */
		head_ptr = find_head_mrph_from_dpnd_bnst((BNST_DATA *)(sp->tag_data + last_t), 
							 (BNST_DATA *)(sp->tag_data + head));
		/* check projectivity */
		if (proj_table[i] && proj_table[i] < head_ptr->num) {
		    if (OptDisplay == OPT_DEBUG) {
			fprintf(stderr, ";; violation of projectivity in mrph tree (%s: modified %dth mrph: %d -> %d)\n", 
				sp->KNPSID ? sp->KNPSID + 5: "?", i, head_ptr->num, proj_table[i]);
		    }
		    m_ptr->dpnd_head = proj_table[i];
		}
		else {
		    m_ptr->dpnd_head = head_ptr->num;

		    /* update proj_table */
		    for (j = i + 1; j < m_ptr->dpnd_head; j++) {
			if (!proj_table[j] || proj_table[j] > m_ptr->dpnd_head) {
			    proj_table[j] = m_ptr->dpnd_head;
			}
		    }
		}
	    }
	}
    }
}

/*==================================================================*/
	      void dpnd_info_to_mrph(SENTENCE_DATA *sp)
/*==================================================================*/
{
    if (OptInput == OPT_RAW || 
	(OptInput & OPT_INPUT_BNST) ||
	OptUseNCF) {
	dpnd_info_to_mrph_raw(sp);
    }
    else {
	/* dpnd_info_to_mrph_pm(sp); */
    }
}

/*==================================================================*/
void copy_para_info(SENTENCE_DATA *sp, BNST_DATA *dst, BNST_DATA *src)
/*==================================================================*/
{
  dst->para_num = src->para_num;
  dst->para_key_type = src->para_key_type;
  dst->para_top_p = src->para_top_p;
  dst->para_type = src->para_type;
  dst->to_para_p = src->to_para_p;
}

/*==================================================================*/
       void tag_bnst_postprocess(SENTENCE_DATA *sp, int flag)
/*==================================================================*/
{
  /* ñ̡ʸơǽŪʥñ̤ޡ
     flag == 0: num, dpnd_head ֹդؤϤʤ */

  int	i, j, count = -1, t_table[TAG_MAX], b_table[BNST_MAX], merge_to;
  TAG_DATA *t_ptr;
  BNST_DATA *b_ptr;
  char *cp;

  /* ѥ롼Ŭ 
     FEATURE¤ϤǹԤ */
  assign_general_feature(sp->tag_data, sp->Tag_num, PostProcessTagRuleType, FALSE, FALSE);

  /* ޡ륿ʸν */
  for (i = 0, t_ptr = sp->tag_data; i < sp->Tag_num; i++, t_ptr++) {
    /* Ȥnum, mrph_num¸ */
    t_ptr->preserve_mrph_num = t_ptr->mrph_num;
    if (t_ptr->bnum >= 0) { /* ʸڤǤ⤢Ȥ */
      t_ptr->b_ptr->preserve_mrph_num = t_ptr->b_ptr->mrph_num;
    }

    if (check_feature(t_ptr->f, "ԥޡ")) {
      for (merge_to = i - 1; merge_to >= 0; merge_to--) {
	if ((sp->tag_data + merge_to)->num >= 0) {
	  break;
	}
      }
      t_ptr->num = -1; /* ̵ʥñ̤ǤĤƤ */
      (sp->tag_data + merge_to)->mrph_num += t_ptr->mrph_num;
      (sp->tag_data + merge_to)->dpnd_head = t_ptr->dpnd_head;
      (sp->tag_data + merge_to)->dpnd_type = t_ptr->dpnd_type;
      for (j = 0; j < t_ptr->mrph_num; j++) {
	(sp->tag_data + merge_to)->length += strlen((t_ptr->mrph_ptr + j)->Goi2);
      }

      assign_cfeature(&((sp->tag_data + merge_to)->f), "-ܶޡ", FALSE);
      /* <ʸ><ñ̻>featureõϤʤ */

      if (t_ptr->bnum >= 0) { /* ʸڤǤ⤢Ȥ */
	for (merge_to = -1; t_ptr->b_ptr->num + merge_to >= 0; merge_to--) {
	  if ((t_ptr->b_ptr + merge_to)->num >= 0) {
	    break;
	  }
	}
	copy_para_info(sp, t_ptr->b_ptr + merge_to, t_ptr->b_ptr);
	t_ptr->b_ptr->num = -1;
	(t_ptr->b_ptr + merge_to)->mrph_num += t_ptr->b_ptr->mrph_num;
	(t_ptr->b_ptr + merge_to)->dpnd_head = t_ptr->b_ptr->dpnd_head;
	(t_ptr->b_ptr + merge_to)->dpnd_type = t_ptr->b_ptr->dpnd_type;
	for (j = 0; j < t_ptr->mrph_num; j++) {
	  (t_ptr->b_ptr + merge_to)->length += strlen((t_ptr->b_ptr->mrph_ptr + j)->Goi2);
	}
      }
    }
    else {
      count++;
    }
    t_table[i] = count;
  }

  if (flag == 0) {
    return;
  }

  count = -1;
  for (i = 0, b_ptr = sp->bnst_data; i < sp->Bnst_num; i++, b_ptr++) {
    if (b_ptr->num != -1) {
      count++;
    }
    b_table[i] = count;
  }

  /* ñֹι */
  for (i = 0, t_ptr = sp->tag_data; i < sp->Tag_num; i++, t_ptr++) {
    if (t_ptr->num != -1) { /* numι (ɤ tag_data + num 򤹤Ȥ) */
      t_ptr->num = t_table[i];
      if (t_ptr->dpnd_head != -1) {
	t_ptr->dpnd_head = t_table[t_ptr->dpnd_head];
      }
    }
    if (t_ptr->bnum >= 0) { /* bnumι (ɤ bnst_data + bnum 򤹤Ȥ) */
      t_ptr->bnum = b_table[t_ptr->bnum];
    }
  }

  /* ʸֹι */
  for (i = 0, b_ptr = sp->bnst_data; i < sp->Bnst_num; i++, b_ptr++) {
    if (b_ptr->num != -1) {
      b_ptr->num = b_table[i];
      if (b_ptr->dpnd_head != -1) {
	b_ptr->dpnd_head = b_table[b_ptr->dpnd_head];
      }
    }
  }
}

/*==================================================================*/
           void undo_tag_bnst_postprocess(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int i, b_count = 0;
  TAG_DATA *t_ptr;

  /* nbestץʤɤprint_result()ʣƤФȤΤ
     ѹnum, mrph_num, length򸵤ᤷƤ */

  for (i = 0, t_ptr = sp->tag_data; i < sp->Tag_num; i++, t_ptr++) {
    t_ptr->num = i;
    t_ptr->mrph_num = t_ptr->preserve_mrph_num;
    calc_bnst_length(sp, (BNST_DATA *)t_ptr);

    if (t_ptr->bnum >= 0) { /* ʸڤǤ⤢Ȥ */
      t_ptr->b_ptr->num = b_count++;
      t_ptr->bnum = t_ptr->b_ptr->num;
      t_ptr->b_ptr->mrph_num = t_ptr->b_ptr->preserve_mrph_num;
      calc_bnst_length(sp, t_ptr->b_ptr);
    }
  }    
}

/*==================================================================*/
              void para_postprocess(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int i;

  for (i = 0; i < sp->Bnst_num; i++) {
    if (check_feature((sp->bnst_data + i)->f, "Ѹ") &&
	!check_feature((sp->bnst_data + i)->f, "Ȥߤ") &&
	(sp->bnst_data + i)->para_num != -1 &&
	sp->para_data[(sp->bnst_data + i)->para_num].status != 'x') {
	    
      assign_cfeature(&((sp->bnst_data + i)->f), ":30", FALSE);
      assign_cfeature(&(((sp->bnst_data + i)->tag_ptr + 
			 (sp->bnst_data + i)->tag_num - 1)->f), ":30", FALSE);
    }
  }
}

/*==================================================================*/
        void dpnd_evaluation(SENTENCE_DATA *sp, DPND dpnd)
/*==================================================================*/
{
  int i, j, k, one_score, score, rentai, vacant_slot_num;
  int topic_score;
  int scase_check[SCASE_CODE_SIZE], ha_check, un_count, pred_p;
  char *cp, *cp2, *buffer;
  BNST_DATA *g_ptr, *d_ptr;

  /* ¸¤ɾδؿ
     (ʸˤĤơ˷äƤʸɾ׻)

     ɾ
     ========
     0. default֤Ȥκڥʥƥ(kakari_uke.rule)

     1. ֡ϡ(,:̤)ηͥ褵Τ
     (bnst_etc.ruleǻꡤΥϸץǻ)

     2. ֡ϡפϰҸ˰ķ뤳Ȥͥ(,̤)

     3. ٤ƤγǤƱɽسʤҸ˰ķ뤳Ȥͥ()

     4. ̤ʡϢνϥ,,˳ʤ;äƤ륹åȿͿ
  */

  score = 0;
  for (i = 1; i < sp->Bnst_num; i++) {
    g_ptr = sp->bnst_data + i;

    one_score = 0;
    for (k = 0; k < SCASE_CODE_SIZE; k++) scase_check[k] = 0;
    ha_check = 0;
    un_count = 0;

    if (check_feature(g_ptr->f, "Ѹ") ||
	check_feature(g_ptr->f, "Ѹ")) {
      pred_p = 1;
    } else {
      pred_p = 0;
    }

    for (j = i-1; j >= 0; j--) {
      d_ptr = sp->bnst_data + j;

      if (dpnd.head[j] == i) {

	/* DEFAULTΰ֤Ȥκڥʥƥ
	    C,B'Ʊ󤯤˷뤳Ȥ뤬줬
	   ¾η˱ƶʤ褦,ڥʥƥ˺Ĥ */

	if (check_feature(d_ptr->f, "")) {
	  one_score -= dpnd.dflt[j];
	} else {
	  one_score -= dpnd.dflt[j] * 2;
	}
	    
	/* ĤΤ٤ˤ뤳Ȥɤ */

	if (j + 1 == i && check_feature(d_ptr->f, "")) {
	  one_score -= 5;
	}

	if (pred_p &&
	    (cp = check_feature(d_ptr->f, "")) != NULL) {
		    
	  /* ̤ (֡ϡ)ΰ */

	  if (check_feature(d_ptr->f, "") &&
	      !strcmp(cp, ":̤")) {

	    /* ʸ, ֡פʤ, , C, B'˷뤳Ȥͥ */

	    if ((cp2 = check_feature(g_ptr->f, "")) 
		!= NULL) {
	      sscanf(cp2, "%*[^:]:%d", &topic_score);
	      one_score += topic_score;
	    }
	    /* else {one_score -= 15;} */

	    /* ĤˤͿ (,̤)
	        ʣ꤬ƱҸ˷뤳Ȥɤ */

	    if (check_feature(d_ptr->f, "") ||
		check_feature(d_ptr->f, "")) {
	      one_score += 10;
	    } else if (ha_check == 0){
	      one_score += 10;
	      ha_check = 1;
	    }
	  }

	  k = case2num(cp+3);

	  /* ǰ̤ΰ */

	  /* ̤ : ƤǶåȤĴ٤ (,̤) */

	  if (!strcmp(cp, ":̤")) {
	    if (check_feature(d_ptr->f, "") ||
		check_feature(d_ptr->f, "")) {
	      one_score += 10;
	    } else {
	      un_count++;
	    }
	  }

	  /* γ : θʳʤ break 
	      γǤˤͿʤ
	      γʤФγʤϤʤ

	      θפȤΤȽΤȡ
	     ʸʤɤǤѸ:ưȤʤäƤ뤳Ȥ
	     Τǡθפǥå */

	  else if (!strcmp(cp, ":γ")) {
	    if (!check_feature(g_ptr->f, "θ")) {
	      one_score += 10;
	      break;
	    }
	  } 

	  /*  : ʸΤǾʣ */

	  else if (!strcmp(cp, ":")) {
	    if (g_ptr->SCASE_code[case2num("")] &&
		scase_check[case2num("")] == 0) {
	      one_score += 10;
	      scase_check[case2num("")] = 1;
	    } 
	    else if (g_ptr->SCASE_code[case2num("")] &&
		     scase_check[case2num("")] == 0) {
	      one_score += 10;
	      scase_check[case2num("")] = 1;
	    }
	  }

	  /* ¾γ : Ƴ1Ĥ򤢤
	      ˳ʤξ硤֤Ȥʳ϶̤⡩ */
	  else if (k != -1) {
	    if (scase_check[k] == 0) {
	      scase_check[k] = 1;
	      one_score += 10;
	    } 
	  }

	  /* ֡Τϡפ˥ܡʥ 01/01/11
	     ۤȤɤξ

	     )
	     ֹĤΤ Ǥ ݤ ͳ Ĥ餷

	     ֻȤΤ  Ȥ
	     ֱ ʤ뤫ɤ ̯ Ȥ
	      ϡ֤/Ȥפ˷Ȱ

	     ¾ͤ Τ ˤʤ Ǥ
	      ۣʸ̮

	     )
	     ֤줬 ֣ͣФ ʬʤ Ǥ礦
	     ֡ ʤ  
	     ֥ӥ Τ Ѥ 塣
	     Ȥ ޤΤ 򤱤줽ˤʤ Ԥ
	     ֤ޤ ΩĤȤ פʤ 
	     ֤ɤ ޤ礦 뤵Ƥ ˡ
	     ǧ뤫ɤ 줿 Ƚǡ

	     ꢨ
	     ֤פ Τ褦ʾѸȤߤʤΤ
	  */

	  if (check_feature(d_ptr->f, "Ѹ") &&
	      (check_feature(d_ptr->f, ":̤") ||
	       check_feature(d_ptr->f, ":")) &&
	      check_feature(g_ptr->f, "Ѹ:Ƚ")) {
	    one_score += 3;
	  }
	}
      }
    }

    /* Ѹξ硤ǽṲ̄,,,˳,ϢνФ
       ,,˳ʤΥåʬͿ */

    if (pred_p) {

      /* Ϣνξ硤褬
	 ̾,Ū̾
	 ͽ,ָߡפʤ
	 ǤʤаĤγǤȹͤ */

      if (check_feature(g_ptr->f, ":Ϣ")) {
	if (check_feature(sp->bnst_data[dpnd.head[i]].f, "δط") || 
	    check_feature(sp->bnst_data[dpnd.head[i]].f, "롼볰δط")) {
	  rentai = 0;
	  one_score += 10;	/* δطʤ餳ǲ */
	} else {
	  rentai = 1;	/* ʳʤǶåȤå */
	}
      } else {
	rentai = 0;
      }

      /* Ƥ륬,,˳, */

      vacant_slot_num = 0;
      if ((g_ptr->SCASE_code[case2num("")]
	   - scase_check[case2num("")]) == 1) {
	vacant_slot_num ++;
      }
      if ((g_ptr->SCASE_code[case2num("")]
	   - scase_check[case2num("")]) == 1) {
	vacant_slot_num ++;
      }
      if ((g_ptr->SCASE_code[case2num("˳")]
	   - scase_check[case2num("˳")]) == 1 &&
	  rentai == 1 &&
	  check_feature(g_ptr->f, "Ѹ:ư")) {
	vacant_slot_num ++;
	/* ˳ʤưϢνξθĤޤϢ
	   ˳Ƥǡ̤ʤΥåȤȤϤʤ */
      }
      if ((g_ptr->SCASE_code[case2num("")]
	   - scase_check[case2num("")]) == 1) {
	vacant_slot_num ++;
      }

      /* åʬϢν̤ʤ˥Ϳ */

      if ((rentai + un_count) <= vacant_slot_num) 
	one_score += (rentai + un_count) * 10;
      else 
	one_score += vacant_slot_num * 10;
    }

    score += one_score;

    if (OptDisplay == OPT_DEBUG) {
      if (i == 1) 
	fprintf(Outfp, "Score:    ");
      if (pred_p) {
	fprintf(Outfp, "%2d*", one_score);
      } else {
	fprintf(Outfp, "%2d ", one_score);
      }
    }
  }

  if (OptDisplay == OPT_DEBUG) {
    fprintf(Outfp, "=%d\n", score);
  }

  if (OptDisplay == OPT_DEBUG || OptNbest == TRUE) {
    dpnd_info_to_bnst(sp, &dpnd);
    if (!(OptExpress & OPT_NOTAG)) {
      dpnd_info_to_tag(sp, &dpnd); 
    }
    if (make_dpnd_tree(sp)) {
      if (!(OptExpress & OPT_NOTAG)) {
	bnst_to_tag_tree(sp); /* ñ̤ڤ */
      }

      if (OptNbest == TRUE) {
	sp->score = score;
	print_result(sp, 0);
      }
      else {
	print_kakari(sp, OptExpress & OPT_NOTAG ? OPT_BNSTTREE : OPT_TREE);
      }
    }
  }

  if (score > sp->Best_mgr->score) {
    sp->Best_mgr->dpnd = dpnd;
    sp->Best_mgr->score = score;
    sp->Best_mgr->ID = dpndID;
    Possibility++;
  }

  dpndID++;
}

/*==================================================================*/
  void count_dpnd_candidates(SENTENCE_DATA *sp, DPND *dpnd, int pos)
/*==================================================================*/
{
  int i, count = 0, d_possibility = 1;
  BNST_DATA *b_ptr = sp->bnst_data + pos;

  if (pos == -1) {
    return;
  }

  if (pos < sp->Bnst_num - 2) {
    for (i = pos + 2; i < dpnd->head[pos + 1]; i++) {
      dpnd->mask[i] = 0;
    }
  }

  for (i = pos + 1; i < sp->Bnst_num; i++) {
    if (Quote_matrix[pos][i] &&
	dpnd->mask[i]) {

      if (d_possibility && Dpnd_matrix[pos][i] == 'd') {
	if (check_uncertain_d_condition(sp, dpnd, i)) {
	  dpnd->check[pos].pos[count] = i;
	  count++;
	}
	d_possibility = 0;
      }
      else if (Dpnd_matrix[pos][i] && 
	       Dpnd_matrix[pos][i] != 'd') {
	dpnd->check[pos].pos[count] = i;
	count++;
	d_possibility = 0;
      }

      /* ХꥢΥå */
      if (count && 
	  b_ptr->dpnd_rule->barrier.fp[0] && 
	  feature_pattern_match(&(b_ptr->dpnd_rule->barrier), 
				sp->bnst_data[i].f, 
				b_ptr, sp->bnst_data + i) == TRUE) {
	break;
      }
    }
  }

  if (count) {
    dpnd->check[pos].num = count;	/*  */
    dpnd->check[pos].def = b_ptr->dpnd_rule->preference == -1 ? count : b_ptr->dpnd_rule->preference;	/* ǥեȤΰ */
  }

  count_dpnd_candidates(sp, dpnd, pos - 1);
}

/*==================================================================*/
    void call_count_dpnd_candidates(SENTENCE_DATA *sp, DPND *dpnd)
/*==================================================================*/
{
  int i;

  for (i = 0; i < sp->Bnst_num; i++) {
    dpnd->mask[i] = 1;
    memset(&(dpnd->check[i]), 0, sizeof(CHECK_DATA));
    dpnd->check[i].num = -1;
  }

  count_dpnd_candidates(sp, dpnd, sp->Bnst_num - 1);
}

/*==================================================================*/
            void decide_dpnd(SENTENCE_DATA *sp, DPND dpnd)
/*==================================================================*/
{
  int i, count, possibilities[BNST_MAX], default_pos, d_possibility;
  int MaskFlag = 0;
  char *cp;
  BNST_DATA *b_ptr;
    
  if (OptDisplay == OPT_DEBUG) {
    if (dpnd.pos == sp->Bnst_num - 1) {
      fprintf(Outfp, "------");
      for (i = 0; i < sp->Bnst_num; i++)
	fprintf(Outfp, "-%02d", i);
      fputc('\n', Outfp);
    }
    fprintf(Outfp, "In %2d:", dpnd.pos);
    for (i = 0; i < sp->Bnst_num; i++)
      fprintf(Outfp, " %2d", dpnd.head[i]);
    fputc('\n', Outfp);
  }

  dpnd.pos --;

  /* ʸƬޤǲϤäɾؿ */

  if (dpnd.pos == -1) {
    /* ̵ʽ°: ʸη˽ */
    for (i = 0; i < sp->Bnst_num -1; i++)
      if (dpnd.head[i] < 0) {
	/* ꤨʤ */
	if (i >= dpnd.head[i + dpnd.head[i]]) {
	  return;
	}
	dpnd.head[i] = dpnd.head[i + dpnd.head[i]];
	dpnd.check[i].pos[0] = dpnd.head[i];
      }

    if (OptAnalysis == OPT_DPND ||
	OptAnalysis == OPT_CASE2) {
      dpnd_evaluation(sp, dpnd);
    } 
    else if (OptAnalysis == OPT_CASE) {
      call_case_analysis(sp, dpnd);
    }
    return;
  }

  b_ptr = sp->bnst_data + dpnd.pos;
  dpnd.f[dpnd.pos] = b_ptr->f;

  /* (ηˤ)򺹾 (dpnd.mask  0 ʤ鷸ʤ) */

  if (dpnd.pos < sp->Bnst_num - 2)
    for (i = dpnd.pos + 2; i < dpnd.head[dpnd.pos + 1]; i++)
      dpnd.mask[i] = 0;
    
  /* ¤Υʸ, ʬʸ<I>
     (Ǥ˹Ԥ줿¤Ϥη̤ޡ) */

  for (i = dpnd.pos + 1; i < sp->Bnst_num; i++) {
    if (Mask_matrix[dpnd.pos][i] == 2) {
      dpnd.head[dpnd.pos] = i;
      dpnd.type[dpnd.pos] = 'P';
      /* å */
      /* ξϰդ˷ޤäƤΤǡ󤲤Τϰ̣ʤ */
      dpnd.check[dpnd.pos].num = 1;
      dpnd.check[dpnd.pos].pos[0] = i;
      decide_dpnd(sp, dpnd);
      return;
    } else if (Mask_matrix[dpnd.pos][i] == 3) {
      dpnd.head[dpnd.pos] = i;
      dpnd.type[dpnd.pos] = 'I';

      dpnd.check[dpnd.pos].num = 1;
      dpnd.check[dpnd.pos].pos[0] = i;
      decide_dpnd(sp, dpnd);
      return;
    }
  }

  /* ʸη˽  ) ֡Τϰ */

  if ((cp = check_feature(b_ptr->f, ":̵ʽ°")) != NULL) {
    sscanf(cp, "%*[^:]:%*[^:]:%d", &(dpnd.head[dpnd.pos]));
    dpnd.type[dpnd.pos] = 'D';
    dpnd.dflt[dpnd.pos] = 0;
    dpnd.check[dpnd.pos].num = 1;
    decide_dpnd(sp, dpnd);
    return;
  }

  /* ̾η */

  /* θĴ٤ */
    
  count = 0;
  d_possibility = 1;
  for (i = dpnd.pos + 1; i < sp->Bnst_num; i++) {
    if (Mask_matrix[dpnd.pos][i] &&
	Quote_matrix[dpnd.pos][i] &&
	dpnd.mask[i]) {

      if (d_possibility && Dpnd_matrix[dpnd.pos][i] == 'd') {
	if (check_uncertain_d_condition(sp, &dpnd, i)) {
	  possibilities[count] = i;
	  count++;
	}
	d_possibility = 0;
      }
      else if (Dpnd_matrix[dpnd.pos][i] && 
	       Dpnd_matrix[dpnd.pos][i] != 'd') {
	possibilities[count] = i;
	count++;
	d_possibility = 0;
      }

      /* ХꥢΥå */
      if (count &&
	  b_ptr->dpnd_rule->barrier.fp[0] &&
	  feature_pattern_match(&(b_ptr->dpnd_rule->barrier), 
				sp->bnst_data[i].f,
				b_ptr, sp->bnst_data + i) == TRUE)
	break;
    }
    else {
      MaskFlag = 1;
    }
  }

  /* ºݤ˸ĤäƤ(δؿκƵŪƤӽФ) */

  if (count) {

    /* preference ϰֶ᤯:1, :2, Ǹ:-1
       default_pos ϰֶ᤯:1, :2, Ǹ:count ѹ */

    default_pos = (b_ptr->dpnd_rule->preference == -1) ?
      count: b_ptr->dpnd_rule->preference;

    dpnd.check[dpnd.pos].num = count;	/*  */
    dpnd.check[dpnd.pos].def = default_pos;	/* ǥեȤΰ */
    for (i = 0; i < count; i++) {
      dpnd.check[dpnd.pos].pos[i] = possibilities[i];
    }

    /* դ˷ꤹ */

    if (b_ptr->dpnd_rule->barrier.fp[0] == NULL || 
	b_ptr->dpnd_rule->decide) {
      if (default_pos <= count) {
	dpnd.head[dpnd.pos] = possibilities[default_pos - 1];
      } else {
	dpnd.head[dpnd.pos] = possibilities[count - 1];
	/* default_pos  2 ʤΤˡcount 1 ʤ */
      }
      dpnd.type[dpnd.pos] = Dpnd_matrix[dpnd.pos][dpnd.head[dpnd.pos]];
      dpnd.dflt[dpnd.pos] = 0;
      decide_dpnd(sp, dpnd);
    } 

    /* ٤ƤβǽĤФ */
    /* ֤ηξϰդ˷٤ */

    else {
      for (i = 0; i < count; i++) {
	dpnd.head[dpnd.pos] = possibilities[i];
	dpnd.type[dpnd.pos] = Dpnd_matrix[dpnd.pos][dpnd.head[dpnd.pos]];
	dpnd.dflt[dpnd.pos] = abs(default_pos - 1 - i);
	decide_dpnd(sp, dpnd);
      }
    }
  } 

  /* 褬ʤ
     ʸ˥ޥƤʤСʸ˷Ȥ */

  else {
    if (Mask_matrix[dpnd.pos][sp->Bnst_num - 1]) {
      dpnd.head[dpnd.pos] = sp->Bnst_num - 1;
      dpnd.type[dpnd.pos] = 'D';
      dpnd.dflt[dpnd.pos] = 10;
      dpnd.check[dpnd.pos].num = 1;
      dpnd.check[dpnd.pos].pos[0] = sp->Bnst_num - 1;
      decide_dpnd(sp, dpnd);
    }
  }
}

/*==================================================================*/
           void when_no_dpnd_struct(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int i;

  sp->Best_mgr->dpnd.head[sp->Bnst_num - 1] = -1;
  sp->Best_mgr->dpnd.type[sp->Bnst_num - 1] = 'D';

  for (i = sp->Bnst_num - 2; i >= 0; i--) {
    sp->Best_mgr->dpnd.head[i] = i + 1;
    sp->Best_mgr->dpnd.type[i] = 'D';
    sp->Best_mgr->dpnd.check[i].num = 1;
    sp->Best_mgr->dpnd.check[i].pos[0] = i + 1;
  }

  sp->Best_mgr->score = 0;
}

/*==================================================================*/
              int after_decide_dpnd(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int i, j;
  TAG_DATA *check_b_ptr;
    
  /* Ϻ: ¤Ϳ줿1ĤΤ */
  if (OptInput & OPT_PARSED) {
    Possibility = 1;
  }

  if (Possibility != 0) {
    /* ¸¤ ʲϤԤ */
    if (OptAnalysis == OPT_CASE2) {
      sp->Best_mgr->score = -10000;
      if (call_case_analysis(sp, sp->Best_mgr->dpnd) == FALSE) {
	return FALSE;
      }
    }

    /* ¸¤ʹ¤ν */

    /* ʲϷ̤ξfeature */
    if (OptAnalysis == OPT_CASE || OptAnalysis == OPT_CASE2) {
      /* ʲϷ̤Ѹܶfeature */
      for (i = 0; i < sp->Best_mgr->pred_num; i++) {
	assign_nil_assigned_components(sp, &(sp->Best_mgr->cpm[i])); /* ̤бǤν */

	assign_case_component_feature(sp, &(sp->Best_mgr->cpm[i]), FALSE);

	/* ʥե졼ΰ̣Ѹܶfeature */
	for (j = 0; j < sp->Best_mgr->cpm[i].cmm[0].cf_ptr->element_num; j++) {
	  append_cf_feature(&(sp->Best_mgr->cpm[i].pred_b_ptr->f), 
			    &(sp->Best_mgr->cpm[i]), sp->Best_mgr->cpm[i].cmm[0].cf_ptr, j);
	}
      }
    }

    /* ڤ */
    dpnd_info_to_bnst(sp, &(sp->Best_mgr->dpnd));
    if (make_dpnd_tree(sp) == FALSE) {
      return FALSE;
    }
    bnst_to_tag_tree(sp); /* ñ̤ڤ */

    if (OptAnalysis == OPT_CASE || OptAnalysis == OPT_CASE2) {
      /* ʲϤη̤Ѹʸ */
      for (i = 0; i < sp->Best_mgr->pred_num; i++) {
	sp->Best_mgr->cpm[i].pred_b_ptr->cpm_ptr = &(sp->Best_mgr->cpm[i]);
	/*  Ū
	   ΤȤ make_dpnd_tree() ƤӽФ cpm_ptr ʤʤΤǡ
	   ǥԡƤ */
	check_b_ptr = sp->Best_mgr->cpm[i].pred_b_ptr;
	while (check_b_ptr->parent && check_b_ptr->parent->para_top_p == TRUE && 
	       check_b_ptr->parent->cpm_ptr == NULL) {
	  check_b_ptr->parent->cpm_ptr = &(sp->Best_mgr->cpm[i]);
	  check_b_ptr = check_b_ptr->parent;
	}

	/* ƳǤοѸ
	    ʸ̮ϤΤȤ˳ʥե졼ꤷƤʤƤʲϤϹԤäƤΤ
	    */
	for (j = 0; j < sp->Best_mgr->cpm[i].cf.element_num; j++) {
	  /* άϤη or ϢνϽ */
	  if (sp->Best_mgr->cpm[i].elem_b_num[j] <= -2 || 
	      sp->Best_mgr->cpm[i].elem_b_ptr[j]->num > sp->Best_mgr->cpm[i].pred_b_ptr->num) {
	    continue;
	  }
	  sp->Best_mgr->cpm[i].elem_b_ptr[j]->pred_b_ptr = sp->Best_mgr->cpm[i].pred_b_ptr;
	}

	/* ʥե졼ब */
	if (sp->Best_mgr->cpm[i].result_num != 0 && 
	    sp->Best_mgr->cpm[i].cmm[0].cf_ptr->cf_address != -1 && 
	    (((OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	      sp->Best_mgr->cpm[i].cmm[0].score != CASE_MATCH_FAILURE_PROB) || 
	     (!(OptCaseFlag & OPT_CASE_USE_PROBABILITY) && 
	      sp->Best_mgr->cpm[i].cmm[0].score != CASE_MATCH_FAILURE_SCORE))) {
	  /* ʸ̮ϤΤȤϳʥե졼ꤷƤѸˤĤƤΤ */
	  if (!OptEllipsis || sp->Best_mgr->cpm[i].decided == CF_DECIDED) {
	    if (OptCaseFlag & OPT_CASE_ASSIGN_GA_SUBJ) {
	      assign_ga_subject(sp, &(sp->Best_mgr->cpm[i]));
	    }
	    fix_sm_place(sp, &(sp->Best_mgr->cpm[i]));

	    if (OptUseSmfix == TRUE) {
	      specify_sm_from_cf(sp, &(sp->Best_mgr->cpm[i]));
	    }

	    /* ޥåfeature˽ *
	       record_match_ex(sp, &(sp->Best_mgr->cpm[i])); */

	    /* ľʤΥޥåfeature˽ *
	       record_closest_cc_match(sp, &(sp->Best_mgr->cpm[i])); */

	    /* ʲϤη̤ѤƷۣ */
	    verb_lexical_disambiguation_by_case_analysis(&(sp->Best_mgr->cpm[i]));
	    noun_lexical_disambiguation_by_case_analysis(&(sp->Best_mgr->cpm[i]));
	  }
	  else if (sp->Best_mgr->cpm[i].decided == CF_CAND_DECIDED) {
	    if (OptCaseFlag & OPT_CASE_ASSIGN_GA_SUBJ) {
	      assign_ga_subject(sp, &(sp->Best_mgr->cpm[i]));
	    }
	  }

	  if (sp->Best_mgr->cpm[i].decided == CF_DECIDED) {
	    assign_cfeature(&(sp->Best_mgr->cpm[i].pred_b_ptr->f), "ʥե졼", FALSE);
	  }
	}
      }
    }
    return TRUE;
  }
  else { 
    return FALSE;
  }
}

/*==================================================================*/
            int detect_dpnd_case_struct(SENTENCE_DATA *sp)
/*==================================================================*/
{
  int i;
  DPND dpnd;

  sp->Best_mgr->score = -10000; /* ϡ֤礭׻촹Τǡ
				   ͤϽʬƤ */
  sp->Best_mgr->dflt = 0;
  sp->Best_mgr->ID = -1;
  Possibility = 0;
  dpndID = 0;

  /* ֤ν */

  for (i = 0; i < sp->Bnst_num; i++) {
    dpnd.head[i] = -1;
    dpnd.type[i] = 'D';
    dpnd.dflt[i] = 0;
    dpnd.mask[i] = 1;
    memset(&(dpnd.check[i]), 0, sizeof(CHECK_DATA));
    dpnd.check[i].num = -1;
    dpnd.f[i] = NULL;
  }
  dpnd.pos = sp->Bnst_num - 1;

  /* ʲϥåν */
  if (OptAnalysis == OPT_CASE) {
    InitCPMcache();
  }

  /* ¸¤ --> ʹ¤ */

  decide_dpnd(sp, dpnd);

  /* ʲϥåν */
  if (OptAnalysis == OPT_CASE) {
    ClearCPMcache();
  }

  return after_decide_dpnd(sp);
}

/*==================================================================*/
            void check_candidates(SENTENCE_DATA *sp)
/*==================================================================*/
{
    int i, j, b2t_table[BNST_MAX];
    TOTAL_MGR *tm = sp->Best_mgr;
    char b_buffer[DATA_LEN], t_buffer[DATA_LEN], tmp_b_buffer[SMALL_DATA_LEN], tmp_t_buffer[SMALL_DATA_LEN], *cp;

    for (i = 0; i < sp->Bnst_num; i++) { /* ʸֹ->ֹܶΥơ֥ */
	b2t_table[(sp->bnst_data + i)->num] = ((sp->bnst_data + i)->tag_ptr + (sp->bnst_data + i)->tag_num - 1)->num;
    }

    /* ʸᤴȤ˥åѤ feature Ϳ */
    for (i = 0; i < sp->Bnst_num; i++)
	if (tm->dpnd.check[i].num != -1) {
	    /* ¦ ->  */
	    sprintf(b_buffer, "");
	    sprintf(t_buffer, "");
	    for (j = 0; j < tm->dpnd.check[i].num; j++) {
		/* 䤿 */
		sprintf(tmp_b_buffer, ":%d", tm->dpnd.check[i].pos[j]);
		sprintf(tmp_t_buffer, ":%d", b2t_table[tm->dpnd.check[i].pos[j]]);
		if (strlen(t_buffer)+strlen(tmp_t_buffer) >= DATA_LEN) {
		    fprintf(stderr, ";; Too long string <%s> (%d) in check_candidates. (%s)\n", 
			    t_buffer, tm->dpnd.check[i].num, sp->KNPSID ? sp->KNPSID+5 : "?");
		    return;
		}
		strcat(b_buffer, tmp_b_buffer);
		strcat(t_buffer, tmp_t_buffer);
	    }
	    assign_cfeature(&((sp->bnst_data + i)->f), b_buffer, FALSE);
	    assign_cfeature(&(((sp->bnst_data + i)->tag_ptr + (sp->bnst_data + i)->tag_num - 1)->f), t_buffer, FALSE);
	}
}

/*==================================================================*/
              void memo_by_program(SENTENCE_DATA *sp)
/*==================================================================*/
{
  /*
   *  ץˤؤν񤭹
   */

  /* ¤˵Ͽ
     int i;

     for (i = 0; i < sp->Bnst_num - 1; i++) {
     if (sp->Best_mgr->dpnd.type[i] == 'd') {
     strcat(PM_Memo, " d");
     sprintf(PM_Memo+strlen(PM_Memo), "(%d)", i);
     } else if (sp->Best_mgr->dpnd.type[i] == 'R') {
     strcat(PM_Memo, " R");
     sprintf(PM_Memo+strlen(PM_Memo), "(%d)", i);
     }
     }
  */

  /* 󤤷˵Ͽ

  for (i = 0; i < sp->Bnst_num - 1; i++) {
  if (sp->Best_mgr->dpnd.head[i] > i + 3 &&
  !check_feature(sp->bnst_data[i].f, "") &&
  !check_feature(sp->bnst_data[i].f, "") &&
  !check_feature(sp->bnst_data[i].f, "Ѹ") &&
  !check_feature(sp->bnst_data[i].f, ":") &&
  !check_feature(sp->bnst_data[i].f, "Ѹ:̵") &&
  !check_feature(sp->bnst_data[i].f, "¥") &&
  !check_feature(sp->bnst_data[i+1].f, "̻")) {
  strcat(PM_Memo, " ");
  sprintf(PM_Memo+strlen(PM_Memo), "(%d)", i);
  }
  }
  */
}

/*====================================================================
                                  END
  ====================================================================*/
