/*====================================================================
                                   CKY

  $Id: cky.c,v 1.152.2.1 2009/10/19 23:34:31 kawahara Exp $

  ====================================================================*/

#include "knp.h"

typedef struct _CKY *CKYptr;
typedef struct _CKY {
    int		i;
    int		j;
    char	cp;
    double	score;		/* score at this point */
    double	para_score;	/* coordination score */
    double      chicase_score;
    double      chicase_lex_score;
    int		para_flag;	/* coordination flag */
    char	dpnd_type;	/* type of dependency (D or P) */
    int		direction;	/* direction of dependency */
    int         index;          /* index of dpnd rule for Chinese */
    BNST_DATA	*b_ptr;
    int 	scase_check[SCASE_CODE_SIZE];
    int		un_count;
    CF_PRED_MGR *cpm_ptr;	/* case components */
    CKYptr	left;		/* pointer to the left child */
    CKYptr	right;		/* pointer to the right child */
    CKYptr	next;		/* pointer to the next CKY data at this point */

  int        left_pos_index;  /* pos index for Chinese */
  int        right_pos_index;  /* pos index for Chinese */
} CKY;

#define DOUBLE_MINUS    -999.0
#define PARA_THRESHOLD	0

#define	CKY_TABLE_MAX	1000000 

CKY *cky_matrix[BNST_MAX][BNST_MAX];/* CKYγư֤κǽCKYǡؤΥݥ */
CKY cky_table[CKY_TABLE_MAX];	  /* an array of CKY data */
int cpm_allocated_cky_num = -1;

/* add a clausal modifiee to CPM */
void make_data_cframe_rentai_simple(CF_PRED_MGR *pre_cpm_ptr, TAG_DATA *d_ptr, TAG_DATA *t_ptr) {

    /* δطʳΤȤϳǤ (δطǤƻΤȤϳǤˤ) */
    if (!check_feature(t_ptr->f, "δط") || check_feature(d_ptr->f, "Ѹ:")) {
	_make_data_cframe_pp(pre_cpm_ptr, d_ptr, FALSE);
    }
    /* դ˳δطˤ */
    else {
	pre_cpm_ptr->cf.pp[pre_cpm_ptr->cf.element_num][0] = pp_hstr_to_code("δط");
	pre_cpm_ptr->cf.pp[pre_cpm_ptr->cf.element_num][1] = END_M;
	pre_cpm_ptr->cf.oblig[pre_cpm_ptr->cf.element_num] = FALSE;
    }

    _make_data_cframe_sm(pre_cpm_ptr, t_ptr);
    _make_data_cframe_ex(pre_cpm_ptr, t_ptr);
    pre_cpm_ptr->elem_b_ptr[pre_cpm_ptr->cf.element_num] = t_ptr;
    pre_cpm_ptr->elem_b_ptr[pre_cpm_ptr->cf.element_num]->next = NULL;
    pre_cpm_ptr->elem_b_num[pre_cpm_ptr->cf.element_num] = -1;
    pre_cpm_ptr->cf.weight[pre_cpm_ptr->cf.element_num] = 0;
    pre_cpm_ptr->cf.adjacent[pre_cpm_ptr->cf.element_num] = FALSE;
    pre_cpm_ptr->cf.element_num++;
}

/* add coordinated case components to CPM */
TAG_DATA **add_coordinated_phrases(CKY *cky_ptr, TAG_DATA **next) {
    while (cky_ptr) { /* ʬΥå */
	if (cky_ptr->para_flag || cky_ptr->dpnd_type == 'P') {
	    break;
	}
	cky_ptr = cky_ptr->right;
    }

    if (!cky_ptr) {
	return NULL;
    }
    else if (cky_ptr->para_flag) { /* parent of <PARA> + <PARA> */
	return add_coordinated_phrases(cky_ptr->left, add_coordinated_phrases(cky_ptr->right, next));
    }
    else if (cky_ptr->dpnd_type == 'P') {
	TAG_DATA **next_pp;

	*next = cky_ptr->left->b_ptr->tag_ptr + cky_ptr->left->b_ptr->tag_num - 1;
	(*next)->next = NULL;
	next_pp = add_coordinated_phrases(cky_ptr->right, &((*next)->next));

	if (next_pp) {
	    return next_pp;
	}
	else {
	    return &((*next)->next);
	}
    }
    else {
	return NULL;
    }
}

char check_dpnd_possibility (SENTENCE_DATA *sp, int dep, int gov, int begin, int relax_flag) {
    if ((OptParaFix == 0 && 
	 begin >= 0 && 
	 (sp->bnst_data + dep)->para_num != -1 && 
	 Para_matrix[(sp->bnst_data + dep)->para_num][begin][gov] >= PARA_THRESHOLD) || /* para score is more than threshold */
	(OptParaFix == 1 && 
	 Mask_matrix[dep][gov] == 2)) {   /* P */
	return 'P';
    }
    else if (OptParaFix == 1 && 
	     Mask_matrix[dep][gov] == 3) { /* I */
	return 'I';
    }
    else if (Dpnd_matrix[dep][gov] && Quote_matrix[dep][gov] && 
	     ((Language != CHINESE && (OptParaFix == 0 || Mask_matrix[dep][gov] == 1)) ||
	      (Language == CHINESE && Mask_matrix[dep][gov] != 0))) {
	return Dpnd_matrix[dep][gov];
    }
    else if ((Dpnd_matrix[dep][gov] == 'R' || relax_flag) && Language != CHINESE) { /* relax */
	return 'R';
    }

    return '\0';
}

/* make an array of dependency possibilities */
void make_work_mgr_dpnd_check(SENTENCE_DATA *sp, CKY *cky_ptr, BNST_DATA *d_ptr) {
    int i, count = 0, start;
    BNST_DATA *tmp_d_ptr;
    TAG_DATA *tmp_t_ptr = d_ptr->tag_ptr + d_ptr->tag_num - 1;

    while (tmp_t_ptr) {
	tmp_d_ptr = tmp_t_ptr->b_ptr;
	/* ٤ˤ¤(1+1)˷ϵΥ1Ȥ */
	if (cky_ptr->right && cky_ptr->right->dpnd_type == 'P' && cky_ptr->right->j < tmp_d_ptr->num + 3)
	    start = cky_ptr->right->j;
	else
	    start = tmp_d_ptr->num + 1;

	for (i = start; i < sp->Bnst_num; i++) {
	    if (check_dpnd_possibility(sp, tmp_d_ptr->num, i, -1, ((i == sp->Bnst_num - 1) && count == 0) ? TRUE : FALSE)) {
		Work_mgr.dpnd.check[tmp_d_ptr->num].pos[count] = i;
		count++;
	    }
	}

	Work_mgr.dpnd.check[tmp_d_ptr->num].num = count;
	tmp_t_ptr = tmp_t_ptr->next;
    }
}

void make_work_mgr_dpnd_check_for_noun(SENTENCE_DATA *sp, BNST_DATA *d_ptr) {
    int i, count = 0;

    for (i = d_ptr->num + 1; i < sp->Bnst_num; i++) {
	if (check_feature((sp->bnst_data + i)->f, "θ")) {
	    Work_mgr.dpnd.check[d_ptr->num].pos[count] = i;
	    count++;
	}
    }

    Work_mgr.dpnd.check[d_ptr->num].num = count;
}

int convert_to_dpnd(SENTENCE_DATA *sp, TOTAL_MGR *Best_mgr, CKY *cky_ptr) {
    int i;
    char *cp;

    /* make case analysis result for clausal modifiee */
    if (OptAnalysis == OPT_CASE) {
	if (cky_ptr->cpm_ptr->pred_b_ptr && 
	    Best_mgr->cpm[cky_ptr->cpm_ptr->pred_b_ptr->pred_num].pred_b_ptr == NULL) {
	    copy_cpm(&(Best_mgr->cpm[cky_ptr->cpm_ptr->pred_b_ptr->pred_num]), cky_ptr->cpm_ptr, 0);
	    cky_ptr->cpm_ptr->pred_b_ptr->cpm_ptr = &(Best_mgr->cpm[cky_ptr->cpm_ptr->pred_b_ptr->pred_num]);
	}

	if (cky_ptr->left && cky_ptr->right && 
	    cky_ptr->left->cpm_ptr->pred_b_ptr && 
	    (check_feature(cky_ptr->left->cpm_ptr->pred_b_ptr->f, ":Ϣ") || /* clausal modifiee */
	     check_feature(cky_ptr->left->cpm_ptr->pred_b_ptr->f, "Ĵʸ"))) {
	    CF_PRED_MGR *cpm_ptr = &(Best_mgr->cpm[cky_ptr->left->cpm_ptr->pred_b_ptr->pred_num]);

	    if (cpm_ptr->pred_b_ptr == NULL) { /* ޤBest_mgr˥ԡƤʤȤ */
		copy_cpm(cpm_ptr, cky_ptr->left->cpm_ptr, 0);
		cky_ptr->left->cpm_ptr->pred_b_ptr->cpm_ptr = cpm_ptr;
	    }

	    make_work_mgr_dpnd_check(sp, cky_ptr->left, cky_ptr->right->b_ptr);
	    make_data_cframe_rentai_simple(cpm_ptr, cpm_ptr->pred_b_ptr, 
					   cky_ptr->right->b_ptr->tag_ptr + cky_ptr->right->b_ptr->tag_num - 1);
	    find_best_cf(sp, cpm_ptr, get_closest_case_component(sp, cpm_ptr), 1);
	}
    }

    if (cky_ptr->left && cky_ptr->right) {
	if (OptDisplay == OPT_DEBUG) {
	    printf("(%d, %d): (%d, %d) (%d, %d)\n", cky_ptr->i, cky_ptr->j, cky_ptr->left->i, cky_ptr->left->j, cky_ptr->right->i, cky_ptr->right->j);
	}

	if (cky_ptr->para_flag == 0) {
	    if (cky_ptr->dpnd_type != 'P' && 
		(cp = check_feature(cky_ptr->left->b_ptr->f, ":̵ʽ°")) != NULL) {
		sscanf(cp, "%*[^:]:%*[^:]:%d", &(Best_mgr->dpnd.head[cky_ptr->left->b_ptr->num]));
		Best_mgr->dpnd.type[cky_ptr->left->b_ptr->num] = 
		    Dpnd_matrix[cky_ptr->left->b_ptr->num][cky_ptr->right->b_ptr->num];
	    }
	    else {
		if (cky_ptr->direction == RtoL) { /* <- */
		    Best_mgr->dpnd.head[cky_ptr->right->b_ptr->num] = cky_ptr->left->b_ptr->num;
		    Best_mgr->dpnd.type[cky_ptr->right->b_ptr->num] = cky_ptr->dpnd_type;
		}
		else { /* -> */
		    Best_mgr->dpnd.head[cky_ptr->left->b_ptr->num] = cky_ptr->right->b_ptr->num;
		    Best_mgr->dpnd.type[cky_ptr->left->b_ptr->num] = cky_ptr->dpnd_type;
		}
	    }		    
	}

	convert_to_dpnd(sp, Best_mgr, cky_ptr->left);
	convert_to_dpnd(sp, Best_mgr, cky_ptr->right);
    }
    else {
	if (OptDisplay == OPT_DEBUG) {
	    printf("(%d, %d)\n", cky_ptr->i, cky_ptr->j);
	}
    }

    call_count_dpnd_candidates(sp, &(Best_mgr->dpnd));
}

int check_scase (BNST_DATA *g_ptr, int *scase_check, int rentai, int un_count) {
    int vacant_slot_num = 0;

    /* Ƥ륬,,˳, */
    if ((g_ptr->SCASE_code[case2num("")]
	 - scase_check[case2num("")]) == 1) {
	vacant_slot_num++;
    }
    if ((g_ptr->SCASE_code[case2num("")]
	 - scase_check[case2num("")]) == 1) {
	vacant_slot_num++;
    }
    if ((g_ptr->SCASE_code[case2num("˳")]
	 - scase_check[case2num("˳")]) == 1 &&
	rentai == 1 &&
	check_feature(g_ptr->f, "Ѹ:ư")) {
	vacant_slot_num++;
	/* ˳ʤưϢνξθĤޤϢ
	   ˳Ƥǡ̤ʤΥåȤȤϤʤ */
    }
    if ((g_ptr->SCASE_code[case2num("")]
	 - scase_check[case2num("")]) == 1) {
	vacant_slot_num++;
    }

    /* åʬϢν̤ʤ˥Ϳ */
    if ((rentai + un_count) <= vacant_slot_num) {
	return (rentai + un_count) * 10;
    }
    else {
	return vacant_slot_num * 10;
    }
}

/* conventional scoring function */
double calc_score(SENTENCE_DATA *sp, CKY *cky_ptr) {
    CKY *right_ptr = cky_ptr->right, *tmp_cky_ptr = cky_ptr, *tmp_child_ptr;
    BNST_DATA *g_ptr = cky_ptr->b_ptr, *d_ptr;
    int i, k, pred_p = 0, topic_score = 0;
    int ha_check = 0, *un_count;
    int rentai, vacant_slot_num, *scase_check;
    int count, pos, default_pos;
    int verb, comma;
    double one_score = 0;
    double prob;
    char *cp, *cp2;

    double chi_pa_thre;
    double weight_dpnd, weight_pos, weight_comma, weight_root, weight_pa;
    double pos_prob_thre_high, pos_prob_thre_low;
    int pos_occur_thre_high, pos_occur_thre_low;

    int left_arg_num;
    int right_arg_num;
    int ptr_num;
    double chicase_prob;

    int pre_pos_index;

    chi_pa_thre = 0.00005;

    weight_dpnd = 1.0;
    weight_pos = 0.5;
    weight_comma = 1.0;
    weight_root = 0.5;
    weight_pa = 1.0;

    pos_prob_thre_high = 0.95;
    pos_prob_thre_low = 0.05;

    pos_occur_thre_high = 100;
    pos_occur_thre_low = 50;

    /* оݤѸʳΥ򽸤 (right򤿤ɤʤleftΥ­) */
    while (tmp_cky_ptr) {
	if (tmp_cky_ptr->direction == LtoR ? tmp_cky_ptr->left : tmp_cky_ptr->right) {
	    one_score += tmp_cky_ptr->direction == LtoR ? tmp_cky_ptr->left->score : tmp_cky_ptr->right->score;
	}
	tmp_cky_ptr = tmp_cky_ptr->direction == LtoR ? tmp_cky_ptr->right : tmp_cky_ptr->left;
    }
    if (OptDisplay == OPT_DEBUG) {
	printf("%.3f=>", one_score);
    }

    if (check_feature(g_ptr->f, "Ѹ") ||
	check_feature(g_ptr->f, "Ѹ")) {
	pred_p = 1;
	for (k = 0; k < SCASE_CODE_SIZE; k++) cky_ptr->scase_check[k] = 0;
	scase_check = &(cky_ptr->scase_check[0]);
	cky_ptr->un_count = 0;
	un_count = &(cky_ptr->un_count);
    }

    /* ٤ƤλҶˤĤ */
    while (cky_ptr) {
	if (cky_ptr->direction == LtoR ? cky_ptr->left : cky_ptr->right) {
	    d_ptr = cky_ptr->direction == LtoR ? cky_ptr->left->b_ptr : cky_ptr->right->b_ptr;

	    if ((d_ptr->num < g_ptr->num &&
		 (Mask_matrix[d_ptr->num][g_ptr->num] == 2 || /* P */
		  Mask_matrix[d_ptr->num][g_ptr->num] == 3)) || /* I */
		(g_ptr->num < d_ptr->num &&
		 (Mask_matrix[g_ptr->num][d_ptr->num] == 2 || /* P */
		  Mask_matrix[g_ptr->num][d_ptr->num] == 3))) { /* I */
		;
	    }
	    else {
		/* ΥȤ׻뤿ˡޤθĴ٤ */
		count = 0;
		pos = 0;
		verb = 0;
		comma = 0;
		if (d_ptr->num < g_ptr->num) {
		    for (i = d_ptr->num + 1; i < sp->Bnst_num; i++) {
			if (check_dpnd_possibility(sp, d_ptr->num, i, cky_ptr->i, ((i == sp->Bnst_num - 1) && count == 0) ? TRUE : FALSE)) {
			    if (i == g_ptr->num) {
				pos = count;
			    }
			    count++;
			}
			if (i >= g_ptr->num) {
			    continue;
			}
		    }
		}
		else {
		    for (i = d_ptr->num - 1; i >= 0; i--) {
			if (check_dpnd_possibility(sp, i ,d_ptr->num, cky_ptr->i, FALSE)) {
			    if (i == g_ptr->num) {
				pos = count;
			    }
			    count++;
			}
			if (i <= g_ptr->num) {
			    continue;
			}
		    }
		}

		default_pos = (d_ptr->dpnd_rule->preference == -1) ?
		    count : d_ptr->dpnd_rule->preference;
		

		/* DEFAULTΰ֤Ȥκڥʥƥ
		    C,B'Ʊ󤯤˷뤳Ȥ뤬줬
		   ¾η˱ƶʤ褦,ڥʥƥ˺Ĥ */
		if (check_feature(d_ptr->f, "")) {
		    one_score -= abs(default_pos - 1 - pos);
		}
		else if (Language != CHINESE){
		    one_score -= abs(default_pos - 1 - pos) * 2;
		}

		/* ĤΤ٤ˤ뤳Ȥɤ */
		if (d_ptr->num + 1 == g_ptr->num && 
		    abs(default_pos - 1 - pos) > 0 && 
		    (check_feature(d_ptr->f, ""))) {
		    one_score -= 5;
		}
	    }
	    
	    if (pred_p && (cp = check_feature(d_ptr->f, "")) != NULL) {
		    
		/* ̤ (֡ϡ)ΰ */
		if (check_feature(d_ptr->f, "") && !strcmp(cp, ":̤")) {

		    /* ʸ, ֡פʤ, , C, B'˷뤳Ȥͥ */
		    if ((cp2 = check_feature(g_ptr->f, "")) != NULL) {
			sscanf(cp2, "%*[^:]:%d", &topic_score);
			one_score += topic_score;
		    }

		    /* ĤˤͿ (,̤)
		        ʣ꤬ƱҸ˷뤳Ȥɤ */
		    if (check_feature(d_ptr->f, "") ||
			check_feature(d_ptr->f, "")) {
			one_score += 10;
		    }
		    else if (ha_check == 0){
			one_score += 10;
			ha_check = 1;
		    }
		}

		k = case2num(cp + 3);

		/* ǰ̤ΰ */

		/* ̤ : ƤǶåȤĴ٤ (,̤) */
		if (!strcmp(cp, ":̤")) {
		    if (check_feature(d_ptr->f, "") ||
			check_feature(d_ptr->f, "")) {
			one_score += 10;
		    }
		    else {
			(*un_count)++;
		    }
		}

		/* γ : θʳʤ break 
		    γǤˤͿʤ
		    γʤФγʤϤʤ

		    θפȤΤȽΤȡ
		   ʸʤɤǤѸ:ưȤʤäƤ뤳Ȥ
		   Τǡθפǥå */
		else if (!strcmp(cp, ":γ")) {
		    if (!check_feature(g_ptr->f, "θ")) {
			/* one_score += 10;
			   break; */
			if (g_ptr->SCASE_code[case2num("")] &&
			    scase_check[case2num("")] == 0) {
			    one_score += 10;
			    scase_check[case2num("")] = 1;
			}
		    }
		} 

		/*  : ʸΤǾʣ */
		else if (!strcmp(cp, ":")) {
		    if (g_ptr->SCASE_code[case2num("")] &&
			scase_check[case2num("")] == 0) {
			one_score += 10;
			scase_check[case2num("")] = 1;
		    }
		    else if (g_ptr->SCASE_code[case2num("")] &&
			     scase_check[case2num("")] == 0) {
			one_score += 10;
			scase_check[case2num("")] = 1;
		    }
		}

		/* ¾γ : Ƴ1Ĥ򤢤
		    ˳ʤξ硤֤Ȥʳ϶̤⡩ */
		else if (k != -1) {
		    if (scase_check[k] == 0) {
			scase_check[k] = 1;
			one_score += 10;
		    } 
		}

		/* ֡Τϡפ˥ܡʥ 01/01/11
		   ۤȤɤξ

		   )
		   ֹĤΤ Ǥ ݤ ͳ Ĥ餷

		   ֻȤΤ  Ȥ
		   ֱ ʤ뤫ɤ ̯ Ȥ
		    ϡ֤/Ȥפ˷Ȱ

		   ¾ͤ Τ ˤʤ Ǥ
		    ۣʸ̮

		   )
		   ֤줬 ֣ͣФ ʬʤ Ǥ礦
		   ֡ ʤ  
		   ֥ӥ Τ Ѥ 塣
		   Ȥ ޤΤ 򤱤줽ˤʤ Ԥ
		   ֤ޤ ΩĤȤ פʤ 
		   ֤ɤ ޤ礦 뤵Ƥ ˡ
		   ǧ뤫ɤ 줿 Ƚǡ

		   ꢨ
		   ֤פ Τ褦ʾѸȤߤʤΤ
		*/

		if (check_feature(d_ptr->f, "Ѹ") &&
		    (check_feature(d_ptr->f, ":̤") ||
		     check_feature(d_ptr->f, ":")) &&
		    check_feature(g_ptr->f, "Ѹ:Ƚ")) {
		    one_score += 3;
		}
	    }

	    /* Ϣνξ硤褬
	       ̾,Ū̾
	       ͽ,ָߡפʤ
	       ǤʤаĤγǤȹͤ */
	    if (check_feature(d_ptr->f, ":Ϣ")) {
		if (check_feature(g_ptr->f, "δط") || 
		    check_feature(g_ptr->f, "롼볰δط")) {
		    one_score += 10;	/* δطʤ餳ǲ */
		}
		else {
		    /* ʳʤåȤå (ϢνդȤΥκʬ) */
		    one_score += check_scase(d_ptr, &(cky_ptr->left->scase_check[0]), 1, cky_ptr->left->un_count) - 
			check_scase(d_ptr, &(cky_ptr->left->scase_check[0]), 0, cky_ptr->left->un_count);
		}
	    }
	}

	cky_ptr = cky_ptr->direction == LtoR ? cky_ptr->right : cky_ptr->left;
    }

    /* Ѹξ硤ǽṲ̄,,,˳,ϢνФ
       ,,˳ʤΥåʬͿ */
    if (pred_p) {
	one_score += check_scase(g_ptr, scase_check, 0, *un_count);
    }

    if (OptDisplay == OPT_DEBUG) {
	printf("%.3f\n", one_score);
    }

    return one_score;
}

/* count dependency possibilities */
int count_distance(SENTENCE_DATA *sp, CKY *cky_ptr, BNST_DATA *g_ptr, int *pos) {
    int i, count = 0;
    *pos = 0;

    for (i = cky_ptr->left->b_ptr->num + 1; i < sp->Bnst_num; i++) {
	if (check_dpnd_possibility(sp, cky_ptr->left->b_ptr->num, i, cky_ptr->i, 
				   ((i == sp->Bnst_num - 1) && count == 0) ? TRUE : FALSE)) {
	    if (i == g_ptr->num) {
		*pos = count;
	    }
	    count++;
	}
    }

    return count;
}

/* scoring function based on case structure probabilities */
double calc_case_probability(SENTENCE_DATA *sp, CKY *cky_ptr, TOTAL_MGR *Best_mgr) {
    CKY *right_ptr = cky_ptr->right, *orig_cky_ptr = cky_ptr;
    BNST_DATA *g_ptr = cky_ptr->b_ptr, *d_ptr;
    TAG_DATA *t_ptr, *dt_ptr;
    CF_PRED_MGR *cpm_ptr, *pre_cpm_ptr;
    int i, pred_p = 0, child_num = 0, wo_ni_overwritten_flag = 0;
    int renyou_modifying_num = 0, adverb_modifying_num = 0, noun_modifying_num = 0, flag;
    double one_score = 0, orig_score;
    char *para_key;

    /* оݤѸʳΥ򽸤 (right򤿤ɤʤleftΥ­) */
    while (cky_ptr) {
	if (cky_ptr->left) {
	    one_score += cky_ptr->left->score;
	}
	cky_ptr = cky_ptr->right;
    }
    if (OptDisplay == OPT_DEBUG) {
	printf("%.3f=>", one_score);
    }

    cky_ptr = orig_cky_ptr;

    if (check_feature(g_ptr->f, "ñ̼:-1") && g_ptr->tag_num > 1) { /* Τ */
	t_ptr = g_ptr->tag_ptr + g_ptr->tag_num - 2;
    }
    else {
	t_ptr = g_ptr->tag_ptr + g_ptr->tag_num - 1;
    }

    if (t_ptr->cf_num > 0) { /* predicate or something which has case frames */
	cky_ptr->cpm_ptr->pred_b_ptr = t_ptr;
	set_data_cf_type(cky_ptr->cpm_ptr); /* set predicate type */
	if (cky_ptr->cpm_ptr->cf.type == CF_PRED && /* currently, restrict to predicates */
	    !(cky_ptr->i == cky_ptr->j && check_feature(g_ptr->f, "ID:ʡˡ"))) {
	    pred_p = 1;
	    cpm_ptr = cky_ptr->cpm_ptr;
	    cpm_ptr->score = -1;
	    cpm_ptr->result_num = 0;
	    cpm_ptr->tie_num = 0;
	    cpm_ptr->cmm[0].cf_ptr = NULL;
	    cpm_ptr->decided = CF_UNDECIDED;

	    cpm_ptr->cf.pred_b_ptr = t_ptr;
	    t_ptr->cpm_ptr = cpm_ptr;
	    cpm_ptr->cf.element_num = 0;
	}
	else {
	    cky_ptr->cpm_ptr->pred_b_ptr = NULL;
	    cky_ptr->cpm_ptr->cmm[0].cf_ptr = NULL;
	}
    }
    else {
	cky_ptr->cpm_ptr->pred_b_ptr = NULL;
	cky_ptr->cpm_ptr->cmm[0].cf_ptr = NULL;
    }

    /* check each child */
    while (cky_ptr) {
	if (cky_ptr->left && cky_ptr->para_flag == 0) {
	    d_ptr = cky_ptr->left->b_ptr;
	    dt_ptr = d_ptr->tag_ptr + d_ptr->tag_num - 1;
	    flag = 0;

	    /* left_ptr֡ʡˡˡפǡ1Ĥζ礫ʤȤϡ:˳ ѹ */
	    if (cky_ptr->left->i == cky_ptr->left->j && 
		check_feature(d_ptr->f, "ID:ʡˡ")) {
		assign_cfeature(&(d_ptr->f), ":˳", FALSE);
		assign_cfeature(&(dt_ptr->f), ":˳", FALSE);
		assign_cfeature(&(dt_ptr->f), "Բϳ-", FALSE);
		delete_cfeature(&(dt_ptr->f), "ѸƱʸ");
		wo_ni_overwritten_flag = 1;
	    }
	    else {
		wo_ni_overwritten_flag = 0;
	    }

	    /* relax penalty */
	    if (cky_ptr->dpnd_type == 'R') {
		one_score += -1000;
	    }

	    /* coordination */
	    if (OptParaFix == 0) {
		if (d_ptr->para_num != -1 && (para_key = check_feature(d_ptr->f, "¥"))) {
		    make_work_mgr_dpnd_check_for_noun(sp, d_ptr);
		    if (cky_ptr->dpnd_type == 'P') {
			one_score += get_para_exist_probability(para_key, cky_ptr->para_score, TRUE, d_ptr->tag_ptr + d_ptr->tag_num - 1, t_ptr);
			if ((OptParaNoFixFlag & OPT_PARA_MULTIPLY_ALL_EX) || check_feature(d_ptr->f, ":Ϣ")) {
			    one_score += get_para_ex_probability(para_key, cky_ptr->para_score, d_ptr->tag_ptr + d_ptr->tag_num - 1, t_ptr);
			}
			flag++;
		    }
		    else {
			one_score += get_para_exist_probability(para_key, sp->para_data[d_ptr->para_num].max_score, FALSE, d_ptr->tag_ptr + d_ptr->tag_num - 1, t_ptr);
		    }
		}
	    }

	    /* case component */
	    if (cky_ptr->dpnd_type != 'P' && pred_p) {
		make_work_mgr_dpnd_check(sp, cky_ptr, d_ptr);
		if (make_data_cframe_child(sp, cpm_ptr, d_ptr->tag_ptr + d_ptr->tag_num - 1, child_num, t_ptr->num == d_ptr->num + 1 ? TRUE : FALSE)) {
		    add_coordinated_phrases(cky_ptr->left, &(cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num - 1]->next));
		    child_num++;
		    flag++;
		}

		if ((check_feature(d_ptr->f, ":Ϣ") && 
		     (!check_feature(d_ptr->f, "Ѹ") || !check_feature(d_ptr->f, "ʣ缭"))) || 
		    check_feature(d_ptr->f, "")) {
		    flag++;
		}
	    }

	    /* clausal modifiee */
	    if ((check_feature(d_ptr->f, ":Ϣ") || check_feature(d_ptr->f, "Ĵʸ")) && 
		cky_ptr->left->cpm_ptr->pred_b_ptr) { /* ʥե졼äƤ٤ */
		pre_cpm_ptr = cky_ptr->left->cpm_ptr;
		pre_cpm_ptr->pred_b_ptr->cpm_ptr = pre_cpm_ptr;
		make_work_mgr_dpnd_check(sp, cky_ptr, d_ptr);
		make_data_cframe_rentai_simple(pre_cpm_ptr, pre_cpm_ptr->pred_b_ptr, t_ptr);
		add_coordinated_phrases(cky_ptr->right, &(pre_cpm_ptr->elem_b_ptr[pre_cpm_ptr->cf.element_num - 1]->next));

		orig_score = pre_cpm_ptr->score;
		one_score -= orig_score;
		one_score += find_best_cf(sp, pre_cpm_ptr, get_closest_case_component(sp, pre_cpm_ptr), 1);
		pre_cpm_ptr->score = orig_score;
		pre_cpm_ptr->cf.element_num--;
		flag++;
	    }

	    if (OptParaFix == 0 && flag == 0 && /* ̾ʥե졼 */
		check_feature(g_ptr->f, "θ") && /* ʣ缭ʤɤФ */
		check_feature(d_ptr->f, "θ")) {
		(d_ptr->tag_ptr + d_ptr->tag_num - 1)->next = NULL; /* ǳǼ(¦) */
		t_ptr->next = NULL; /* ǳǼ(¦) */
		add_coordinated_phrases(cky_ptr->left, &((d_ptr->tag_ptr + d_ptr->tag_num - 1)->next));
		add_coordinated_phrases(cky_ptr->right, &(t_ptr->next));
		make_work_mgr_dpnd_check(sp, cky_ptr, d_ptr);
		one_score += get_noun_co_ex_probability(d_ptr->tag_ptr + d_ptr->tag_num - 1, t_ptr);
		noun_modifying_num++;
	    }

	    /* :˳ʤѹΤ򸵤ˤɤ */
	    if (wo_ni_overwritten_flag) {
		assign_cfeature(&(d_ptr->f), ":Ϣ", FALSE);
		assign_cfeature(&(dt_ptr->f), ":Ϣ", FALSE);
		assign_cfeature(&(dt_ptr->f), "ѸƱʸ", FALSE);
		delete_cfeature(&(dt_ptr->f), "Բϳ-");
	    }
	}
	cky_ptr = cky_ptr->right;
    }

    if (pred_p) {
	t_ptr->cpm_ptr = cpm_ptr;

	/* Ѹʸ᤬֡ʡˡˡפΤȤ 
	   ֤פγʥե졼Фƥ˳(Ʊʸ)
	   ʤϻҶνǰ */
	if (check_feature(t_ptr->f, "ѸƱʸ")) {
	    if (_make_data_cframe_pp(cpm_ptr, t_ptr, TRUE)) {
		_make_data_cframe_sm(cpm_ptr, t_ptr);
		_make_data_cframe_ex(cpm_ptr, t_ptr);
		cpm_ptr->elem_b_ptr[cpm_ptr->cf.element_num] = t_ptr;
		cpm_ptr->elem_b_num[cpm_ptr->cf.element_num] = child_num;
		cpm_ptr->cf.weight[cpm_ptr->cf.element_num] = 0;
		cpm_ptr->cf.adjacent[cpm_ptr->cf.element_num] = TRUE;
		cpm_ptr->cf.element_num++;
	    }
	}

	/* call case structure analysis */
	one_score += find_best_cf(sp, cpm_ptr, get_closest_case_component(sp, cpm_ptr), 1);

	/* for each child */
	cky_ptr = orig_cky_ptr;
	while (cky_ptr) {
	    if (cky_ptr->left) {
		d_ptr = cky_ptr->left->b_ptr;
		if (cky_ptr->dpnd_type != 'P' && 
		    !(cky_ptr->left->i == cky_ptr->left->j && /* ֡ˡפǤʤΤǽ */
		      check_feature(d_ptr->f, "ID:ʡˡ"))) {
		    /* modifying predicate */
		    if (check_feature(d_ptr->f, ":Ϣ") && check_feature(d_ptr->f, "Ѹ") && 
			!check_feature(d_ptr->f, "ʣ缭")) {
			make_work_mgr_dpnd_check(sp, cky_ptr, d_ptr);
			one_score += calc_vp_modifying_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
								   d_ptr->tag_ptr + d_ptr->tag_num - 1, 
								   cky_ptr->left->cpm_ptr->cmm[0].cf_ptr);
			renyou_modifying_num++;
		    }
		    /* modifying adverb */
		    else if ((check_feature(d_ptr->f, ":Ϣ") && !check_feature(d_ptr->f, "Ѹ")) || 
			     check_feature(d_ptr->f, "")) {
			make_work_mgr_dpnd_check(sp, cky_ptr, d_ptr);
			one_score += calc_adv_modifying_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, 
								    d_ptr->tag_ptr + d_ptr->tag_num - 1);
			adverb_modifying_num++;
		    }
		}
	    }
	    cky_ptr = cky_ptr->right;
	}

	one_score += calc_vp_modifying_num_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, renyou_modifying_num);
	one_score += calc_adv_modifying_num_probability(t_ptr, cpm_ptr->cmm[0].cf_ptr, adverb_modifying_num);
    }

    /* ̾콤Ŀ */
    if (OptParaFix == 0 && !pred_p || check_feature(t_ptr->f, "Ѹ:Ƚ")) {
	one_score += get_noun_co_num_probability(t_ptr, noun_modifying_num);
    }

    if (OptDisplay == OPT_DEBUG) {
	printf("%.3f\n", one_score);
    }

    return one_score;
}

int relax_barrier_for_P(CKY *cky_ptr, int dep, int gov, int *dep_check) {
    while (cky_ptr) {
	if (cky_ptr->left && 
	    cky_ptr->dpnd_type == 'P') {
	    if (*(dep_check + dep) >= cky_ptr->left->j) { /* κ¦ɤʤ顢¦ޤOKȤ */
		return TRUE;
	    }
	    else if (cky_ptr->para_flag) {
		if (relax_barrier_for_P(cky_ptr->left, dep, gov, dep_check)) {
		    return TRUE;
		}
	    }
	}
	cky_ptr = cky_ptr->right; /* go below */
    }

    return FALSE;
}

int relax_dpnd_for_P(CKY *cky_ptr, int dep, int gov) {
    int i;

    while (cky_ptr) {
	if (cky_ptr->left && 
	    cky_ptr->dpnd_type == 'P') {
	    for (i = cky_ptr->left->i; i <= cky_ptr->left->j; i++) {
		if (Dpnd_matrix[dep][i] && Quote_matrix[dep][i]) {
		    return TRUE;
		}
	    }
	}
	cky_ptr = cky_ptr->right;
    }

    return FALSE;
}

void fix_predicate_coordination(SENTENCE_DATA* sp) {
    int i, j, k;

    for (i = 0; i < sp->Para_num; i++) {
	if (sp->para_data[i].type == PARA_KEY_P) { /* predicate coordination */
	    if (sp->para_data[i].status == 'x') {
		sp->para_data[i].max_score = -1;
	    }

	    /* modify Para_matrix */
	    for (j = 0; j < sp->Bnst_num; j++) {
		for (k = 0; k < sp->Bnst_num; k++) {
		    /* preserve the best coordination */
		    if (sp->para_data[i].status == 'x' || 
			j != sp->para_data[i].max_path[0] || k != sp->para_data[i].jend_pos) { 
			Para_matrix[i][j][k] = -1;
		    }
		}
	    }

	    /* modify Dpnd_matrix */
	    if (sp->para_data[i].status != 'x') {
		for (j = sp->para_data[i].key_pos + 1; j < sp->Bnst_num; j++) {
		    if (j == sp->para_data[i].jend_pos) {
			Dpnd_matrix[sp->para_data[i].key_pos][j] = 'R';
		    }
		    else {
			Dpnd_matrix[sp->para_data[i].key_pos][j] = 0;
		    }
		}
	    }
	}
    }
}


void restrict_parenthetic_coordination(SENTENCE_DATA* sp) {
    int i, j, count;

    for (i = 0; i < sp->Bnst_num - 1; i++) {
	if (check_feature((sp->bnst_data + i)->f, ":")) {
	    count = 0;
	    for (j = i + 1; j < sp->Bnst_num; j++) {
		if (Dpnd_matrix[i][j]) {
		    if (count > 0) {
			/* only permit the first head */
			Dpnd_matrix[i][j] = 0;
		    }
		    count++;
		}
	    }
	}
    }
}

void restrict_end_prefer_dependency(SENTENCE_DATA* sp) {
    int i, j, count;

    for (i = 0; i < sp->Bnst_num - 1; i++) {
	if ((sp->bnst_data + i)->dpnd_rule->preference == -1) {
	    count = 0;
	    for (j = sp->Bnst_num - 1; j > i; j--) {
		if (Dpnd_matrix[i][j]) {
		    if (count > 0) {
			/* only permit the last head */
			Dpnd_matrix[i][j] = 0;
		    }
		    count++;
		}
	    }
	}
    }
}

void discard_bad_coordination(SENTENCE_DATA* sp) {
    int i, j, k;

    for (i = 0; i < sp->Para_num; i++) {
	if (sp->para_data[i].status == 'x') {
	    for (j = 0; j < sp->Bnst_num; j++) {
		for (k = 0; k < sp->Bnst_num; k++) {
		    Para_matrix[i][j][k] = -1;
		}
	    }
	}
    }
}

void handle_incomplete_coordination(SENTENCE_DATA* sp) {
    int i, j;

    for (i = 0; i < sp->Bnst_num; i++) {
	for (j = 0; j < sp->Bnst_num; j++) {
	    if (Mask_matrix[i][j] == 3 && 
		Dpnd_matrix[i][j] == 0) {
		Dpnd_matrix[i][j] = (int)'I';
	    }
	}
    }
}

void extend_para_matrix(SENTENCE_DATA* sp) {
    int i, j, k, l, flag, offset, max_pos;
    double max_score;

    for (i = 0; i < sp->Para_num; i++) {
	if (sp->para_data[i].max_score >= 0) {
	    if (sp->para_data[i].type == PARA_KEY_P) {
		offset = 0;
	    }
	    else { /* in case of noun coordination, only permit modifiers to the words before the para key */
		offset = 1;
	    }

	    /* for each endpos */
	    for (l = sp->para_data[i].key_pos + 1; l < sp->Bnst_num; l++) {
		max_score = -INT_MAX;
		for (j = sp->para_data[i].iend_pos; j >= 0; j--) {
		    if (max_score < Para_matrix[i][j][l]) {
			max_score = Para_matrix[i][j][l];
			max_pos = j;
		    }
		}
		if (max_score >= 0) {
		    /* go up to search modifiers */
		    for (j = max_pos - 1; j >= 0; j--) {
			if (check_stop_extend(sp, j)) { /* extention stop */
			    break;
			}

			/* check dependency to pre-conjunct */
			flag = 0;
			for (k = j + 1; k <= sp->para_data[i].key_pos - offset; k++) {
			    if (Dpnd_matrix[j][k] && Quote_matrix[j][k]) {
				Para_matrix[i][j][l] = max_score;
				flag = 1;
				if (OptDisplay == OPT_DEBUG) {
				    printf("Para Extension (%s-%s-%s) -> %s\n", 
					   (sp->bnst_data + max_pos)->head_ptr->Goi, 
					   (sp->bnst_data + sp->para_data[i].key_pos)->head_ptr->Goi, 
					   (sp->bnst_data + l)->head_ptr->Goi, 
					   (sp->bnst_data + j)->head_ptr->Goi);
				}
				break;
			    }
			}
			if (flag == 0) {
			    break;
			}
		    }
		}
	    }
	}
    }
}

void set_cky(SENTENCE_DATA *sp, CKY *cky_ptr, CKY *left_ptr, CKY *right_ptr, int i, int j, int k, 
	     char dpnd_type, int direction, int index) {
    int l;

    cky_ptr->index = index;
    cky_ptr->i = i;
    cky_ptr->j = j;
    cky_ptr->next = NULL;
    cky_ptr->left = left_ptr;
    cky_ptr->right = right_ptr;
    cky_ptr->direction = direction;
    cky_ptr->dpnd_type = dpnd_type;
    cky_ptr->cp = 'a' + j;
    if (cky_ptr->direction == RtoL) {
	cky_ptr->b_ptr = cky_ptr->left->b_ptr;
    }
    else {
	cky_ptr->b_ptr = cky_ptr->right ? cky_ptr->right->b_ptr : sp->bnst_data + j;
    }
    cky_ptr->un_count = 0;
    for (l = 0; l < SCASE_CODE_SIZE; l++) cky_ptr->scase_check[l] = 0;
    cky_ptr->para_flag = 0;
    cky_ptr->para_score = -1;
    cky_ptr->chicase_score = -1;
    cky_ptr->chicase_lex_score = -1;
    cky_ptr->score = 0;
}

CKY *new_cky_data(int *cky_table_num) {
    CKY *cky_ptr;

    cky_ptr = &(cky_table[*cky_table_num]);
    if (OptAnalysis == OPT_CASE && *cky_table_num > cpm_allocated_cky_num) {
	cky_ptr->cpm_ptr = (CF_PRED_MGR *)malloc_data(sizeof(CF_PRED_MGR), "new_cky_data");
	init_case_frame(&(cky_ptr->cpm_ptr->cf));
	cky_ptr->cpm_ptr->cf.type = 0;
	cpm_allocated_cky_num = *cky_table_num;
    }

    (*cky_table_num)++;
    if (*cky_table_num >= CKY_TABLE_MAX) {
	fprintf(stderr, ";;; cky_table_num exceeded maximum\n");
	return NULL;
    }

    return cky_ptr;
}

void copy_cky_data(CKY *dest, CKY *src) {
    int l;

    if (dest == src) {
	return;
    }

    dest->index = src->index;
    dest->i = src->i;
    dest->j = src->j;
    dest->next = src->next;
    dest->left = src->left;
    dest->right = src->right;
    dest->direction = src->direction;
    dest->dpnd_type = src->dpnd_type;
    dest->cp = src->cp;
    dest->direction = src->direction;
    dest->b_ptr = src->b_ptr;
    dest->un_count = src->un_count;
    for (l = 0; l < SCASE_CODE_SIZE; l++) dest->scase_check[l] = src->scase_check[l];
    dest->para_flag = src->para_flag;
    dest->para_score = src->para_score;
    dest->score = src->score;
    dest->cpm_ptr = src->cpm_ptr;
}

int after_cky(SENTENCE_DATA *sp, TOTAL_MGR *Best_mgr, CKY *cky_ptr, int return_flag) {
    int i, j;
    CKY *tmp_cky_ptr;
    CKY *node_stack[BNST_MAX];
    int tail_index;

    if (return_flag == FALSE) { /* parse failed */
	if (OptNbest == TRUE) { /* print for nbest */
	    sp->available = 0;
	    ErrorComment = strdup("Cannot detect dependency structure");
	    when_no_dpnd_struct(sp);
	    dpnd_info_to_bnst(sp, &(Best_mgr->dpnd));
	    if (!(OptExpress & OPT_NOTAG)) {
		dpnd_info_to_tag(sp, &(Best_mgr->dpnd)); 
		if (OptExpress & OPT_MRPH) {
		    dpnd_info_to_mrph(sp);
		}
	    }
	    print_result(sp, 0);
	}
	return return_flag;
    }

    /* count the number of predicates */
    Best_mgr->pred_num = 0;
    for (i = 0; i < sp->Tag_num; i++) {
	if ((sp->tag_data + i)->cf_num > 0 && 
	    (sp->tag_data + i)->cpm_ptr && (sp->tag_data + i)->cpm_ptr->cf.type == CF_PRED && 
	    (((sp->tag_data + i)->inum == 0 && /* the last basic phrase in a bunsetsu */
	      !check_feature((sp->tag_data + i)->b_ptr->f, "ñ̼:-1")) || 
	     ((sp->tag_data + i)->inum == 1 && 
	      check_feature((sp->tag_data + i)->b_ptr->f, "ñ̼:-1")))) { 
	    (sp->tag_data + i)->pred_num = Best_mgr->pred_num;
	    Best_mgr->pred_num++;
	}
    }

    /* for all possible structures */
    while (cky_ptr) {
	for (i = 0; i < Best_mgr->pred_num; i++) {
	    Best_mgr->cpm[i].pred_b_ptr = NULL;
	}

	if (OptDisplay == OPT_DEBUG) {
	    printf("---------------------\n");
	    printf("score=%.3f\n", cky_ptr->score);
	}

	Best_mgr->dpnd.head[cky_ptr->b_ptr->num] = -1;
	Best_mgr->score = cky_ptr->score;
	sp->score = Best_mgr->score;
	convert_to_dpnd(sp, Best_mgr, cky_ptr);

	/* ̵ʽ°: ʸη˽ */
	for (i = 0; i < sp->Bnst_num - 1; i++) {
	    if (Best_mgr->dpnd.head[i] < 0) {
		/* ꤨʤ */
		if (i >= Best_mgr->dpnd.head[i + Best_mgr->dpnd.head[i]]) {
		    if (Language != CHINESE) {
			Best_mgr->dpnd.head[i] = sp->Bnst_num - 1; /* ʸ˴ */
		    }
		    continue;
		}
		Best_mgr->dpnd.head[i] = Best_mgr->dpnd.head[i + Best_mgr->dpnd.head[i]];
		/* Best_mgr->dpnd.check[i].pos[0] = Best_mgr->dpnd.head[i]; */
	    }
	}

	/* ʲϷ̤ξfeature */
	if (OptAnalysis == OPT_CASE) {
	    /* ʲϷ̤Ѹܶfeature */
	    for (i = 0; i < sp->Best_mgr->pred_num; i++) {
		if (Best_mgr->cpm[i].pred_b_ptr == NULL) { /* ҸǤϤʤȽǤΤϥå */
		    continue;
		}
		assign_nil_assigned_components(sp, &(sp->Best_mgr->cpm[i])); /* ̤бǤν */

		assign_case_component_feature(sp, &(sp->Best_mgr->cpm[i]), FALSE);

		/* ʥե졼ΰ̣Ѹܶfeature */
		for (j = 0; j < sp->Best_mgr->cpm[i].cmm[0].cf_ptr->element_num; j++) {
		    append_cf_feature(&(sp->Best_mgr->cpm[i].pred_b_ptr->f), 
				      &(sp->Best_mgr->cpm[i]), sp->Best_mgr->cpm[i].cmm[0].cf_ptr, j);
		}
	    }
	}

	/* to tree structure */
	dpnd_info_to_bnst(sp, &(Best_mgr->dpnd));
	para_recovery(sp);
	if (!(OptExpress & OPT_NOTAG)) {
	    dpnd_info_to_tag(sp, &(Best_mgr->dpnd));
	    if (OptExpress & OPT_MRPH) {
		dpnd_info_to_mrph(sp);
	    }
	}
	if (make_dpnd_tree(sp)) {
	    bnst_to_tag_tree(sp); /* ñ̤ڤ */

	    /* disambiguation by case analysis */
	    if (OptAnalysis == OPT_CASE) {
		for (i = 0; i < Best_mgr->pred_num; i++) {
		    if (Best_mgr->cpm[i].pred_b_ptr == NULL) { /* ҸǤϤʤȽǤΤϥå */
			continue;
		    }
		    if (Best_mgr->cpm[i].result_num != 0 && 
			Best_mgr->cpm[i].cmm[0].cf_ptr->cf_address != -1 && 
			Best_mgr->cpm[i].cmm[0].score != CASE_MATCH_FAILURE_PROB) {
			/* ʲϤη̤ѤƷۣ */
			verb_lexical_disambiguation_by_case_analysis(&(sp->Best_mgr->cpm[i]));
			noun_lexical_disambiguation_by_case_analysis(&(sp->Best_mgr->cpm[i]));
		    }
		}
	    }

	    /* print for debug or nbest */
	    if (OptNbest == TRUE) {
		/* ¤Υ롼Ŭ */
		assign_general_feature(sp->bnst_data, sp->Bnst_num, AfterDpndBnstRuleType, FALSE, TRUE);
		assign_general_feature(sp->tag_data, sp->Tag_num, AfterDpndTagRuleType, FALSE, TRUE);

		if (OptAnalysis == OPT_CASE) { /* preserve case analysis result for n-best */
		    record_all_case_analisys(sp, TRUE);
		}
		print_result(sp, 0);

		if (OptAnalysis == OPT_CASE && OptDisplay == OPT_DEBUG) { /* case analysis results */
		    for (i = 0; i < Best_mgr->pred_num; i++) {
			if (Best_mgr->cpm[i].pred_b_ptr == NULL) { /* ҸǤϤʤȽǤΤϥå */
			    continue;
			}
			print_data_cframe(&(Best_mgr->cpm[i]), &(Best_mgr->cpm[i].cmm[0]));
			for (j = 0; j < Best_mgr->cpm[i].result_num; j++) {
			    print_crrspnd(&(Best_mgr->cpm[i]), &(Best_mgr->cpm[i].cmm[j]));
			}
		    }
		}

		/* Ϳfeature */
		for (i = 0; i < sp->Tag_num; i++) {
		    delete_temp_feature(&(sp->tag_data[i].f));
		}
	    }
	    else if (OptDisplay == OPT_DEBUG) {
		print_kakari(sp, OptExpress & OPT_NOTAG ? OPT_BNSTTREE : OPT_TREE);
	    }
	}

	cky_ptr = cky_ptr->next;
    }

    return return_flag;
}

void sort_cky_ptrs(CKY **orig_cky_ptr_ptr, int beam) {
    CKY *cky_ptr = *orig_cky_ptr_ptr, **start_cky_ptr_ptr = orig_cky_ptr_ptr, *pre_ptr, *best_ptr, *best_pre_ptr;
    double best_score;
    int i;

    for (i = 0; i < beam && cky_ptr; i++) {
	best_score = -INT_MAX;
	best_pre_ptr = NULL;
	pre_ptr = NULL;

	while (cky_ptr) {
	    if (cky_ptr->score > best_score) {
		best_score = cky_ptr->score;
		best_ptr = cky_ptr;
		best_pre_ptr = pre_ptr;
	    }
	    pre_ptr = cky_ptr;
	    cky_ptr = cky_ptr->next;
	}

	if (best_pre_ptr) { /* best_ptr is not at the beginning */
	    best_pre_ptr->next = best_ptr->next;
	    best_ptr->next = *start_cky_ptr_ptr;
	    *start_cky_ptr_ptr = best_ptr;
	}

	start_cky_ptr_ptr = &(best_ptr->next);
	cky_ptr = best_ptr->next;
    }

//  best_ptr->next = NULL; /* do not consider more candidates than beam */
}

int cky (SENTENCE_DATA *sp, TOTAL_MGR *Best_mgr) {
    int i, j, k, l, m, sort_flag, sen_len, cky_table_num, pre_cky_table_num, dep_check[BNST_MAX];
    double best_score, para_score;
    char dpnd_type;
    CKY *cky_ptr, *left_ptr, *right_ptr, *best_ptr, *pre_ptr, *best_pre_ptr, *start_ptr, *sort_pre_ptr, *tmp_ptr;
    CKY **next_pp, **next_pp_for_ij;

    cky_table_num = 0;

    /* initialize */
    for (i = 0; i < sp->Bnst_num; i++) {
	dep_check[i] = -1;
	Best_mgr->dpnd.head[i] = -1;
	Best_mgr->dpnd.type[i] = 'D';
    }

    /* set barrier for parenthetic coordinations */
    restrict_parenthetic_coordination(sp);

    /* restrict the possible heads of end-prefer dependents */
    restrict_end_prefer_dependency(sp);

    if (OptParaFix == 0) {
	discard_bad_coordination(sp);
	/* fix_predicate_coordination(sp); */
	/* extend_para_matrix(sp); */
	handle_incomplete_coordination(sp);
    }

    /* 롼פϺ鱦,
       ijޤǤǤޤȤ */
    for (j = 0; j < sp->Bnst_num; j++) { /* left to right (鱦) */
	for (i = j; i >= 0; i--) { /* bottom to top () */
	    if (OptDisplay == OPT_DEBUG) {
		printf("(%d,%d)\n", i, j);
	    }

	    cky_matrix[i][j] = NULL;
	    if (i == j) {
		if ((cky_ptr = new_cky_data(&cky_table_num)) == NULL) {
		    return FALSE;
		}
		cky_matrix[i][j] = cky_ptr;

		set_cky(sp, cky_ptr, NULL, NULL, i, j, -1, 0, LtoR, -1);
		cky_ptr->score = OptAnalysis == OPT_CASE ? 
		    calc_case_probability(sp, cky_ptr, Best_mgr) : calc_score(sp, cky_ptr);
	    }
	    else {
		next_pp_for_ij = NULL;	/* ΰ֤˰Ĥ礬ǤƤʤ */
		pre_cky_table_num = cky_table_num;

		/* merge (i .. i+k) and (i+k+1 .. j) */
		for (k = 0; k < j - i; k++) {
		    para_score = (sp->bnst_data + i + k)->para_num == -1 ? -1 : 
			Para_matrix[(sp->bnst_data + i + k)->para_num][i][j];
		    next_pp = NULL;
		    left_ptr = cky_matrix[i][i + k];
		    while (left_ptr) {
			right_ptr = cky_matrix[i + k + 1][j];
			while (right_ptr) {
			    /* make a phrase if condition is satisfied */
			    if ((dpnd_type = check_dpnd_possibility(sp, left_ptr->b_ptr->num, right_ptr->b_ptr->num, i, 
								    (j == sp->Bnst_num - 1) && dep_check[i + k] == -1 ? TRUE : FALSE)) && 
				(dpnd_type == 'P' || 
				 dep_check[i + k] <= 0 || /* no barrier */
				 dep_check[i + k] >= j || /* before barrier */
				 (OptParaFix == 0 && relax_barrier_for_P(right_ptr, i + k, j, dep_check)))) { /* barrier relaxation for P */
				if ((cky_ptr = new_cky_data(&cky_table_num)) == NULL) {
				    return FALSE;
				}
				if (next_pp == NULL) {
				    start_ptr = cky_ptr;
				}
				else {
				    *next_pp = cky_ptr;
				}
				    
				set_cky(sp, cky_ptr, left_ptr, right_ptr, i, j, k, dpnd_type, 
					Dpnd_matrix[left_ptr->b_ptr->num][right_ptr->b_ptr->num] == 'L' ? RtoL : LtoR, -1);
				    
				next_pp = &(cky_ptr->next);
					
				if (OptDisplay == OPT_DEBUG) {
				    printf("   (%d,%d), (%d,%d) b=%d [%s%s%s], %c(para=%.3f), score=", 
					   i, i + k, i + k + 1, j, dep_check[i + k], 
					   left_ptr->b_ptr->head_ptr->Goi, 
					   cky_ptr->direction == RtoL ? "<-" : "->", 
					   right_ptr->b_ptr->head_ptr->Goi, 
					   dpnd_type, para_score);
				}
				    
				cky_ptr->para_score = para_score;
				cky_ptr->score = OptAnalysis == OPT_CASE ? 
				    calc_case_probability(sp, cky_ptr, Best_mgr) : calc_score(sp, cky_ptr);
			    }

			    if (Language != CHINESE && 
				OptNbest == FALSE && 
				OptParaFix && 
				!check_feature(right_ptr->b_ptr->f, "Ѹ")) { /* consider only the best one if noun */
				break;
			    }
			    right_ptr = right_ptr->next;
			}

			if (Language != CHINESE && 
			    OptNbest == FALSE && 
			    OptParaFix && /* ۣ硢̾줬󤫤ɤǡ̾ʿѤȤսǥѲ */
			    (!check_feature(left_ptr->b_ptr->f, "Ѹ") || /* consider only the best one if noun or VP */
			     check_feature(left_ptr->b_ptr->f, ":Ϣ"))) {
			    break;
			}
			left_ptr = left_ptr->next;
		    }

		    if (next_pp) {
			/* ̾ξϤ1Ĥ˹ʤäƤ褤 */

			if (next_pp_for_ij == NULL) {
			    cky_matrix[i][j] = start_ptr;
			}
			else {
			    *next_pp_for_ij = start_ptr;
			}
			next_pp_for_ij = next_pp;

			/* barrier handling */
			if (j != sp->Bnst_num - 1) { /* don't check in case of relaxation */
			    if ((OptParaFix || Dpnd_matrix[i + k][j]) &&  /* don't set barrier in case of P */
				(sp->bnst_data + i + k)->dpnd_rule->barrier.fp[0] && 
				feature_pattern_match(&((sp->bnst_data + i + k)->dpnd_rule->barrier), 
						      (sp->bnst_data + j)->f, 
						      sp->bnst_data + i + k, sp->bnst_data + j) == TRUE) {
				dep_check[i + k] = j; /* set barrier */
			    }
			    else if (dep_check[i + k] == -1) {
				if (Language != CHINESE && 
				    (OptParaFix || Dpnd_matrix[i + k][j]) && /* don't set barrier in case of P */
				    (sp->bnst_data + i + k)->dpnd_rule->preference != -1 && 
				    (sp->bnst_data + i + k)->dpnd_rule->barrier.fp[0] == NULL) { /* no condition */
				    dep_check[i + k] = j; /* set barrier */
				}
				else {
				    dep_check[i + k] = 0; /* ʤȤ1ĤΩȤ򼨤 */
				}
			    }
			}
		    }
		}

		/* coordination that consists of more than 2 phrases */
		if (OptParaFix == 0) {
		    next_pp = NULL;
		    for (k = 0; k < j - i - 1; k++) {
			right_ptr = cky_matrix[i + k + 1][j];
			while (right_ptr) {
			    left_ptr = right_ptr;
			    while (left_ptr && (left_ptr->dpnd_type == 'P' || left_ptr->para_flag)) {
				left_ptr = left_ptr->left;
			    }
			    if (left_ptr && left_ptr != right_ptr) {
				left_ptr = cky_matrix[i][left_ptr->j]; /* (i)ˤ */
				while (left_ptr) {
				    if (left_ptr->dpnd_type == 'P') {
					if ((cky_ptr = new_cky_data(&cky_table_num)) == NULL) {
					    return FALSE;
					}
					if (next_pp == NULL) {
					    start_ptr = cky_ptr;
					}
					else {
					    *next_pp = cky_ptr;
					}

					set_cky(sp, cky_ptr, left_ptr, right_ptr, i, j, k, 'P', LtoR, -1);
					next_pp = &(cky_ptr->next);

					if (OptDisplay == OPT_DEBUG) {
					    printf("** (%d,%d), (%d,%d) b=%d [%s--%s], P(para=--), score=", 
						   i, left_ptr->j, i + k + 1, j, dep_check[i], 
						   (sp->bnst_data + i)->head_ptr->Goi, 
						   (sp->bnst_data + left_ptr->j)->head_ptr->Goi);
					}

					cky_ptr->para_flag = 1;
					cky_ptr->para_score = cky_ptr->left->para_score + cky_ptr->right->para_score;
					cky_ptr->score = OptAnalysis == OPT_CASE ? 
					    calc_case_probability(sp, cky_ptr, Best_mgr) : calc_score(sp, cky_ptr);
				    }
				    left_ptr = left_ptr->next;
				}
			    }
			    right_ptr = right_ptr->next;
			}
			/* if (next_pp) break; */
		    }

		    if (next_pp) {
			if (next_pp_for_ij == NULL) {
			    cky_matrix[i][j] = start_ptr;
			}
			else {
			    *next_pp_for_ij = start_ptr;
			}
			next_pp_for_ij = next_pp;
		    }
		}

		if (next_pp_for_ij) {
		    /* leave the best candidates within the beam */
		    if (OptBeam) {
			sort_cky_ptrs(&(cky_matrix[i][j]), OptBeam);
			next_pp = &(cky_matrix[i][j]);
			for (l = 0; l < OptBeam && *next_pp; l++) {
			    /* swap_cky_data(&(cky_table[pre_cky_table_num + l]), *next_pp); */
			    /* *next_pp = &(cky_table[pre_cky_table_num + l]); */
			    next_pp = &((*next_pp)->next);
			}
			/* cky_table_num = pre_cky_table_num + l; */
			*next_pp = NULL;
		    }
		    /* move the best one to the beginning of the list for the next step */
		    else {
			sort_cky_ptrs(&(cky_matrix[i][j]), 1);
		    }
		}
	    }
	}
    }

    if (OptDisplay == OPT_DEBUG) {
	printf(">>> n=%d\n", cky_table_num);
    }

    /* choose the best one */
    if (!cky_matrix[0][sp->Bnst_num - 1]) { /* parse failed */
	return after_cky(sp, Best_mgr, NULL, FALSE);
    }
    cky_ptr = cky_matrix[0][sp->Bnst_num - 1];

    /* the generative probability of the last predicate from EOS */
    if (OptCaseFlag & OPT_CASE_GENERATE_EOS) {
	while (cky_ptr) {
	    cky_ptr->score += calc_vp_modifying_probability(NULL, NULL, 
							    cky_ptr->b_ptr->tag_ptr + cky_ptr->b_ptr->tag_num - 1, 
							    cky_ptr->cpm_ptr->cmm[0].cf_ptr);
	    cky_ptr = cky_ptr->next;
	}
	cky_ptr = cky_matrix[0][sp->Bnst_num - 1];
    }

    if (cky_ptr->next) { /* if there are more than one possibility */
	best_score = -INT_MAX;
	pre_ptr = NULL;
	while (cky_ptr) {
	    if (cky_ptr->score > best_score) {
		best_score = cky_ptr->score;
		best_ptr = cky_ptr;
		best_pre_ptr = pre_ptr;
	    }
	    pre_ptr = cky_ptr;
	    cky_ptr = cky_ptr->next;
	}
	if (pre_ptr != best_ptr) {
	    if (best_pre_ptr) {
		best_pre_ptr->next = best_ptr->next;
	    }
	    else {
		cky_matrix[0][sp->Bnst_num - 1] = cky_matrix[0][sp->Bnst_num - 1]->next;
	    }
	    pre_ptr->next = best_ptr; /* move the best one to the end of the list */
	    best_ptr->next = NULL;
	}

	if (OptNbest == TRUE) {
	    cky_ptr = cky_matrix[0][sp->Bnst_num - 1]; /* when print all possible structures */
	}
	else {
	    cky_ptr = best_ptr;
	}
    }

    return after_cky(sp, Best_mgr, cky_ptr, TRUE);
}

/* check if there exists special word in one region */
int exist_chi(SENTENCE_DATA *sp, int i, int j, char *type) {
    int k;

    if (!strcmp(type, "noun")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "PU") && 
		(!strcmp((sp->bnst_data+k)->head_ptr->Goi, ",") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, "") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, ":") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, "") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, ""))) {
		break;
	    }
	    if (check_feature((sp->bnst_data + k)->f, "NN") ||
		check_feature((sp->bnst_data + k)->f, "NT") ||
		check_feature((sp->bnst_data + k)->f, "NR")){
		return k;
	    }
	}
    }
    else if (!strcmp(type, "DEC")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "DEC")) {
		return k;
	    }
	}
    }
    else if (!strcmp(type, "CC")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "CC")) {
		return k;
	    }
	}
    }
    else if (!strcmp(type, "pu")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "PU") && 
		(!strcmp((sp->bnst_data+k)->head_ptr->Goi, ",") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, "") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, ":") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, "") ||
		 !strcmp((sp->bnst_data+k)->head_ptr->Goi, ""))) {
		return k;
	    }
	}
    }
    else if (!strcmp(type, "dunhao")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "PU") && 
		!strcmp((sp->bnst_data+k)->head_ptr->Goi, "")) {
		return k;
	    }
	}
    }
    else if (!strcmp(type, "verb")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "VV") ||
		check_feature((sp->bnst_data + k)->f, "VA")) {
		return k;
	    }
	}
    }
    else if (!strcmp(type, "prep")) {
	for (k = i; k <= j; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "P")) {
		return k;
	    }
	}
    }
    
    return -1;
}

/* check the number of special pos-tag in a sentence */
int check_pos_num_chi(SENTENCE_DATA *sp, char *type) {
    int k;
    int num = 0;

    if (!strcmp(type, "verb")) {
	for (k = 0; k < sp->Bnst_num; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "VV") ||
		check_feature((sp->bnst_data + k)->f, "VA") ||
		check_feature((sp->bnst_data + k)->f, "VC") ||
		check_feature((sp->bnst_data + k)->f, "VE")) {
		num++;
	    }
	}
    }
    else if (!strcmp(type, "DEC")) {
	for (k = 0; k < sp->Bnst_num; k++) {
	    if (check_feature((sp->bnst_data + k)->f, "DEC")) {
		num++;
	    }
	}
    }

    return num;
}

/* check if this node has special child, direction = 0 means check in the left side, direction = 1 means check in the right side */
int has_child_chi(SENTENCE_DATA *sp, CKY *cky_ptr, char *pos, int direction) {
    CKY *ptr = cky_ptr;
    if (ptr->direction == LtoR) {
	if (direction == 0) {
	    if (ptr->left && check_feature((sp->bnst_data + ptr->left->b_ptr->num)->f, pos)) {
		return 1;
	    }
	    if (ptr->right) {
		ptr = ptr->right;
		while (ptr) {
		    if (ptr->direction == LtoR) {
			if (ptr->left && check_feature((sp->bnst_data + ptr->left->b_ptr->num)->f, pos)) {
			    return 1;
			}
			else {
			    ptr = ptr->right;
			}
		    }
		    else {
			ptr = ptr->left;
		    }
		}
	    }
	}
	else {
	    if (ptr->right) {
		ptr = ptr->right;
		while (ptr) {
		    if (ptr->direction == RtoL) {
			if (ptr->right && check_feature((sp->bnst_data + ptr->right->b_ptr->num)->f, pos)) {
			    return 1;
			}
			else {
			    ptr = ptr->left;
			}
		    }
		    else {
			ptr = ptr->right;
		    }
		}
	    }
	}
    }
    else {
	if (direction == 1) {
	    if (ptr->right && check_feature((sp->bnst_data + ptr->right->b_ptr->num)->f, pos)) {
		return 1;
	    }
	    if (ptr->left) {
		ptr = ptr->left;
		while (ptr) {
		    if (ptr->direction == RtoL) {
			if (ptr->right && check_feature((sp->bnst_data + ptr->right->b_ptr->num)->f, pos)) {
			    return 1;
			}
			else {
			    ptr = ptr->left;
			}
		    }
		    else {
			ptr = ptr->right;
		    }
		}
	    }
	}
	else {
	    if (ptr->left) {
		ptr = ptr->left;
		while (ptr) {
		    if (ptr->direction == LtoR) {
			if (ptr->left && check_feature((sp->bnst_data + ptr->left->b_ptr->num)->f, pos)) {
			    return 1;
			}
			else {
			    ptr = ptr->right;
			}
		    }
		    else {
			ptr = ptr->left;
		    }
		}
	    }
	}
    }	
    return 0;
}
