# $Id: Obsolete.pm,v 1.2 2006/10/31 08:53:08 shibata Exp $
package KNP::Obsolete;
require 5.003_09; # For UNIVERSAL->can().
use Carp;
use English qw/ $LIST_SEPARATOR /;
use strict;

=head1 NAME

KNP::Obsolete - ߴΥ᥽åɤ

=head1 SYNOPSIS

Υ饹ߥ󥰤ƻѤ롥

=head1 DESCRIPTION

C<KNP::Obsolete> 饹ϡC<KNP> ⥸塼˰(2001ǯ828)
Ʊ API ɲä륯饹Ǥ롥

=head1 CONSTRUCTOR

Υ饹ϥߥ󥰤ƻѤ褦߷פƤ뤿ᡤ̤ʥ
ȥ饯Ƥʤ

=head1 METHODS

=over 4

=item all()

KNP ϤʸϷ̤Τޤޤʸ֤᥽åɡ

=cut
sub all {
    shift->{ALL};
}

=item comment()

KNP ϤʸϷ̤Ƭ˴ޤޤ륳Ȥ֤᥽åɡ

=cut
sub comment {
    shift->{COMMENT};
}

=item mrph_num()

ǿ֤᥽åɡ

=cut
sub mrph_num {
    scalar( @{shift->{MRPH}} );
}

=item mrph( [ARG,TYPE,SUFFIX] )

ʸϷ̤ηǾ˥뤿Υ᥽åɡ

Examples:

   $knp->mrph;
   # ά줿ϡǾΥꥹȤ
   # ե󥹤֤

   $knp->mrph( 1 );
   # ARG ˤäơܤηǤξ֤
   # ꤹ롣ξϡ1ܤηǾΥϥå
   # Фե󥹤֤

   $knp->mrph( 2, 'fstring' );
   # TYPE ˤäɬפʷǾꤹ롣ξ
   # 硢2ܤηǤƤ feature ʸ
   # 

   $knp->mrph( 3, 'feature', 4 );
   # 3ܤηǤ4ܤ feature ֤

TYPE Ȥƻꤹ뤳ȤǤʸϼ̤Ǥ롣

   midasi
   yomi
   genkei
   hinsi
   hinsi_id
   bunrui
   bunrui_id
   katuyou1
   katuyou1_id
   katuyou2
   katuyou2_id
   imis
   fstring
   feature

3 SUFFIX 뤳ȤǤΤ TYPE Ȥ feature ꤷ
˸¤롣

=cut
sub mrph {
    my $this = shift;
    unless( @_ ){
	$this->{MRPH};
    }
    else {
	my $i = shift;
	unless( my $mrph = $this->{MRPH}->[$i] ){
	    carp "Suffix ($i) is out of range";
	    undef;
	}
	else {
	    unless( @_ ){
		$mrph;
	    }
	    else {
		my $type = shift;
		if( @_ == 1 and $type eq "feature" ){
		    ( $mrph->feature )[ shift ];
		}
		elsif( @_ ){
		    local $LIST_SEPARATOR = ", ";
		    carp "Too many arguments ($i, $type, @_)";
		    undef;
		}
		elsif( $mrph->can($type) ){
		    $mrph->$type();
		}
		else {
		    carp "Unknown type ($type)";
		    undef;
		}
	    }
	}
    }
}

=item bnst_num()

ʸ֤᥽åɡ

=cut
sub bnst_num {
    scalar( @{shift->{BNST}} );
}

=item bnst( [ARG,TYPE,SUFFIX] )

ʸϷ̤ʸ˴ؤФ᥽åɡ

Examples:

   $knp->bnst;
   # ά줿ϡʸΥꥹȤФ
   # ե󥹤֤

   $knp->bnst( 1 );
   # ARG ˤäơܤʸξ֤
   # 롣ξϡ1ܤʸΥϥå
   # ե󥹤֤

   $knp->bnst( 2, 'fstring' );
   # TYPE ˤäɬפʸꤹ롣ξ硢
   # 2ܤʸƤ feature ʸ֤

   $knp->bnst( 3, 'feature', 4 );
   # 3ܤʸ4ܤ feature ֤

TYPE Ȥƻꤹ뤳ȤǤʸϼ̤Ǥ롣

   start
   end
   parent
   parent_id
   dpndtype
   child
   child_id
   fstring
   feature

3 SUFFIX 뤳ȤǤΤ TYPE Ȥ feature ꤷ
˸¤롣

=cut
sub bnst {
    my $this = shift;
    unless( @_ ){
	$this->{BNST};
    } else {
	my $i = shift;
	unless( my $bnst = $this->{BNST}->[$i] ){
	    carp "Suffix ($i) is out of range";
	    undef;
	}
	else {
	    unless( @_ ){
		$bnst;
	    }
	    else {
		my $type = shift;
		if( @_ == 1 and $type eq "feature" ){
		    ( $bnst->feature )[ shift ];
		}
		elsif( @_ ){
		    local $LIST_SEPARATOR = ", ";
		    carp "Too many arguments ($i, $type, @_)";
		    undef;
		}
		elsif( $bnst->can($type) ){
		    $bnst->$type();
		}
		elsif ( $type eq 'start' ) {
		    ( $bnst->mrph )[0]->id;
		}
		elsif ( $type eq 'end' ) {
		    ( $bnst->mrph )[-1]->id;
		}
		elsif ( $type eq 'parent_id' ) {
		    if ( my $parent = $bnst->parent ) {
			$parent->id;
		    } else {
			-1;
		    }
		}
		elsif ( $type eq 'child_id' ) {
		    map( $_->id, $bnst->child );
		}
		else {
		    carp "Unknown method ($type)";
		    undef;
		}
	    }
	}
    }
}

sub draw_tree {
    my $blist = KNP::BList->new( @{shift->{BNST}} );
    $blist->set_nodestroy();
    $blist->draw_tree( @_ );
}

=back

=head1 SEE ALSO

=over 4

=item *

L<KNP>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
