# $Id: Bunsetsu.pm,v 1.2 2006/10/31 08:53:08 shibata Exp $
package KNP::Bunsetsu;
require 5.004_04; # For base pragma.
use Carp;
use KNP::Morpheme;
use strict;
use base qw/ KNP::Depend KNP::Fstring KNP::TList KNP::KULM::Bunsetsu Juman::MList /;

=head1 NAME

KNP::Bunsetsu - ʸᥪ֥ in KNP

=head1 SYNOPSIS

  $b = new KNP::Bunsetsu( "* -1D <BGH:>" );

=head1 DESCRIPTION

KNP ˤ뷸Ϥñ̤ǤʸγƼݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( SPEC, ID )

1 C<SPEC>  KNP νϤƸƤӽФȡιԤƤ
ʸᥪ֥Ȥ롥

=cut
sub new {
    my( $class, $spec, $id ) = @_;
    my $new = bless( {}, $class );

    $spec =~ s/\s*$//;
    if( $spec eq '*' ){
	$new->id( $id );
    } elsif( my( $parent_id, $dpndtype, $fstring ) = ( $spec =~ m/^\* (-?\d+)([DPIA])(.*)$/ ) ){
	$new->id( $id );
	$new->parent_id( $parent_id );
	$new->dpndtype( $dpndtype );
	$new->fstring( $fstring );
    } else {
	die "KNP::Bunsetsu::new(): Illegal spec = $spec\n";
    }
    $new;
}

=back

=head1 METHODS

1ĤʸʣηǤʤ뤿ᡤʸᥪ֥ȤϷ󥪥֥
 C<Juman::MList> ѾƤ롥äơФ
 C<mrph> ᥽åɤѲǽǤ롥

ޤʲϤԤäϡ1Ĥʸ᤬ʣΥʤ⤢롥
Τᡤʸᥪ֥Ȥϥ󥪥֥ C<KNP::TList> Ѿ
ΥꥹȤФ C<tag> ᥽åɤѲǽǤ롥

=over 4

=item mrph_list

ʸ˴ޤޤƤηǤ֤

=cut
sub mrph_list {
    my $this = shift;
    if( $this->tag ){
	$this->KNP::TList::mrph_list( @_ );
    } else {
	$this->Juman::MList::mrph_list( @_ );
    }
}

=item push_mrph ( @MRPH )

ꤵ줿Ǥʸɲä롥

=cut
sub push_mrph {
    my $this = shift;
    if( $this->tag ){
	$this->KNP::TList::push_mrph( @_ );
    } else {
	$this->Juman::MList::push_mrph( @_ );
    }
}

=item push_tag ( @TAG )

ꤵ줿ʸɲä롥

=cut
sub push_tag {
    my $this = shift;
    if( $this->Juman::MList::mrph_list ){
	# ʸˤϡ˴ޤޤƤʤǤ¸ߤƤ
	# ǡǡ̷ǽ롥
	carp "Unsafe addition of tags";
    }
    $this->KNP::TList::push_tag( @_ );
}

=back

ʸ֤ΰ¸ط˴ؤݻ뤿ˡC<KNP::Depend> 
饹ѾƤ롥äơʲΥ᥽åɤѲǽǤ롥

=over 4

=item parent

ʸ֤

=item child

ʸ˷äƤʸΥꥹȤ֤

=item dpndtype

طμ(D,P,I,A)֤

=item id

󥹥ȥ饯ƤӽФȤ˻ꤵ줿 ID ̵֤ξ -1 
֤

=back

KNP ˤäƳƤ줿ħʸݻȤ뤿ˡ
C<KNP::Fstring> 饹ѾƤ롥äơʲΥ᥽åɤ
ǽǤ롥

=over 4

=item fstring

ħʸ֤

=item feature

ħΥꥹȤ֤

=item push_feature

ħɲä롥

=back

äơʲΥ᥽åɤƤ롥

=over 4

=item spec

ʸᥪ֥ȤʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    sprintf( "* %d%s %s\n%s",
	     $this->parent() ? $this->parent->id() : -1,
	     $this->dpndtype(),
	     $this->fstring(),
	     ( $this->tag ? $this->KNP::TList::spec() : $this->Juman::MList::spec() ) );
}

=back

=head1 DESTRUCTOR

ʸᥪ֥Ȥϡǥȥ饯Ƥ2Υ֥ 
C<KNP::Depend>, C<KNP::TList> ѾƤ롥ξΥǥȥ饯򤭤
ȸƤӽФʤȡ꡼θȤʤ롥

=cut
sub DESTROY {
    my( $this ) = @_;
    $this->KNP::TList::DESTROY();
    $this->KNP::Depend::DESTROY();
}

=head1 SEE ALSO

=over 4

=item *

L<KNP::Depend>

=item *

L<KNP::Fstring>

=item *

L<KNP::TList>

=item *

L<Juman::MList>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
