# $Id: BList.pm,v 1.2 2006/10/31 08:53:08 shibata Exp $
package KNP::BList;
require 5.004_04; # For base pragma.
use KNP::Bunsetsu;
use KNP::TList;
use strict;
use base qw/ KNP::DrawTree KNP::KULM::BList KNP::KULM::TList Juman::KULM::MList /;

=head1 NAME

KNP::BList - ʸ󥪥֥

=head1 SYNOPSIS

  $result = new KNP::BList();

=head1 DESCRIPTION

ʸݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new( @BNST )

ꤵ줿ʸΥꥹȤݻ륪֥Ȥ롥ά
ϡʸݻ륪֥Ȥ롥

=cut
sub new {
    my $new = bless( {}, shift );
    if( @_ ){
	$new->push_bnst( @_ );
    }
    $new;
}

=back

=head1 METHODS

=over 4

=item bnst ( NUM )

 I<NUM> ܤʸ֤

=item bnst

ƤʸΥꥹȤ֤

=begin comment

C<bnst> ᥽åɤμΤϡC<KNP::KULM::BList> 饹Ƥ롥

=end comment

=item bnst_list

ƤʸΥꥹȤ֤

=cut
sub bnst_list {
    my( $this ) = @_;
    if( defined $this->{bnst} ){
	@{$this->{bnst}};
    } else {
	wantarray ? () : 0;
    }
}

=item push_bnst( @BNST )

ꤵ줿ʸʸɲä롥

=cut
sub push_bnst {
    my( $this, @bnst ) = @_;
    if( grep( ! $_->isa('KNP::Bunsetsu'), @bnst ) ){
	die "Illegal type of argument.";
    } elsif( $this->{BLIST_READONLY} ){
	die;
    } else {
	push( @{ $this->{bnst} ||= [] }, @bnst );
    }
}

=item tag ( NUM )

 I<NUM> ܤΥ֤

=item tag

ƤΥΥꥹȤ֤

=begin comment

C<tag> ᥽åɤμΤϡC<KNP::KULM::TList> 饹Ƥ롥

=end comment

=item tag_list

ƤΥΥꥹȤ֤

=cut
sub tag_list {
    map( $_->tag_list, shift->bnst_list );
}

=item push_tag( @TAG )

ꤵ줿ʸɲäʸΥȤƤĹ֤ɲ
оݤȤʤʸ᤬¸ߤʤ(= ʸ󤬶Ǥ)ϡɲäϹԤʤ

=cut
sub push_tag {
    my $this = shift;
    if( $this->bnst_list ){
	( $this->bnst_list )[-1]->push_tag( @_ );
    } else {
	0;
    }
}

=item mrph ( NUM )

 I<NUM> ܤηǤ֤

=item mrph

ƤηǤΥꥹȤ֤

=begin comment

C<mrph> ᥽åɤμΤ C<Juman::KULM::MList> Ƥ롥

=end comment

=item mrph_list

ƤηǤΥꥹȤ֤

=cut
sub mrph_list {
    map( $_->mrph_list, shift->bnst_list );
}

=item push_mrph( @MRPH )

ꤵ줿ǤʸɲäʸηȤƤĹ֤
ɲоݤȤʤʸ᤬¸ߤʤ(= ʸ󤬶Ǥ)ϡɲäϹԤ
ʤ

=cut
sub push_mrph {
    my $this = shift;
    if( $this->bnst_list ){
	( $this->bnst_list )[-1]->push_mrph( @_ );
    } else {
	0;
    }
}

=item set_readonly

ʸФ񤭹ߤԵĤꤹ롥

=cut
sub set_readonly {
    my( $this ) = @_;
    for my $bnst ( $this->bnst_list ){
	$bnst->set_readonly();
    }
    $this->{BLIST_READONLY} = 1;
}

=item spec

ʸʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    join( '', map( $_->spec, $this->bnst_list ) );
}

=item draw_tree

=item draw_bnst_tree

ʸΰ¸طڹ¤ȤɽƽϤ롥

=cut
sub draw_bnst_tree {
    shift->draw_tree( @_ );
}

=item draw_tag_tree

ΰ¸طڹ¤ȤɽƽϤ롥

=cut
sub draw_tag_tree {
    my $tlist = KNP::TList->new( shift->tag_list );
    $tlist->set_nodestroy();
    $tlist->draw_tree( @_ );
}

# draw_tree ᥽åɤȤ̿ѤΥ᥽åɡ
sub draw_tree_leaves {
    shift->bnst_list( @_ );
}

sub set_nodestroy {
    shift->{BLIST_NODESTROY} = 1;
}

=back

=head1 DESTRUCTOR

ʸᥪ֥ȴ֤˴ľΥե󥹤ȡ̾ Garbage
Collection ˤäƤϥ꤬ʤʤ롥򤱤뤿ˡ
Ū˥ե󥹤˲ destructor Ƥ롥

=cut
sub DESTROY {
    my( $this ) = @_;
    unless( $this->{BLIST_NODESTROY} ){
	grep( ref $_ && $_->isa('KNP::Bunsetsu') && $_->DESTROY, $this->bnst_list );
    }
}

=head1 SEE ALSO

=over 4

=item *

L<KNP::Bunsetsu>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=back

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
