# Find Gwenhywfar
#
#  GWENHYWFAR_FOUND - system has Gwenhywfar with the minimum version needed
#  GWENHYWFAR_INCLUDE_DIRS - the Gwenhywfar include directories
#  GWENHYWFAR_LIBRARIES - The libraries needed to use Gwenhywfar
#  GWENHYWFAR_VERSION = The version of Gwenhywfar as defined in version.h

set(GWENHYWFAR_FOUND FALSE)

if(NOT GWENHYWFAR_MIN_VERSION)
  set(GWENHYWFAR_MIN_VERSION "4.0.0")
endif(NOT GWENHYWFAR_MIN_VERSION)

if(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)
  # Already in cache, be silent
  set(GWENHYWFAR_FIND_QUIETLY TRUE)
endif(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)

PKG_CHECK_MODULES(GWENHYWFAR gwenhywfar>=${GWENHYWFAR_MIN_VERSION})

if(${GWENHYWFAR_FOUND})
  PKG_CHECK_MODULES(QT4GUI gwengui-qt4)
  if (NOT ${QT4GUI_FOUND})
    set(GWENHYWFAR_FOUND FALSE)
    unset(GWENHYWFAR_INCLUDE_DIRS)
    unset(GWENHYWFAR_LIBRARIES)
    unset(GWENHYWFAR_VERSION)
    message(STATUS "Gwenhywfar does not have the Q4Banking frontend enabled")
  endif (NOT ${QT4GUI_FOUND})

  if(${GWENHYWFAR_FOUND})
    find_library(GWENHYWFAR_GUI_LIBRARY NAMES gwengui-qt4 libgwengui-qt4
      HINTS ${GWENHYWFAR_LIBRARY_DIRS})
    if(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
      set(GWENHYWFAR_GUI_LIBRARY "")
    endif(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
    set(GWENHYWFAR_LIBRARIES ${GWENHYWFAR_GUI_LIBRARY} ${GWENHYWFAR_LIBRARIES})
  endif(${GWENHYWFAR_FOUND})
endif(${GWENHYWFAR_FOUND})

mark_as_advanced(GWENHYWFAR_INCLUDE_DIRS GWENHYWFAR_LIBRARIES)
