#ifndef _kick_algorithm_sort_h
#define _kick_algorithm_sort_h

//
//      Copyright 2012-2013 Nathan Wehr. All Rights Reserved.
//      Copyright 2013 Kevin H. Patterson. All Rights Reserved.
//
//      Redistribution and use in source and binary forms, with or without modification, are
//      permitted provided that the following conditions are met:
//
//              1. Redistributions of source code must retain the above copyright notice, this list of
//              conditions and the following disclaimer.
//
//              2. Redistributions in binary form must reproduce the above copyright notice, this list
//              of conditions and the following disclaimer in the documentation and/or other materials
//              provided with the distribution.
//
//      THIS SOFTWARE IS PROVIDED BY NATHAN WEHR ''AS IS'' AND ANY EXPRESS OR IMPLIED
//      WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//      FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NATHAN WEHR OR
//      CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//      CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//      SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//      ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//      NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//      ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//      The views and conclusions contained in the software and documentation are those of the
//      authors and should not be interpreted as representing official policies, either expressed
//      or implied, of Nathan Wehr.
//

namespace kick {
	namespace algorithm {
		///////////////////////////////////////////////////////////////////////////////
		// swap
		///////////////////////////////////////////////////////////////////////////////
		template<typename T>
		void swap( T& a, T& b );
		
		///////////////////////////////////////////////////////////////////////////////
		// bubble_sort
		///////////////////////////////////////////////////////////////////////////////
		template<typename T>
		void bubble_sort( T& seq );

	} // namespace algorithm
	
} // namespace kick

template<typename T>
void kick::algorithm::swap( T& a, T& b ) {
	T c( a );
	a = b;
	b = c;
	
}

template<typename T>
void kick::algorithm::bubble_sort( T& seq ) {
	for( typename T::iterator it = seq.begin(); it != seq.end(); ++it ){
		for( typename T::iterator nt = it; nt != seq.end(); ++nt ){
			if( *nt < *it )
				kick::algorithm::swap( *nt, *it );
			
			
		}
		
	}
	
}

#endif // _kick_algorithm_sort_h
