/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ComponentTracker;

public abstract class OverlayPainterComponent
extends JComponent {
    protected final Insets margins;
    private final Integer layer;
    private final ComponentTracker tracker;
    private Component base;
    private Rectangle baseBounds;
    private Rectangle visibleBounds;
    private Window baseWindow;

    public OverlayPainterComponent(Insets insets, int n) {
        this.margins = insets;
        this.layer = n;
        this.tracker = new ComponentTracker(){

            @Override
            protected void attached(Window window) {
                if (window != null) {
                    OverlayPainterComponent.this.windowChanged(window);
                    OverlayPainterComponent.this.visibleBoundsChanged();
                }
            }

            @Override
            protected void windowChanged(Window window, Window window2) {
                OverlayPainterComponent.this.windowChanged(window2);
            }

            @Override
            protected void visibleBoundsChanged(Window window) {
                OverlayPainterComponent.this.visibleBoundsChanged();
            }
        };
        super.setOpaque(false);
        this.setVisible(false);
    }

    public void attach(JComponent jComponent) {
        if (this.base != jComponent) {
            if (jComponent != null) {
                this.base = jComponent;
                this.tracker.attach(jComponent);
                this.setVisible(true);
                this.repaint();
            } else {
                this.setVisible(false);
                if (this.base != null) {
                    this.tracker.attach(null);
                    this.base = null;
                }
            }
        }
    }

    @Override
    public final void setOpaque(boolean bl) {
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    private void windowChanged(Window window) {
        Container container;
        if (window == this.baseWindow) {
            return;
        }
        JRootPane jRootPane = AquaUtils.getRootPane(this.baseWindow);
        JRootPane jRootPane2 = AquaUtils.getRootPane(window);
        this.baseWindow = window;
        if (jRootPane != null) {
            container = this.getParent();
            container.remove(this);
        }
        if (jRootPane2 != null) {
            container = jRootPane2.getLayeredPane();
            container.add((Component)this, this.layer);
            this.visibleBoundsChanged();
        }
    }

    private void visibleBoundsChanged() {
        JRootPane jRootPane = AquaUtils.getRootPane(this.baseWindow);
        if (jRootPane == null || this.base == null || !this.base.isVisible()) {
            this.baseBounds = null;
            this.visibleBounds = null;
            return;
        }
        Dimension dimension = this.base.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            this.baseBounds = null;
            this.visibleBounds = null;
            return;
        }
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(this.base.getParent(), this.base.getLocation(), jLayeredPane);
        int n = point.x - this.margins.left;
        int n2 = point.y - this.margins.top;
        int n3 = dimension.width + this.margins.left + this.margins.right;
        int n4 = dimension.height + this.margins.top + this.margins.bottom;
        if (n != this.getX() || n2 != this.getY() || n3 != this.getWidth() || n4 != this.getHeight()) {
            super.setBounds(n, n2, n3, n4);
            this.repaint();
        }
        this.baseBounds = new Rectangle(this.margins.left, this.margins.top, dimension.width, dimension.height);
        this.visibleBounds = OverlayPainterComponent.getVisibleBounds(this.base);
        if (this.visibleBounds != null) {
            this.visibleBounds = new Rectangle(this.visibleBounds.x + this.margins.left, this.visibleBounds.y + this.margins.top, this.visibleBounds.width, this.visibleBounds.height);
        }
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        if (this.visibleBounds != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setClip(-1000, -1000, 1000000, 1000000);
            graphics2D.clip(this.visibleBounds);
            graphics2D.translate(this.baseBounds.x, this.baseBounds.y);
            this.internalPaint(graphics2D);
        }
    }

    protected abstract void internalPaint(Graphics2D var1);

    protected static Rectangle getVisibleBounds(Component component) {
        int n = 0;
        int n2 = 0;
        Serializable serializable = component;
        while (serializable.isVisible()) {
            Serializable serializable2;
            if (serializable instanceof JRootPane) {
                serializable2 = serializable.getSize();
                return new Rectangle(n, n2, ((Dimension)serializable2).width, ((Dimension)serializable2).height);
            }
            if (serializable instanceof JViewport) {
                serializable2 = (JViewport)serializable;
                Rectangle rectangle = ((JComponent)serializable2).getVisibleRect();
                return new Rectangle(n + rectangle.x, n2 + rectangle.y, rectangle.width, rectangle.height);
            }
            serializable2 = serializable.getParent();
            if (serializable2 == null) {
                return null;
            }
            n -= serializable.getX();
            n2 -= serializable.getY();
            serializable = serializable2;
        }
        return null;
    }
}

