/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaCaret
extends DefaultCaret
implements UIResource,
PropertyChangeListener {
    private static final String SELECT_CONTENT_ON_FOCUS_GAINED_KEY = "JTextComponent.selectContentOnFocusGained";
    private boolean isMultiLineEditor;
    private boolean temporaryInhibitSelectAllOnFocusGained = false;

    @Override
    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        this.isMultiLineEditor = jTextComponent instanceof JTextArea || jTextComponent instanceof JEditorPane;
        jTextComponent.addPropertyChangeListener(this);
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removePropertyChangeListener(this);
        super.deinstall(jTextComponent);
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return BasicTextUI.BasicHighlighter.DefaultPainter;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            bl = this.getDot() == this.getMark();
        }
        super.setVisible(bl);
    }

    @Override
    protected void fireStateChanged() {
        JTextComponent jTextComponent = this.getComponent();
        this.setVisible(jTextComponent.isEnabled() && jTextComponent.isEditable() && jTextComponent.isFocusOwner());
        super.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("Frame.active".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.setVisible(jTextComponent.isFocusOwner());
            } else {
                this.setVisible(false);
            }
            if (this.getDot() != this.getMark()) {
                jTextComponent.getUI().damageRange(jTextComponent, this.getDot(), this.getMark());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.shouldSelectAllOnFocusGained()) {
            int n;
            JTextComponent jTextComponent = this.getComponent();
            int n2 = jTextComponent.getDocument().getLength();
            int n3 = this.getDot();
            if (n3 == (n = this.getMark())) {
                if (n3 == 0) {
                    jTextComponent.setCaretPosition(n2);
                    jTextComponent.moveCaretPosition(0);
                } else if (n3 == n2) {
                    jTextComponent.setCaretPosition(0);
                    jTextComponent.moveCaretPosition(n2);
                }
            }
        }
        super.focusGained(focusEvent);
    }

    private boolean shouldSelectAllOnFocusGained() {
        if (this.temporaryInhibitSelectAllOnFocusGained) {
            this.temporaryInhibitSelectAllOnFocusGained = false;
            return false;
        }
        JTextComponent jTextComponent = this.getComponent();
        if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
            return false;
        }
        Object object = jTextComponent.getClientProperty(SELECT_CONTENT_ON_FOCUS_GAINED_KEY);
        if (this.isMultiLineEditor) {
            return Boolean.TRUE.equals(object);
        }
        return !Boolean.FALSE.equals(object);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.temporaryInhibitSelectAllOnFocusGained = false;
        super.focusLost(focusEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            this.temporaryInhibitSelectAllOnFocusGained = true;
        }
    }
}

