/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vappearances;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.VAppearance;

class VAppearanceImpl
implements VAppearance {
    @NotNull
    private final String name;
    private final boolean isDark;
    private final boolean isHighContrast;
    @NotNull
    private final String data;
    @NotNull
    private final Map<String, Color> colors;
    @Nullable
    private VAppearance replacement;

    @Nullable
    public static VAppearance parse(@NotNull String string) {
        String string2;
        String string3;
        int n = string.indexOf(10);
        if (n > 0 && (string3 = string.substring(0, n)).startsWith(string2 = "Appearance: ")) {
            String string4;
            String string5 = string3.substring(string2.length()).trim();
            String string6 = null;
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (string6 == null) {
                    string6 = string4;
                    continue;
                }
                if (string4.equals("HighContrast")) {
                    bl = true;
                    continue;
                }
                System.err.println("VAppearance: unrecognized attribute: " + string4);
            }
            if (string6 != null) {
                string4 = string.substring(n + 1);
                Map<String, Color> map = VAppearanceImpl.parseData(string4);
                boolean bl2 = string6.contains("Dark");
                return new VAppearanceImpl(string6, bl2, bl, string, map);
            }
        }
        return null;
    }

    @NotNull
    private static Map<String, Color> parseData(@NotNull String string) {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1).trim();
            Color color = VAppearanceImpl.parseColor(string4);
            if (color == null) continue;
            hashMap.put(string3, color);
        }
        return hashMap;
    }

    @Nullable
    private static Color parseColor(@NotNull String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        Float f = VAppearanceImpl.parseParameter(stringTokenizer);
        Float f2 = VAppearanceImpl.parseParameter(stringTokenizer);
        Float f3 = VAppearanceImpl.parseParameter(stringTokenizer);
        Float f4 = VAppearanceImpl.parseParameter(stringTokenizer);
        if (f != null && f2 != null && f3 != null && f4 != null) {
            return new Color(f.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue());
        }
        return null;
    }

    @Nullable
    private static Float parseParameter(@NotNull StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                float f = Float.parseFloat(string);
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                return Float.valueOf(f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private VAppearanceImpl(@NotNull String string, boolean bl, boolean bl2, @NotNull String string2, @NotNull Map<String, Color> map) {
        this.name = string;
        this.isDark = bl;
        this.isHighContrast = bl2;
        this.data = string2;
        this.colors = Collections.unmodifiableMap(map);
    }

    public boolean isValid() {
        return this.replacement == null;
    }

    @Nullable
    public synchronized VAppearance getReplacement() {
        return this.replacement;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDark() {
        return this.isDark;
    }

    @Override
    public boolean isHighContrast() {
        return this.isHighContrast;
    }

    @NotNull
    String getData() {
        return this.data;
    }

    @Override
    @NotNull
    public Map<String, Color> getColors() {
        return this.colors;
    }

    synchronized void setReplacement(@NotNull VAppearance vAppearance) {
        this.replacement = vAppearance;
    }
}

