/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class OffsetRasterRendererX
extends Renderer {
    @NotNull
    private final Renderer source;
    private final int x;
    private final int y;
    private final int w;
    private final int h;

    public OffsetRasterRendererX(@NotNull Renderer renderer, int n, int n2, int n3, int n4) {
        this.source = renderer;
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        if (this.source instanceof BasicRendererRenderer) {
            BasicRendererRenderer basicRendererRenderer = (BasicRendererRenderer)this.source;
            BasicRenderer basicRenderer = basicRendererRenderer.getBasicRenderer();
            RendererDescription rendererDescription = basicRendererRenderer.getRendererDescription();
            if (rendererDescription.isTrivial()) {
                reusableCompositor.composeRenderer(basicRenderer, this.x, this.y, this.w, this.h);
            } else {
                int n = reusableCompositor.getScaleFactor();
                float f = n;
                Rectangle2D.Float float_ = new Rectangle2D.Float((float)this.x / f, (float)this.y / f, (float)this.w / f, (float)this.h / f);
                RasterDescription rasterDescription = rendererDescription.getRasterBounds(float_, n);
                int n2 = Math.round((float)n * rasterDescription.getX());
                int n3 = Math.round((float)n * rasterDescription.getY());
                int n4 = (int)Math.ceil((float)n * rasterDescription.getWidth());
                int n5 = (int)Math.ceil((float)n * rasterDescription.getHeight());
                reusableCompositor.composeRenderer(basicRenderer, n2, n3, n4, n5);
            }
        } else if (this.source instanceof PainterExtensionRenderer) {
            PainterExtensionRenderer painterExtensionRenderer = (PainterExtensionRenderer)this.source;
            PainterExtension painterExtension = painterExtensionRenderer.getPainterExtension();
            reusableCompositor.composePainter(painterExtension, this.x, this.y, this.w, this.h);
        }
    }
}

