/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.fc.MyEditorKit;

public class NameView
extends JTextPane {
    private final Font font = UIManager.getFont("FileChooser.previewNameFont");

    public NameView() {
        this.setEditorKit(new MyEditorKit());
        this.setEditable(false);
        this.setFocusable(false);
        this.setBorder(AquaLookAndFeel.NOTHING_BORDER);
        this.addPropertyChangeListener("Aqua.appearance", propertyChangeEvent -> this.updateAttributes());
    }

    @Override
    public void setText(@NotNull String string) {
        super.setText(string);
        this.updateAttributes();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void updateAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        StyleConstants.setFontFamily(simpleAttributeSet, this.font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, this.font.getSize());
        StyleConstants.setForeground(simpleAttributeSet, this.getForeground());
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
    }
}

