// Copyright 2015 Keybase, Inc. All rights reserved. Use of
// this source code is governed by the included BSD license.

package libkb

import (
	"testing"
)

var gabrielSecret = `
-----BEGIN PGP PRIVATE KEY BLOCK-----
Comment: GPGTools - http://gpgtools.org
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=o3ce
-----END PGP PRIVATE KEY BLOCK-----
`

var allKeys = []string{
	gabrielSecret,
}

func TestParseKeys(t *testing.T) {
	for _, k := range allKeys {
		_, err := ReadOneKeyFromString(k)
		if err != nil {
			t.Fatal(err)
		}
	}
}
