/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.net.Node;

class TaskInProgress {
    static final int MAX_TASK_EXECS = 1;
    int maxTaskAttempts = 4;
    static final double SPECULATIVE_GAP = 0.2;
    static final long SPECULATIVE_LAG = 60000L;
    private static final int NUM_ATTEMPTS_PER_RESTART = 1000;
    public static final Log LOG = LogFactory.getLog(TaskInProgress.class);
    private String jobFile = null;
    private final JobSplit.TaskSplitMetaInfo splitInfo;
    private int numMaps;
    private int partition;
    private JobTracker jobtracker;
    private TaskID id;
    private JobInProgress job;
    private final int numSlotsRequired;
    private int successEventNumber = -1;
    private int numTaskFailures = 0;
    private int numKilledTasks = 0;
    private double progress = 0.0;
    private String state = "";
    private long startTime = 0L;
    private long execStartTime = 0L;
    private long execFinishTime = 0L;
    private int completes = 0;
    private boolean failed = false;
    private boolean killed = false;
    private long maxSkipRecords = 0L;
    private FailedRanges failedRanges = new FailedRanges();
    private volatile boolean skipping = false;
    private boolean jobCleanup = false;
    private boolean jobSetup = false;
    int nextTaskId = 0;
    private TaskAttemptID successfulTaskId;
    private TaskAttemptID firstTaskId;
    private TreeMap<TaskAttemptID, String> activeTasks = new TreeMap();
    private TreeSet<TaskAttemptID> tasks = new TreeSet();
    private JobConf conf;
    private Map<TaskAttemptID, List<String>> taskDiagnosticData = new TreeMap<TaskAttemptID, List<String>>();
    private TreeMap<TaskAttemptID, TaskStatus> taskStatuses = new TreeMap();
    private TreeMap<TaskAttemptID, String> cleanupTasks = new TreeMap();
    private TreeSet<String> machinesWhereFailed = new TreeSet();
    private TreeSet<TaskAttemptID> tasksReportedClosed = new TreeSet();
    private TreeMap<TaskAttemptID, Boolean> tasksToKill = new TreeMap();
    private TaskAttemptID taskToCommit;
    private Counters counters = new Counters();
    private String user;

    public TaskInProgress(JobID jobid, String jobFile, JobSplit.TaskSplitMetaInfo split, JobTracker jobtracker, JobConf conf, JobInProgress job, int partition, int numSlotsRequired) {
        this.jobFile = jobFile;
        this.splitInfo = split;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.partition = partition;
        this.maxSkipRecords = SkipBadRecords.getMapperMaxSkipRecords(conf);
        this.numSlotsRequired = numSlotsRequired;
        this.setMaxTaskAttempts();
        this.init(jobid);
    }

    public TaskInProgress(JobID jobid, String jobFile, int numMaps, int partition, JobTracker jobtracker, JobConf conf, JobInProgress job, int numSlotsRequired) {
        this.jobFile = jobFile;
        this.splitInfo = null;
        this.numMaps = numMaps;
        this.partition = partition;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.maxSkipRecords = SkipBadRecords.getReducerMaxSkipGroups(conf);
        this.numSlotsRequired = numSlotsRequired;
        this.setMaxTaskAttempts();
        this.init(jobid);
    }

    private void setMaxTaskAttempts() {
        this.maxTaskAttempts = this.isMapTask() ? this.conf.getMaxMapAttempts() : this.conf.getMaxReduceAttempts();
        this.user = this.job.getUser();
    }

    public int idWithinJob() {
        return this.partition;
    }

    public boolean isJobCleanupTask() {
        return this.jobCleanup;
    }

    public void setJobCleanupTask() {
        this.jobCleanup = true;
    }

    public boolean isJobSetupTask() {
        return this.jobSetup;
    }

    public void setJobSetupTask() {
        this.jobSetup = true;
    }

    public boolean isOnlyCommitPending() {
        for (TaskStatus t : this.taskStatuses.values()) {
            if (t.getRunState() != TaskStatus.State.COMMIT_PENDING) continue;
            return true;
        }
        return false;
    }

    public boolean isCommitPending(TaskAttemptID taskId) {
        TaskStatus t = this.taskStatuses.get(taskId);
        if (t == null) {
            return false;
        }
        return t.getRunState() == TaskStatus.State.COMMIT_PENDING;
    }

    void init(JobID jobId) {
        this.startTime = this.jobtracker.getClock().getTime();
        this.id = new TaskID(jobId, this.isMapTask(), this.partition);
        this.skipping = this.startSkipping();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getExecStartTime() {
        return this.execStartTime;
    }

    public void setExecStartTime(long startTime) {
        this.execStartTime = startTime;
    }

    public long getExecFinishTime() {
        return this.execFinishTime;
    }

    public void setExecFinishTime(long finishTime) {
        this.execFinishTime = finishTime;
        JobHistory.Task.logUpdates(this.id, this.execFinishTime);
    }

    public JobInProgress getJob() {
        return this.job;
    }

    public TaskID getTIPId() {
        return this.id;
    }

    public boolean isMapTask() {
        return this.splitInfo != null;
    }

    TaskType getAttemptType(TaskAttemptID id) {
        if (this.isCleanupAttempt(id)) {
            return TaskType.TASK_CLEANUP;
        }
        if (this.isJobSetupTask()) {
            return TaskType.JOB_SETUP;
        }
        if (this.isJobCleanupTask()) {
            return TaskType.JOB_CLEANUP;
        }
        if (this.isMapTask()) {
            return TaskType.MAP;
        }
        return TaskType.REDUCE;
    }

    TaskType getFirstTaskType() {
        assert (this.firstTaskId != null) : "got first task";
        return this.getAttemptType(this.firstTaskId);
    }

    public boolean isFirstAttempt(TaskAttemptID taskId) {
        return this.firstTaskId == null ? false : this.firstTaskId.equals(taskId);
    }

    public boolean isRunning() {
        return !this.activeTasks.isEmpty();
    }

    boolean isAttemptRunning(TaskAttemptID taskId) {
        return this.activeTasks.containsKey(taskId);
    }

    TaskAttemptID getSuccessfulTaskid() {
        return this.successfulTaskId;
    }

    private void setSuccessfulTaskid(TaskAttemptID successfulTaskId) {
        this.successfulTaskId = successfulTaskId;
    }

    private void resetSuccessfulTaskid() {
        this.successfulTaskId = null;
    }

    public synchronized boolean isComplete() {
        return this.completes > 0;
    }

    public boolean isComplete(TaskAttemptID taskid) {
        return this.completes > 0 && taskid.equals(this.getSuccessfulTaskid());
    }

    public boolean isFailed() {
        return this.failed;
    }

    public int numTaskFailures() {
        return this.numTaskFailures;
    }

    public int numKilledTasks() {
        return this.numKilledTasks;
    }

    public double getProgress() {
        return this.progress;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public boolean shouldClose(TaskAttemptID taskid) {
        boolean close = false;
        TaskStatus ts = this.taskStatuses.get(taskid);
        if (ts != null && !this.tasksReportedClosed.contains(taskid) && (this.failed || this.job.getStatus().getRunState() != 1 && this.job.getStatus().getRunState() != 4)) {
            this.tasksReportedClosed.add(taskid);
            close = true;
        } else if (this.isComplete() && (!this.isMapTask() || this.jobSetup || this.jobCleanup || !this.isComplete(taskid)) && !this.tasksReportedClosed.contains(taskid)) {
            this.tasksReportedClosed.add(taskid);
            close = true;
        } else if (this.isCommitPending(taskid) && !this.shouldCommit(taskid) && !this.tasksReportedClosed.contains(taskid)) {
            this.tasksReportedClosed.add(taskid);
            close = true;
        } else {
            close = this.tasksToKill.keySet().contains(taskid);
        }
        return close;
    }

    public void doCommit(TaskAttemptID taskid) {
        this.taskToCommit = taskid;
    }

    public boolean shouldCommit(TaskAttemptID taskid) {
        return !this.isComplete() && this.isCommitPending(taskid) && this.taskToCommit.equals(taskid);
    }

    synchronized TaskReport generateSingleReport() {
        ArrayList<String> diagnostics = new ArrayList<String>();
        for (List<String> l : this.taskDiagnosticData.values()) {
            diagnostics.addAll(l);
        }
        TIPStatus currentStatus = null;
        if (this.isRunning() && !this.isComplete()) {
            currentStatus = TIPStatus.RUNNING;
        } else if (this.isComplete()) {
            currentStatus = TIPStatus.COMPLETE;
        } else if (this.wasKilled()) {
            currentStatus = TIPStatus.KILLED;
        } else if (this.isFailed()) {
            currentStatus = TIPStatus.FAILED;
        } else if (!(this.isComplete() || this.isRunning() || this.wasKilled())) {
            currentStatus = TIPStatus.PENDING;
        }
        TaskReport report = new TaskReport(this.getTIPId(), (float)this.progress, this.state, diagnostics.toArray(new String[diagnostics.size()]), currentStatus, this.execStartTime, this.execFinishTime, this.counters);
        if (currentStatus == TIPStatus.RUNNING) {
            report.setRunningTaskAttempts(this.activeTasks.keySet());
        } else if (currentStatus == TIPStatus.COMPLETE) {
            report.setSuccessfulAttempt(this.getSuccessfulTaskid());
        }
        return report;
    }

    synchronized List<String> getDiagnosticInfo(TaskAttemptID taskId) {
        return this.taskDiagnosticData.get(taskId);
    }

    public void addDiagnosticInfo(TaskAttemptID taskId, String diagInfo) {
        List<String> diagHistory = this.taskDiagnosticData.get(taskId);
        if (diagHistory == null) {
            diagHistory = new ArrayList<String>();
            this.taskDiagnosticData.put(taskId, diagHistory);
        }
        diagHistory.add(diagInfo);
    }

    synchronized boolean updateStatus(TaskStatus status) {
        TaskAttemptID taskid = status.getTaskID();
        String diagInfo = status.getDiagnosticInfo();
        TaskStatus oldStatus = this.taskStatuses.get(taskid);
        boolean changed = true;
        if (diagInfo != null && diagInfo.length() > 0) {
            LOG.info("Error from " + taskid + ": " + diagInfo);
            this.addDiagnosticInfo(taskid, diagInfo);
        }
        if (this.skipping) {
            this.failedRanges.updateState(status);
        }
        if (oldStatus != null) {
            TaskStatus.State oldState = oldStatus.getRunState();
            TaskStatus.State newState = status.getRunState();
            if (newState != TaskStatus.State.RUNNING && newState != TaskStatus.State.COMMIT_PENDING && newState != TaskStatus.State.FAILED_UNCLEAN && newState != TaskStatus.State.KILLED_UNCLEAN && newState != TaskStatus.State.UNASSIGNED && oldState == newState) {
                LOG.warn("Recieved duplicate status update of '" + (Object)((Object)newState) + "' for '" + taskid + "' of TIP '" + this.getTIPId() + "'" + "oldTT=" + oldStatus.getTaskTracker() + " while newTT=" + status.getTaskTracker());
                return false;
            }
            if (!(newState != TaskStatus.State.RUNNING && newState != TaskStatus.State.UNASSIGNED || oldState != TaskStatus.State.FAILED && oldState != TaskStatus.State.KILLED && oldState != TaskStatus.State.FAILED_UNCLEAN && oldState != TaskStatus.State.KILLED_UNCLEAN && oldState != TaskStatus.State.SUCCEEDED && oldState != TaskStatus.State.COMMIT_PENDING)) {
                return false;
            }
            if (oldState == TaskStatus.State.FAILED || oldState == TaskStatus.State.KILLED) {
                this.tasksToKill.put(taskid, true);
                return false;
            }
            boolean bl = changed = oldState != newState;
        }
        if (!this.isCleanupAttempt(taskid)) {
            this.taskStatuses.put(taskid, status);
        } else {
            this.taskStatuses.get(taskid).statusUpdate(status.getRunState(), status.getProgress(), status.getStateString(), status.getPhase(), status.getFinishTime());
        }
        this.recomputeProgress();
        return changed;
    }

    public void incompleteSubTask(TaskAttemptID taskid, JobStatus jobStatus) {
        TaskStatus status = this.taskStatuses.get(taskid);
        String trackerHostName = null;
        TaskStatus.State taskState = TaskStatus.State.FAILED;
        if (status != null) {
            String trackerName = status.getTaskTracker();
            trackerHostName = JobInProgress.convertTrackerNameToHostName(trackerName);
            Boolean shouldFail = this.tasksToKill.remove(taskid);
            if (shouldFail != null) {
                taskState = status.getRunState() == TaskStatus.State.FAILED || status.getRunState() == TaskStatus.State.KILLED ? (shouldFail != false ? TaskStatus.State.FAILED : TaskStatus.State.KILLED) : (shouldFail != false ? TaskStatus.State.FAILED_UNCLEAN : TaskStatus.State.KILLED_UNCLEAN);
                status.setRunState(taskState);
                this.addDiagnosticInfo(taskid, "Task has been " + (Object)((Object)taskState) + " by the user");
            }
            if ((taskState = status.getRunState()) != TaskStatus.State.FAILED && taskState != TaskStatus.State.KILLED && taskState != TaskStatus.State.FAILED_UNCLEAN && taskState != TaskStatus.State.KILLED_UNCLEAN) {
                LOG.info("Task '" + taskid + "' running on '" + trackerName + "' in state: '" + (Object)((Object)taskState) + "' being failed!");
                status.setRunState(TaskStatus.State.FAILED);
                taskState = TaskStatus.State.FAILED;
            }
            if (0L == status.getFinishTime()) {
                status.setFinishTime(this.jobtracker.getClock().getTime());
            }
        }
        this.activeTasks.remove(taskid);
        if (this.isMapTask() && !this.jobSetup && !this.jobCleanup && this.isComplete(taskid) && jobStatus.getRunState() != 2) {
            --this.completes;
            this.resetSuccessfulTaskid();
        }
        if (this.tasks.contains(taskid)) {
            if (taskState == TaskStatus.State.FAILED) {
                ++this.numTaskFailures;
                this.machinesWhereFailed.add(trackerHostName);
                if (this.maxSkipRecords > 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TaskInProgress adding" + status.getNextRecordRange());
                    }
                    this.failedRanges.add(status.getNextRecordRange());
                    this.skipping = this.startSkipping();
                }
            } else if (taskState == TaskStatus.State.KILLED) {
                ++this.numKilledTasks;
            }
        }
        if (this.numTaskFailures >= this.maxTaskAttempts) {
            LOG.info("TaskInProgress " + this.getTIPId() + " has failed " + this.numTaskFailures + " times.");
            this.kill();
        }
        this.user = this.job.getUser();
    }

    private boolean startSkipping() {
        return this.maxSkipRecords > 0L && this.numTaskFailures >= SkipBadRecords.getAttemptsToStartSkipping(this.conf);
    }

    private void completedTask(TaskAttemptID taskId, TaskStatus.State finalTaskState) {
        TaskStatus status = this.taskStatuses.get(taskId);
        status.setRunState(finalTaskState);
        this.activeTasks.remove(taskId);
    }

    void alreadyCompletedTask(TaskAttemptID taskid) {
        this.completedTask(taskid, TaskStatus.State.KILLED);
        this.addDiagnosticInfo(taskid, "Already completed TIP");
        LOG.info("Already complete TIP " + this.getTIPId() + " has completed task " + taskid);
    }

    public void completed(TaskAttemptID taskid) {
        this.completedTask(taskid, TaskStatus.State.SUCCEEDED);
        this.setSuccessfulTaskid(taskid);
        ++this.completes;
        this.execFinishTime = this.jobtracker.getClock().getTime();
        this.recomputeProgress();
    }

    public String[] getSplitLocations() {
        if (this.isMapTask() && !this.jobSetup && !this.jobCleanup) {
            return this.splitInfo.getLocations();
        }
        return new String[0];
    }

    public TaskStatus[] getTaskStatuses() {
        return this.taskStatuses.values().toArray(new TaskStatus[this.taskStatuses.size()]);
    }

    TaskAttemptID[] getAllTaskAttemptIDs() {
        return this.tasks.toArray(new TaskAttemptID[this.tasks.size()]);
    }

    public TaskStatus getTaskStatus(TaskAttemptID taskid) {
        return this.taskStatuses.get(taskid);
    }

    public void kill() {
        if (this.isComplete() || this.failed) {
            return;
        }
        this.failed = true;
        this.killed = true;
        this.execFinishTime = this.jobtracker.getClock().getTime();
        this.recomputeProgress();
    }

    public boolean wasKilled() {
        return this.killed;
    }

    boolean killTask(TaskAttemptID taskId, boolean shouldFail) {
        TaskStatus st = this.taskStatuses.get(taskId);
        if (st != null && (st.getRunState() == TaskStatus.State.RUNNING || st.getRunState() == TaskStatus.State.COMMIT_PENDING || st.inTaskCleanupPhase() || st.getRunState() == TaskStatus.State.UNASSIGNED) && this.tasksToKill.put(taskId, shouldFail) == null) {
            String logStr = "Request received to " + (shouldFail ? "fail" : "kill") + " task '" + taskId + "' by user";
            this.addDiagnosticInfo(taskId, logStr);
            LOG.info(logStr);
            return true;
        }
        return false;
    }

    void recomputeProgress() {
        if (this.isComplete()) {
            this.progress = 1.0;
            TaskStatus completedStatus = this.taskStatuses.get(this.getSuccessfulTaskid());
            this.counters = completedStatus.getCounters();
            this.state = completedStatus.getStateString();
        } else if (this.failed) {
            this.progress = 0.0;
            this.state = "";
            this.counters = new Counters();
        } else {
            double bestProgress = 0.0;
            String bestState = "";
            Counters bestCounters = new Counters();
            for (TaskAttemptID taskid : this.taskStatuses.keySet()) {
                TaskStatus status = this.taskStatuses.get(taskid);
                if (status.getRunState() == TaskStatus.State.SUCCEEDED) {
                    bestProgress = 1.0;
                    bestState = status.getStateString();
                    bestCounters = status.getCounters();
                    break;
                }
                if (status.getRunState() == TaskStatus.State.COMMIT_PENDING) {
                    bestProgress = this.progress;
                    bestState = this.state;
                    bestCounters = this.counters;
                    continue;
                }
                if (status.getRunState() != TaskStatus.State.RUNNING || !((double)status.getProgress() >= bestProgress)) continue;
                bestProgress = status.getProgress();
                bestState = status.getStateString();
                if (status.getIncludeCounters()) {
                    bestCounters = status.getCounters();
                    continue;
                }
                bestCounters = this.counters;
            }
            this.progress = bestProgress;
            this.state = bestState;
            this.counters = bestCounters;
        }
    }

    boolean isRunnable() {
        return !this.failed && this.completes == 0;
    }

    boolean hasSpeculativeTask(long currentTime, double averageProgress) {
        return !this.skipping && this.activeTasks.size() <= 1 && averageProgress - this.progress >= 0.2 && currentTime - this.startTime >= 60000L && this.completes == 0 && !this.isOnlyCommitPending();
    }

    public Task getTaskToRun(String taskTracker) throws IOException {
        if (0L == this.execStartTime) {
            this.execStartTime = this.jobtracker.getClock().getTime();
        }
        TaskAttemptID taskid = null;
        if (this.nextTaskId < 1 + this.maxTaskAttempts + this.numKilledTasks) {
            int attemptId = this.job.getNumRestarts() * 1000 + this.nextTaskId;
            taskid = new TaskAttemptID(this.id, attemptId);
            ++this.nextTaskId;
        } else {
            LOG.warn("Exceeded limit of " + (1 + this.maxTaskAttempts) + " (plus " + this.numKilledTasks + " killed)" + " attempts for the tip '" + this.getTIPId() + "'");
            return null;
        }
        return this.addRunningTask(taskid, taskTracker);
    }

    public Task addRunningTask(TaskAttemptID taskid, String taskTracker) {
        return this.addRunningTask(taskid, taskTracker, false);
    }

    String getUser() {
        return this.user;
    }

    void setUser(String user) {
        this.user = user;
    }

    public Task addRunningTask(TaskAttemptID taskid, String taskTracker, boolean taskCleanup) {
        int numSlotsNeeded = taskCleanup ? 1 : this.numSlotsRequired;
        Task t = null;
        if (this.isMapTask()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("attempt " + this.numTaskFailures + " sending skippedRecords " + this.failedRanges.getIndicesCount());
            }
            t = new MapTask(this.jobFile, taskid, this.partition, this.splitInfo.getSplitIndex(), numSlotsNeeded);
        } else {
            t = new ReduceTask(this.jobFile, taskid, this.partition, this.numMaps, numSlotsNeeded);
        }
        if (this.jobCleanup) {
            t.setJobCleanupTask();
        }
        if (this.jobSetup) {
            t.setJobSetupTask();
        }
        if (taskCleanup) {
            t.setTaskCleanupTask();
            t.setState(this.taskStatuses.get(taskid).getRunState());
            this.cleanupTasks.put(taskid, taskTracker);
        }
        t.setConf(this.conf);
        t.setUser(this.getUser());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Launching task with skipRanges:" + this.failedRanges.getSkipRanges());
        }
        t.setSkipRanges(this.failedRanges.getSkipRanges());
        t.setSkipping(this.skipping);
        if (this.failedRanges.isTestAttempt()) {
            t.setWriteSkipRecs(false);
        }
        this.activeTasks.put(taskid, taskTracker);
        this.tasks.add(taskid);
        this.jobtracker.createTaskEntry(taskid, taskTracker, this);
        if (this.firstTaskId == null) {
            this.firstTaskId = taskid;
        }
        return t;
    }

    boolean isRunningTask(TaskAttemptID taskid) {
        TaskStatus status = this.taskStatuses.get(taskid);
        return status != null && status.getRunState() == TaskStatus.State.RUNNING;
    }

    boolean isCleanupAttempt(TaskAttemptID taskid) {
        return this.cleanupTasks.containsKey(taskid);
    }

    String machineWhereCleanupRan(TaskAttemptID taskid) {
        return this.cleanupTasks.get(taskid);
    }

    String machineWhereTaskRan(TaskAttemptID taskid) {
        return this.taskStatuses.get(taskid).getTaskTracker();
    }

    boolean wasKilled(TaskAttemptID taskid) {
        return this.tasksToKill.containsKey(taskid);
    }

    public boolean hasFailedOnMachine(String trackerHost) {
        return this.machinesWhereFailed.contains(trackerHost);
    }

    public boolean hasRunOnMachine(String trackerHost, String trackerName) {
        return this.activeTasks.values().contains(trackerName) || this.hasFailedOnMachine(trackerHost);
    }

    public int getNumberOfFailedMachines() {
        return this.machinesWhereFailed.size();
    }

    public int getIdWithinJob() {
        return this.partition;
    }

    public void setSuccessEventNumber(int eventNumber) {
        this.successEventNumber = eventNumber;
    }

    public int getSuccessEventNumber() {
        return this.successEventNumber;
    }

    public String getSplitNodes() {
        if (!this.isMapTask() || this.jobSetup || this.jobCleanup) {
            return "";
        }
        String[] splits = this.splitInfo.getLocations();
        Node[] nodes = new Node[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            nodes[i] = this.jobtracker.getNode(splits[i]);
        }
        Arrays.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                String left = a.getNetworkLocation();
                String right = b.getNetworkLocation();
                return left.compareTo(right);
            }
        });
        return TaskInProgress.nodeToString(nodes);
    }

    private static String nodeToString(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer(nodes[0].toString());
        for (int i = 1; i < nodes.length; ++i) {
            ret.append(",");
            ret.append(nodes[i].toString());
        }
        return ret.toString();
    }

    public long getMapInputSize() {
        if (this.isMapTask() && !this.jobSetup && !this.jobCleanup) {
            return this.splitInfo.getInputDataLength();
        }
        return 0L;
    }

    TreeMap<TaskAttemptID, String> getActiveTasks() {
        return this.activeTasks;
    }

    int getNumSlotsRequired() {
        return this.numSlotsRequired;
    }

    private class FailedRanges {
        private SortedRanges skipRanges = new SortedRanges();
        private Divide divide;

        private FailedRanges() {
        }

        synchronized SortedRanges getSkipRanges() {
            if (this.divide != null) {
                return this.divide.skipRange;
            }
            return this.skipRanges;
        }

        synchronized boolean isTestAttempt() {
            return this.divide != null;
        }

        synchronized long getIndicesCount() {
            if (this.isTestAttempt()) {
                return this.divide.skipRange.getIndicesCount();
            }
            return this.skipRanges.getIndicesCount();
        }

        synchronized void updateState(TaskStatus status) {
            if (this.isTestAttempt() && status.getRunState() == TaskStatus.State.SUCCEEDED) {
                this.divide.testPassed = true;
                status.setRunState(TaskStatus.State.FAILED);
            }
        }

        synchronized void add(SortedRanges.Range failedRange) {
            LOG.warn("FailedRange:" + failedRange);
            if (this.divide != null) {
                LOG.warn("FailedRange:" + failedRange + "  test:" + this.divide.test + "  pass:" + this.divide.testPassed);
                failedRange = this.divide.testPassed ? this.divide.other : this.divide.test;
                this.divide = null;
            }
            if (TaskInProgress.this.maxSkipRecords == 0L || failedRange.getLength() <= TaskInProgress.this.maxSkipRecords) {
                this.skipRanges.add(failedRange);
            } else {
                this.divide = new Divide(failedRange);
            }
        }

        class Divide {
            private final SortedRanges skipRange;
            private final SortedRanges.Range test;
            private final SortedRanges.Range other;
            private boolean testPassed;

            Divide(SortedRanges.Range range) {
                long half = range.getLength() / 2L;
                this.test = new SortedRanges.Range(range.getStartIndex(), half);
                this.other = new SortedRanges.Range(this.test.getEndIndex(), range.getLength() - half);
                this.skipRange = new SortedRanges();
                for (SortedRanges.Range r : FailedRanges.this.skipRanges.getRanges()) {
                    this.skipRange.add(r);
                }
                this.skipRange.add(new SortedRanges.Range(0L, this.test.getStartIndex()));
                this.skipRange.add(new SortedRanges.Range(this.test.getEndIndex(), Long.MAX_VALUE - this.test.getEndIndex()));
            }
        }
    }
}

