/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.hdfs.HftpFileSystem;

public class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected URLOpener originalURL;
    protected URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected long filelength;
    StreamStatus status = StreamStatus.SEEK;

    public ByteRangeInputStream(URL url) {
        this(new URLOpener(url), new URLOpener(null));
    }

    ByteRangeInputStream(URLOpener o, URLOpener r) {
        this.originalURL = o;
        this.resolvedURL = r;
    }

    private InputStream getInputStream() throws IOException {
        if (this.status != StreamStatus.NORMAL) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            URLOpener opener = this.resolvedURL.getURL() == null ? this.originalURL : this.resolvedURL;
            HttpURLConnection connection = opener.openConnection();
            try {
                connection.setRequestMethod("GET");
                if (this.startPos != 0L) {
                    connection.setRequestProperty("Range", "bytes=" + this.startPos + "-");
                }
                connection.connect();
                String cl = connection.getHeaderField("Content-Length");
                long l = this.filelength = cl == null ? -1L : Long.parseLong(cl);
                if (HftpFileSystem.LOG.isDebugEnabled()) {
                    HftpFileSystem.LOG.debug("filelength = " + this.filelength);
                }
                this.in = connection.getInputStream();
            }
            catch (IOException ioe) {
                HftpFileSystem.throwIOExceptionFromConnection(connection, ioe);
            }
            int respCode = connection.getResponseCode();
            if (this.startPos != 0L && respCode != 206) {
                throw new IOException("HTTP_PARTIAL expected, received " + respCode);
            }
            if (this.startPos == 0L && respCode != 200) {
                throw new IOException("HTTP_OK expected, received " + respCode);
            }
            this.resolvedURL.setURL(connection.getURL());
            this.status = StreamStatus.NORMAL;
        }
        return this.in;
    }

    private void update(boolean isEOF, int n) throws IOException {
        if (!isEOF) {
            this.currentPos += (long)n;
        } else if (this.currentPos < this.filelength) {
            throw new IOException("Got EOF but currentPos = " + this.currentPos + " < filelength = " + this.filelength);
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.getInputStream().read();
        this.update(b == -1, 1);
        return b;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            this.status = StreamStatus.SEEK;
        }
    }

    @Override
    public long getPos() throws IOException {
        return this.currentPos;
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    static enum StreamStatus {
        NORMAL,
        SEEK;

    }

    static class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        public HttpURLConnection openConnection() throws IOException {
            return (HttpURLConnection)this.url.openConnection();
        }
    }
}

