// generated by js/modules/k6/html/gen/gen_elements.go directed by js/modules/k6/html/elements.go;  DO NOT EDIT
// nolint: goconst
package html

import "github.com/dop251/goja"

func selToElement(sel Selection) goja.Value {
	if sel.sel.Length() == 0 {
		return goja.Undefined()
	}

	elem := Element{sel.sel.Nodes[0], &sel}

	switch elem.node.Data {
	case AnchorTagName:
		return sel.rt.ToValue(AnchorElement{HrefElement{elem}})
	case AreaTagName:
		return sel.rt.ToValue(AreaElement{HrefElement{elem}})
	case AudioTagName:
		return sel.rt.ToValue(AudioElement{MediaElement{elem}})
	case BaseTagName:
		return sel.rt.ToValue(BaseElement{elem})
	case ButtonTagName:
		return sel.rt.ToValue(ButtonElement{FormFieldElement{elem}})
	case CanvasTagName:
		return sel.rt.ToValue(CanvasElement{elem})
	case DataTagName:
		return sel.rt.ToValue(DataElement{elem})
	case DataListTagName:
		return sel.rt.ToValue(DataListElement{elem})
	case DelTagName:
		return sel.rt.ToValue(DelElement{ModElement{elem}})
	case EmbedTagName:
		return sel.rt.ToValue(EmbedElement{elem})
	case FieldSetTagName:
		return sel.rt.ToValue(FieldSetElement{elem})
	case FormTagName:
		return sel.rt.ToValue(FormElement{elem})
	case IFrameTagName:
		return sel.rt.ToValue(IFrameElement{elem})
	case ImageTagName:
		return sel.rt.ToValue(ImageElement{elem})
	case InputTagName:
		return sel.rt.ToValue(InputElement{FormFieldElement{elem}})
	case InsTagName:
		return sel.rt.ToValue(InsElement{ModElement{elem}})
	case KeygenTagName:
		return sel.rt.ToValue(KeygenElement{elem})
	case LabelTagName:
		return sel.rt.ToValue(LabelElement{elem})
	case LegendTagName:
		return sel.rt.ToValue(LegendElement{elem})
	case LiTagName:
		return sel.rt.ToValue(LiElement{elem})
	case LinkTagName:
		return sel.rt.ToValue(LinkElement{elem})
	case MapTagName:
		return sel.rt.ToValue(MapElement{elem})
	case MetaTagName:
		return sel.rt.ToValue(MetaElement{elem})
	case MeterTagName:
		return sel.rt.ToValue(MeterElement{elem})
	case OListTagName:
		return sel.rt.ToValue(OListElement{elem})
	case ObjectTagName:
		return sel.rt.ToValue(ObjectElement{elem})
	case OptGroupTagName:
		return sel.rt.ToValue(OptGroupElement{elem})
	case OptionTagName:
		return sel.rt.ToValue(OptionElement{elem})
	case OutputTagName:
		return sel.rt.ToValue(OutputElement{elem})
	case ParamTagName:
		return sel.rt.ToValue(ParamElement{elem})
	case PreTagName:
		return sel.rt.ToValue(PreElement{elem})
	case ProgressTagName:
		return sel.rt.ToValue(ProgressElement{elem})
	case QuoteTagName:
		return sel.rt.ToValue(QuoteElement{elem})
	case ScriptTagName:
		return sel.rt.ToValue(ScriptElement{elem})
	case SelectTagName:
		return sel.rt.ToValue(SelectElement{elem})
	case SourceTagName:
		return sel.rt.ToValue(SourceElement{elem})
	case StyleTagName:
		return sel.rt.ToValue(StyleElement{elem})
	case TableTagName:
		return sel.rt.ToValue(TableElement{elem})
	case TableBodyTagName:
		return sel.rt.ToValue(TableBodyElement{TableSectionElement{elem}})
	case TableColTagName:
		return sel.rt.ToValue(TableColElement{elem})
	case TableDataCellTagName:
		return sel.rt.ToValue(TableDataCellElement{TableCellElement{elem}})
	case TableFootTagName:
		return sel.rt.ToValue(TableFootElement{TableSectionElement{elem}})
	case TableHeadTagName:
		return sel.rt.ToValue(TableHeadElement{TableSectionElement{elem}})
	case TableHeaderCellTagName:
		return sel.rt.ToValue(TableHeaderCellElement{TableCellElement{elem}})
	case TableRowTagName:
		return sel.rt.ToValue(TableRowElement{elem})
	case TextAreaTagName:
		return sel.rt.ToValue(TextAreaElement{elem})
	case TimeTagName:
		return sel.rt.ToValue(TimeElement{elem})
	case TitleTagName:
		return sel.rt.ToValue(TitleElement{elem})
	case TrackTagName:
		return sel.rt.ToValue(TrackElement{elem})
	case UListTagName:
		return sel.rt.ToValue(UListElement{elem})
	case VideoTagName:
		return sel.rt.ToValue(VideoElement{MediaElement{elem}})
	default:
		return sel.rt.ToValue(elem)
	}
}

func (e HrefElement) Download() string {
	return e.attrAsString("download")
}
func (e HrefElement) ReferrerPolicy() string {
	attrVal := e.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}
func (e HrefElement) Rel() string {
	return e.attrAsString("rel")
}
func (e HrefElement) Href() string {
	return e.attrAsURLString("href", "")
}
func (e HrefElement) Target() string {
	return e.attrAsString("target")
}
func (e HrefElement) Type() string {
	return e.attrAsString("type")
}
func (e HrefElement) AccessKey() string {
	return e.attrAsString("accesskey")
}
func (e HrefElement) HrefLang() string {
	return e.attrAsString("hreflang")
}
func (e HrefElement) ToString() string {
	return e.attrAsURLString("href", "")
}
func (e MediaElement) Autoplay() bool {
	return e.attrIsPresent("autoplay")
}
func (e MediaElement) Controls() bool {
	return e.attrIsPresent("controls")
}
func (e MediaElement) Loop() bool {
	return e.attrIsPresent("loop")
}
func (e MediaElement) Muted() bool {
	return e.attrIsPresent("muted")
}
func (e MediaElement) Preload() string {
	attrVal := e.attrAsString("preload")
	switch attrVal {
	case "metadata":
		return attrVal
	case "none":
		return attrVal
	default:
		return "auto"
	}
}
func (e MediaElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e MediaElement) CrossOrigin() goja.Value {
	attrVal, exists := e.sel.sel.Attr("crossorigin")
	if !exists {
		return goja.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return e.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return e.sel.rt.ToValue(attrVal)
	default:
		return goja.Undefined()
	}
}
func (e MediaElement) CurrentSrc() string {
	return e.attrAsString("src")
}
func (e MediaElement) DefaultMuted() bool {
	return e.attrIsPresent("muted")
}
func (e MediaElement) MediaGroup() string {
	return e.attrAsString("mediagroup")
}
func (e BaseElement) Href() string {
	return e.attrAsURLString("href", e.sel.URL)
}
func (e BaseElement) Target() string {
	return e.attrAsString("target")
}
func (e ButtonElement) AccessKey() string {
	return e.attrAsString("accesskey")
}
func (e ButtonElement) Autofocus() bool {
	return e.attrIsPresent("autofocus")
}
func (e ButtonElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e ButtonElement) TabIndex() int {
	return e.attrAsInt("tabindex", 0)
}
func (e ButtonElement) Type() string {
	attrVal := e.attrAsString("type")
	switch attrVal {
	case "button":
		return attrVal
	case "menu":
		return attrVal
	case "reset":
		return attrVal
	default:
		return "submit"
	}
}
func (e DataElement) Value() string {
	return e.attrAsString("value")
}
func (e EmbedElement) Height() string {
	return e.attrAsString("height")
}
func (e EmbedElement) Width() string {
	return e.attrAsString("width")
}
func (e EmbedElement) Src() string {
	return e.attrAsString("src")
}
func (e EmbedElement) Type() string {
	return e.attrAsString("type")
}
func (e FieldSetElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e FieldSetElement) Name() string {
	return e.attrAsString("name")
}
func (e FormElement) Action() string {
	return e.attrAsURLString("action", "")
}
func (e FormElement) Name() string {
	return e.attrAsString("name")
}
func (e FormElement) Target() string {
	return e.attrAsString("target")
}
func (e FormElement) Enctype() string {
	attrVal := e.attrAsString("enctype")
	switch attrVal {
	case "multipart/form-data":
		return attrVal
	case "text/plain":
		return attrVal
	default:
		return "application/x-www-form-urlencoded"
	}
}
func (e FormElement) Encoding() string {
	attrVal := e.attrAsString("enctype")
	switch attrVal {
	case "multipart/form-data":
		return attrVal
	case "text/plain":
		return attrVal
	default:
		return "application/x-www-form-urlencoded"
	}
}
func (e FormElement) AcceptCharset() string {
	return e.attrAsString("accept-charset")
}
func (e FormElement) Autocomplete() string {
	attrVal := e.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}
func (e FormElement) NoValidate() bool {
	return e.attrIsPresent("novalidate")
}
func (e IFrameElement) Allowfullscreen() bool {
	return e.attrIsPresent("allowfullscreen")
}
func (e IFrameElement) ReferrerPolicy() string {
	attrVal := e.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}
func (e IFrameElement) Height() string {
	return e.attrAsString("height")
}
func (e IFrameElement) Width() string {
	return e.attrAsString("width")
}
func (e IFrameElement) Name() string {
	return e.attrAsString("name")
}
func (e IFrameElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e ImageElement) CurrentSrc() string {
	return e.attrAsURLString("src", "")
}
func (e ImageElement) Sizes() string {
	return e.attrAsString("sizes")
}
func (e ImageElement) Srcset() string {
	return e.attrAsString("srcset")
}
func (e ImageElement) Alt() string {
	return e.attrAsString("alt")
}
func (e ImageElement) CrossOrigin() goja.Value {
	attrVal, exists := e.sel.sel.Attr("crossorigin")
	if !exists {
		return goja.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return e.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return e.sel.rt.ToValue(attrVal)
	default:
		return goja.Undefined()
	}
}
func (e ImageElement) Height() int {
	return e.attrAsInt("height", 0)
}
func (e ImageElement) Width() int {
	return e.attrAsInt("width", 0)
}
func (e ImageElement) IsMap() bool {
	return e.attrIsPresent("ismap")
}
func (e ImageElement) Name() string {
	return e.attrAsString("name")
}
func (e ImageElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e ImageElement) UseMap() string {
	return e.attrAsString("usemap")
}
func (e ImageElement) ReferrerPolicy() string {
	attrVal := e.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}
func (e InputElement) Name() string {
	return e.attrAsString("name")
}
func (e InputElement) TabIndex() int {
	return e.attrAsInt("tabindex", 0)
}
func (e InputElement) Type() string {
	attrVal := e.attrAsString("type")
	switch attrVal {
	case "button":
		return attrVal
	case "checkbox":
		return attrVal
	case "color":
		return attrVal
	case "date":
		return attrVal
	case "datetime-local":
		return attrVal
	case "email":
		return attrVal
	case "file":
		return attrVal
	case "hidden":
		return attrVal
	case "image":
		return attrVal
	case "month":
		return attrVal
	case "number":
		return attrVal
	case "password":
		return attrVal
	case "radio":
		return attrVal
	case "range":
		return attrVal
	case "reset":
		return attrVal
	case "search":
		return attrVal
	case "submit":
		return attrVal
	case "tel":
		return attrVal
	case "time":
		return attrVal
	case "url":
		return attrVal
	case "week":
		return attrVal
	default:
		return "text"
	}
}
func (e InputElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e InputElement) Autofocus() bool {
	return e.attrIsPresent("autofocus")
}
func (e InputElement) Required() bool {
	return e.attrIsPresent("required")
}
func (e InputElement) Value() string {
	return e.attrAsString("value")
}
func (e InputElement) Checked() bool {
	return e.attrIsPresent("checked")
}
func (e InputElement) DefaultChecked() bool {
	return e.attrIsPresent("checked")
}
func (e InputElement) Alt() string {
	return e.attrAsString("alt")
}
func (e InputElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e InputElement) Height() string {
	return e.attrAsString("height")
}
func (e InputElement) Width() string {
	return e.attrAsString("width")
}
func (e InputElement) Accept() string {
	return e.attrAsString("accept")
}
func (e InputElement) Autocomplete() string {
	attrVal := e.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}
func (e InputElement) MaxLength() int {
	return e.attrAsInt("maxlength", -1)
}
func (e InputElement) Size() int {
	return e.attrAsInt("size", 0)
}
func (e InputElement) Pattern() string {
	return e.attrAsString("pattern")
}
func (e InputElement) Placeholder() string {
	return e.attrAsString("placeholder")
}
func (e InputElement) Readonly() bool {
	return e.attrIsPresent("readonly")
}
func (e InputElement) Min() string {
	return e.attrAsString("min")
}
func (e InputElement) Max() string {
	return e.attrAsString("max")
}
func (e InputElement) DefaultValue() string {
	return e.attrAsString("value")
}
func (e InputElement) DirName() string {
	return e.attrAsString("dirname")
}
func (e InputElement) AccessKey() string {
	return e.attrAsString("accesskey")
}
func (e InputElement) Multiple() bool {
	return e.attrIsPresent("multiple")
}
func (e InputElement) Step() string {
	return e.attrAsString("step")
}
func (e KeygenElement) Autofocus() bool {
	return e.attrIsPresent("autofocus")
}
func (e KeygenElement) Challenge() string {
	return e.attrAsString("challenge")
}
func (e KeygenElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e KeygenElement) Keytype() string {
	attrVal := e.attrAsString("keytype")
	switch attrVal {
	case "DSA":
		return attrVal
	case "EC":
		return attrVal
	default:
		return "RSA"
	}
}
func (e KeygenElement) Name() string {
	return e.attrAsString("name")
}
func (e KeygenElement) Type() string {
	return "keygen"
}
func (e LabelElement) HtmlFor() string {
	return e.attrAsString("for")
}
func (e LegendElement) AccessKey() string {
	return e.attrAsString("accesskey")
}
func (e LiElement) Value() int {
	return e.attrAsInt("value", 0)
}
func (e LiElement) Type() string {
	attrVal := e.attrAsString("type")
	switch attrVal {
	case "1":
		return attrVal
	case "a":
		return attrVal
	case "A":
		return attrVal
	case "i":
		return attrVal
	case "I":
		return attrVal
	case "disc":
		return attrVal
	case "square":
		return attrVal
	case "circle":
		return attrVal
	default:
		return ""
	}
}
func (e LinkElement) CrossOrigin() goja.Value {
	attrVal, exists := e.sel.sel.Attr("crossorigin")
	if !exists {
		return goja.Undefined()
	}
	switch attrVal {
	case "anonymous":
		return e.sel.rt.ToValue(attrVal)
	case "use-credentials":
		return e.sel.rt.ToValue(attrVal)
	default:
		return goja.Undefined()
	}
}
func (e LinkElement) ReferrerPolicy() string {
	attrVal := e.attrAsString("referrerpolicy")
	switch attrVal {
	case "no-referrer":
		return attrVal
	case "no-referrer-when-downgrade":
		return attrVal
	case "origin":
		return attrVal
	case "origin-when-cross-origin":
		return attrVal
	case "unsafe-url":
		return attrVal
	default:
		return ""
	}
}
func (e LinkElement) Href() string {
	return e.attrAsURLString("href", "")
}
func (e LinkElement) Hreflang() string {
	return e.attrAsString("hreflang")
}
func (e LinkElement) Media() string {
	return e.attrAsString("media")
}
func (e LinkElement) Rel() string {
	return e.attrAsString("rel")
}
func (e LinkElement) Target() string {
	return e.attrAsString("target")
}
func (e LinkElement) Type() string {
	return e.attrAsString("type")
}
func (e MapElement) Name() string {
	return e.attrAsString("name")
}
func (e MetaElement) Content() string {
	return e.attrAsString("content")
}
func (e MetaElement) Name() string {
	return e.attrAsString("name")
}
func (e MetaElement) HttpEquiv() string {
	attrVal := e.attrAsString("http-equiv")
	switch attrVal {
	case "default-style":
		return attrVal
	case "refresh":
		return attrVal
	default:
		return "content-type"
	}
}
func (e MeterElement) Min() int {
	return e.attrAsInt("min", 0)
}
func (e MeterElement) Max() int {
	return e.attrAsInt("max", 0)
}
func (e MeterElement) High() int {
	return e.attrAsInt("high", 0)
}
func (e MeterElement) Low() int {
	return e.attrAsInt("low", 0)
}
func (e MeterElement) Optimum() int {
	return e.attrAsInt("optimum", 0)
}
func (e ModElement) Cite() string {
	return e.attrAsString("cite")
}
func (e ModElement) Datetime() string {
	return e.attrAsString("datetime")
}
func (e ObjectElement) Data() string {
	return e.attrAsURLString("data", "")
}
func (e ObjectElement) Height() string {
	return e.attrAsString("height")
}
func (e ObjectElement) Name() string {
	return e.attrAsString("name")
}
func (e ObjectElement) Type() string {
	return e.attrAsString("type")
}
func (e ObjectElement) TabIndex() int {
	return e.attrAsInt("tabindex", 0)
}
func (e ObjectElement) TypeMustMatch() bool {
	return e.attrIsPresent("typemustmatch")
}
func (e ObjectElement) UseMap() string {
	return e.attrAsString("usemap")
}
func (e ObjectElement) Width() string {
	return e.attrAsString("width")
}
func (e OListElement) Reversed() bool {
	return e.attrIsPresent("reversed")
}
func (e OListElement) Start() int {
	return e.attrAsInt("start", 0)
}
func (e OListElement) Type() string {
	attrVal := e.attrAsString("type")
	switch attrVal {
	case "a":
		return attrVal
	case "A":
		return attrVal
	case "i":
		return attrVal
	case "I":
		return attrVal
	default:
		return "1"
	}
}
func (e OptGroupElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e OptGroupElement) Label() string {
	return e.attrAsString("label")
}
func (e OptionElement) DefaultSelected() bool {
	return e.attrIsPresent("selected")
}
func (e OptionElement) Selected() bool {
	return e.attrIsPresent("selected")
}
func (e OutputElement) HtmlFor() string {
	return e.attrAsString("for")
}
func (e OutputElement) Name() string {
	return e.attrAsString("name")
}
func (e OutputElement) Type() string {
	return "output"
}
func (e ParamElement) Name() string {
	return e.attrAsString("name")
}
func (e ParamElement) Value() string {
	return e.attrAsString("value")
}
func (e PreElement) Name() string {
	return e.attrAsString("name")
}
func (e PreElement) Value() string {
	return e.attrAsString("value")
}
func (e QuoteElement) Cite() string {
	return e.attrAsString("cite")
}
func (e ScriptElement) CrossOrigin() string {
	return e.attrAsString("crossorigin")
}
func (e ScriptElement) Type() string {
	return e.attrAsString("type")
}
func (e ScriptElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e ScriptElement) Charset() string {
	return e.attrAsString("charset")
}
func (e ScriptElement) Async() bool {
	return e.attrIsPresent("async")
}
func (e ScriptElement) Defer() bool {
	return e.attrIsPresent("defer")
}
func (e ScriptElement) NoModule() bool {
	return e.attrIsPresent("nomodule")
}
func (e SelectElement) Autofocus() bool {
	return e.attrIsPresent("autofocus")
}
func (e SelectElement) Disabled() bool {
	return e.attrIsPresent("disabled")
}
func (e SelectElement) Multiple() bool {
	return e.attrIsPresent("multiple")
}
func (e SelectElement) Name() string {
	return e.attrAsString("name")
}
func (e SelectElement) Required() bool {
	return e.attrIsPresent("required")
}
func (e SelectElement) TabIndex() int {
	return e.attrAsInt("tabindex", 0)
}
func (e SourceElement) KeySystem() string {
	return e.attrAsString("keysystem")
}
func (e SourceElement) Media() string {
	return e.attrAsString("media")
}
func (e SourceElement) Sizes() string {
	return e.attrAsString("sizes")
}
func (e SourceElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e SourceElement) Srcset() string {
	return e.attrAsString("srcset")
}
func (e SourceElement) Type() string {
	return e.attrAsString("type")
}
func (e StyleElement) Media() string {
	return e.attrAsString("media")
}
func (e TableElement) Sortable() bool {
	return e.attrIsPresent("sortable")
}
func (e TableCellElement) ColSpan() int {
	return e.attrAsInt("colspan", 1)
}
func (e TableCellElement) RowSpan() int {
	return e.attrAsInt("rowspan", 1)
}
func (e TableCellElement) Headers() string {
	return e.attrAsString("headers")
}
func (e TableHeaderCellElement) Abbr() string {
	return e.attrAsString("abbr")
}
func (e TableHeaderCellElement) Scope() string {
	attrVal := e.attrAsString("scope")
	switch attrVal {
	case "row":
		return attrVal
	case "col":
		return attrVal
	case "colgroup":
		return attrVal
	case "rowgroup":
		return attrVal
	default:
		return ""
	}
}
func (e TableHeaderCellElement) Sorted() bool {
	return e.attrIsPresent("sorted")
}
func (e TextAreaElement) Type() string {
	return "textarea"
}
func (e TextAreaElement) Value() string {
	return e.attrAsString("value")
}
func (e TextAreaElement) DefaultValue() string {
	return e.attrAsString("value")
}
func (e TextAreaElement) Placeholder() string {
	return e.attrAsString("placeholder")
}
func (e TextAreaElement) Rows() int {
	return e.attrAsInt("rows", 0)
}
func (e TextAreaElement) Cols() int {
	return e.attrAsInt("cols", 0)
}
func (e TextAreaElement) MaxLength() int {
	return e.attrAsInt("maxlength", 0)
}
func (e TextAreaElement) TabIndex() int {
	return e.attrAsInt("tabindex", 0)
}
func (e TextAreaElement) AccessKey() string {
	return e.attrAsString("accesskey")
}
func (e TextAreaElement) ReadOnly() bool {
	return e.attrIsPresent("readonly")
}
func (e TextAreaElement) Required() bool {
	return e.attrIsPresent("required")
}
func (e TextAreaElement) Autocomplete() string {
	attrVal := e.attrAsString("autocomplete")
	switch attrVal {
	case "off":
		return attrVal
	default:
		return "on"
	}
}
func (e TextAreaElement) Autocapitalize() string {
	attrVal := e.attrAsString("autocapitalize")
	switch attrVal {
	case "none":
		return attrVal
	case "off":
		return attrVal
	case "characters":
		return attrVal
	case "words":
		return attrVal
	default:
		return "sentences"
	}
}
func (e TextAreaElement) Wrap() string {
	attrVal := e.attrAsString("wrap")
	switch attrVal {
	case "hard":
		return attrVal
	case "off":
		return attrVal
	default:
		return "soft"
	}
}
func (e TimeElement) Datetime() string {
	return e.attrAsString("datetime")
}
func (e TrackElement) Kind() string {
	attrVal := e.attrAsString("kind")
	switch attrVal {
	case "captions":
		return attrVal
	case "descriptions":
		return attrVal
	case "chapters":
		return attrVal
	case "metadata":
		return attrVal
	default:
		return "subtitle"
	}
}
func (e TrackElement) Src() string {
	return e.attrAsURLString("src", "")
}
func (e TrackElement) Srclang() string {
	return e.attrAsString("srclang")
}
func (e TrackElement) Label() string {
	return e.attrAsString("label")
}
func (e TrackElement) Default() bool {
	return e.attrIsPresent("default")
}
func (e UListElement) Type() string {
	return e.attrAsString("type")
}
