/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.gitea.api.GiteaAPI;
import org.jreleaser.sdk.gitea.api.GtAsset;
import org.jreleaser.sdk.gitea.api.GtBranch;
import org.jreleaser.sdk.gitea.api.GtIssue;
import org.jreleaser.sdk.gitea.api.GtLabel;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtOrganization;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.sdk.gitea.api.GtSearchUser;
import org.jreleaser.sdk.gitea.api.GtUser;
import org.jreleaser.sdk.gitea.internal.Page;
import org.jreleaser.sdk.gitea.internal.PaginatingDecoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class Gitea {
    private static final String API_V1 = "/api/v1";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GiteaAPI api;

    public Gitea(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        if (!endpoint.endsWith(API_V1)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V1;
        }
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GiteaAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("token %s", token)})).target(GiteaAPI.class, endpoint);
    }

    public GtRepository findRepository(String owner, String repo) {
        this.logger.debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        try {
            return this.api.getRepository(owner, repo);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public List<Release> listReleases(String owner, String repoName) {
        this.logger.debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<Release> releases = new ArrayList<Release>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"draft", (Object)false).e((Object)"prerelease", (Object)false).e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GtRelease>> page = this.api.listReleases(owner, repoName, (Map<String, Object>)params);
            page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), r.getHtmlUrl(), r.getPublishedAt())).forEach(releases::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return releases;
    }

    public List<String> listBranches(String owner, String repoName) {
        this.logger.debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<String> branches = new ArrayList<String>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GtBranch>> page = this.api.listBranches(owner, repoName, (Map<String, Object>)params);
            page.getContent().stream().map(GtBranch::getName).forEach(branches::add);
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return branches;
    }

    public Map<String, GtAsset> listAssets(String owner, String repo, GtRelease release) {
        this.logger.debug(RB.$((String)"git.list.assets.github", (Object[])new Object[0]), new Object[]{owner, repo, release.getId()});
        LinkedHashMap<String, GtAsset> assets = new LinkedHashMap<String, GtAsset>();
        for (GtAsset asset : this.api.listAssets(owner, repo, release.getId())) {
            assets.put(asset.getName(), asset);
        }
        return assets;
    }

    public Optional<GtMilestone> findMilestoneByName(String owner, String repo, String milestoneName) {
        this.logger.debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "open");
    }

    public Optional<GtMilestone> findClosedMilestoneByName(String owner, String repo, String milestoneName) {
        this.logger.debug(RB.$((String)"git.milestone.lookup.closed", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        return this.findMilestone(owner, repo, milestoneName, "closed");
    }

    private Optional<GtMilestone> findMilestone(String owner, String repo, String milestoneName, String state) {
        try {
            GtMilestone milestone = this.api.findMilestoneByTitle(owner, repo, milestoneName);
            if (null == milestone) {
                return Optional.empty();
            }
            return state.equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public void closeMilestone(String owner, String repo, GtMilestone milestone) {
        this.logger.debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state", (Object)"closed"), owner, repo, milestone.getId());
    }

    public GtRepository createRepository(String owner, String repo) {
        this.logger.debug(RB.$((String)"git.repository.create", (Object[])new Object[0]), new Object[]{owner, repo});
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"name", (Object)repo).e((Object)"private", (Object)false);
        GtOrganization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return this.api.createRepository((Map<String, Object>)params, owner);
        }
        return this.api.createRepository((Map<String, Object>)params);
    }

    private GtOrganization resolveOrganization(String name) {
        try {
            return this.api.getOrganization(name);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public GtRelease findReleaseByTag(String owner, String repo, String tagName) {
        this.logger.debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repo, tagName});
        try {
            return this.api.getReleaseByTagName(owner, repo, tagName);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    public void deleteRelease(String owner, String repo, String tagName, Integer id) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.release.from.id", (Object[])new Object[0]), new Object[]{tagName, owner, repo, id});
        try {
            this.api.deleteRelease(owner, repo, id);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return;
            }
            throw e;
        }
    }

    public void deleteTag(String owner, String repo, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repo});
        this.api.deleteTag(owner, repo, tagName);
    }

    public void deletePackage(String owner, String type, String name, String version) throws RestAPIException {
        this.logger.debug(RB.$((String)"gitea.delete.package", (Object[])new Object[0]), new Object[]{owner, type, name, version});
        this.api.deletePackage(owner, type, name, version);
    }

    public GtRelease createRelease(String owner, String repo, GtRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        return this.api.createRelease(release, owner, repo);
    }

    public void updateRelease(String owner, String repo, Integer id, GtRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, release.getTagName()});
        this.api.updateRelease(release, owner, repo, id);
    }

    public void uploadAssets(String owner, String repo, GtRelease release, Set<Asset> assets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.uploadOrUpdateAsset(asset, owner, repo, release, "git.upload.asset", "git.upload.asset.failure");
        }
    }

    public void updateAssets(String owner, String repo, GtRelease release, Set<Asset> assets, Map<String, GtAsset> existingAssets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.logger.debug(" " + RB.$((String)"git.delete.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                this.api.deleteAsset(owner, repo, release.getId(), existingAssets.get(asset.getFilename()).getId());
            }
            catch (RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.delete.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
            this.uploadOrUpdateAsset(asset, owner, repo, release, "git.update.asset", "git.update.asset.failure");
        }
    }

    private void uploadOrUpdateAsset(Asset asset, String owner, String repo, GtRelease release, String operationMessageKey, String operationErrorMessageKey) throws IOException {
        this.logger.info(" " + RB.$((String)operationMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
        try {
            this.api.uploadAsset(owner, repo, release.getId(), this.toFormData(asset.getPath()));
        }
        catch (RestAPIException e) {
            this.logger.error(" " + RB.$((String)operationErrorMessageKey, (Object[])new Object[0]), new Object[]{asset.getFilename()});
            throw e;
        }
    }

    public Optional<User> findUser(String email, String name, String host) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        GtSearchUser search = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"q", email}));
        if (null != search.getData() && !search.getData().isEmpty()) {
            GtUser user = search.getData().get(0);
            return Optional.of(new User(user.getUsername(), email, host + user.getUsername()));
        }
        return Optional.empty();
    }

    public GtLabel getOrCreateLabel(String owner, String name, String labelName, String labelColor, String description) {
        this.logger.debug(RB.$((String)"git.label.fetch", (Object[])new Object[]{labelName}));
        List<GtLabel> labels = this.listLabels(owner, name);
        Optional<GtLabel> label = labels.stream().filter(l -> l.getName().equals(labelName)).findFirst();
        if (label.isPresent()) {
            return label.get();
        }
        this.logger.debug(RB.$((String)"git.label.create", (Object[])new Object[]{labelName}));
        return this.api.createLabel(owner, name, labelName, labelColor, description);
    }

    public Optional<GtIssue> findIssue(String owner, String name, int issueNumber) {
        this.logger.debug(RB.$((String)"git.issue.fetch", (Object[])new Object[]{issueNumber}));
        try {
            return Optional.of(this.api.findIssue(owner, name, issueNumber));
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public void addLabelToIssue(String owner, String name, GtIssue issue, GtLabel label) {
        this.logger.debug(RB.$((String)"git.issue.label", (Object[])new Object[]{label.getName(), issue.getNumber()}));
        LinkedHashMap<String, List<Integer>> labels = new LinkedHashMap<String, List<Integer>>();
        List list = labels.computeIfAbsent("labels", k -> new ArrayList());
        list.addAll(issue.getLabels().stream().map(GtLabel::getId).collect(Collectors.toList()));
        list.add(label.getId());
        this.api.labelIssue(labels, owner, name, issue.getNumber());
    }

    public void commentOnIssue(String owner, String name, GtIssue issue, String comment) {
        this.logger.debug(RB.$((String)"git.issue.comment", (Object[])new Object[]{issue.getNumber()}));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("body", comment);
        this.api.commentIssue(params, owner, name, issue.getNumber());
    }

    public void setMilestoneOnIssue(String owner, String name, GtIssue issue, GtMilestone milestone) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("milestone", milestone.getId());
        this.api.updateIssue(params, owner, name, issue.getNumber());
    }

    private List<GtLabel> listLabels(String owner, String repoName) {
        this.logger.debug(RB.$((String)"git.list.labels", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<GtLabel> labels = new ArrayList<GtLabel>();
        int pageCount = 0;
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"limit", (Object)20);
        boolean consume = true;
        do {
            params.put("page", ++pageCount);
            Page<List<GtLabel>> page = this.api.listLabels(owner, repoName, (Map<String, Object>)params);
            labels.addAll((Collection)page.getContent());
            if (page.hasLinks() && page.getLinks().hasNext()) continue;
            consume = false;
        } while (consume);
        return labels;
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

