/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.IO;
import org.jreleaser.model.internal.JReleaserContext;
import picocli.CommandLine;

@CommandLine.Command
public class AbstractDistributionModelCommand<C extends IO>
extends AbstractPlatformAwareModelCommand<C> {
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-d", "--distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xd", "--exclude-distribution", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
        }
    }

    static class Exclude {
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;

        Include() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedDistributions() {
            return null != this.include ? this.include.includedDistributions : null;
        }

        String[] excludedDistributions() {
            return null != this.exclude ? this.exclude.excludedDistributions : null;
        }
    }
}

