/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.distribution.PackagerProcessingFunction;
import org.jreleaser.engine.distribution.PackagerProcessors;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.model.spi.packagers.PackagerProcessor;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public class DistributionProcessor {
    private final JReleaserContext context;
    private final String distributionName;
    private final String packagerName;

    private DistributionProcessor(JReleaserContext context, String distributionName, String packagerName) {
        this.context = context;
        this.distributionName = distributionName;
        this.packagerName = packagerName;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public String getPackagerName() {
        return this.packagerName;
    }

    public void prepareDistribution() throws PackagerProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Packager packager = distribution.findPackager(this.packagerName);
        this.executeProcessor(distribution, packager, false, RB.$((String)"distributions.action.preparing", (Object[])new Object[0]), packagerProcessor -> packagerProcessor.prepareDistribution(distribution, this.initProps()));
    }

    public void packageDistribution() throws PackagerProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Packager packager = distribution.findPackager(this.packagerName);
        this.executeProcessor(distribution, packager, true, RB.$((String)"distributions.action.packaging", (Object[])new Object[0]), packagerProcessor -> packagerProcessor.packageDistribution(distribution, this.initProps()));
    }

    public void publishDistribution() throws PackagerProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Packager packager = distribution.findPackager(this.packagerName);
        this.executeProcessor(distribution, packager, true, RB.$((String)"distributions.action.publishing", (Object[])new Object[0]), packagerProcessor -> packagerProcessor.publishDistribution(distribution, this.initProps()));
    }

    private void executeProcessor(Distribution distribution, Packager<?> packager, boolean checkFailed, String action, ProcessorFunction function) throws PackagerProcessingException {
        if (!packager.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"distributions.skip.distribution", (Object[])new Object[0]), new Object[]{this.distributionName});
            return;
        }
        if (checkFailed && packager.isFailed()) {
            this.context.getLogger().warn(RB.$((String)"distributions.previous.failure", (Object[])new Object[0]));
            return;
        }
        PackagerProcessor<Packager<?>> packagerProcessor = PackagerProcessors.findProcessor(this.context, packager);
        if (!packagerProcessor.supportsDistribution(distribution)) {
            this.context.getLogger().info(RB.$((String)"distributions.not.supported.distribution", (Object[])new Object[0]), new Object[]{this.distributionName, distribution.getType()});
            return;
        }
        this.context.getLogger().info(RB.$((String)"distributions.apply.action.distribution", (Object[])new Object[0]), new Object[]{action, this.distributionName});
        try {
            function.process(packagerProcessor);
        }
        catch (PackagerProcessingException ppe) {
            if (packager.isContinueOnError()) {
                packager.fail();
                this.context.getLogger().warn(RB.$((String)"distributions.failure", (Object[])new Object[0]), new Object[]{ppe.getMessage()});
                this.context.getLogger().trace((Throwable)ppe);
            }
            throw ppe;
        }
    }

    private TemplateContext initProps() {
        TemplateContext props = this.context.props();
        props.set("prepareDirectory", (Object)this.context.getPrepareDirectory());
        props.set("packageDirectory", (Object)this.context.getPackageDirectory());
        props.set("distributionPrepareDirectory", (Object)this.context.getPrepareDirectory().resolve(this.distributionName).resolve(this.packagerName));
        props.set("distributionPackageDirectory", (Object)this.context.getPackageDirectory().resolve(this.distributionName).resolve(this.packagerName));
        return props;
    }

    public static DistributionProcessorBuilder builder() {
        return new DistributionProcessorBuilder();
    }

    public static class DistributionProcessorBuilder {
        private JReleaserContext context;
        private String distributionName;
        private String packagerName;

        public DistributionProcessorBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public DistributionProcessorBuilder distributionName(String distributionName) {
            this.distributionName = StringUtils.requireNonBlank((String)distributionName, (String)"'distributionName' must not be blank");
            return this;
        }

        public DistributionProcessorBuilder packagerName(String packagerName) {
            this.packagerName = StringUtils.requireNonBlank((String)packagerName, (String)"'packagerName' must not be blank");
            return this;
        }

        public DistributionProcessor build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            StringUtils.requireNonBlank((String)this.distributionName, (String)"'distributionName' must not be blank");
            StringUtils.requireNonBlank((String)this.packagerName, (String)"'packagerName' must not be blank");
            return new DistributionProcessor(this.context, this.distributionName, this.packagerName);
        }
    }

    public static class PackagingAction {
        private final String text;
        private final Type type;
        private final PackagerProcessingFunction function;

        private PackagingAction(String text, Type type, PackagerProcessingFunction function) {
            this.text = text;
            this.type = type;
            this.function = function;
        }

        public String getText() {
            return this.text;
        }

        public Type getType() {
            return this.type;
        }

        public PackagerProcessingFunction getFunction() {
            return this.function;
        }

        public static PackagingAction of(String text, Type type, PackagerProcessingFunction function) {
            return new PackagingAction(text, type, function);
        }

        public static enum Type {
            PREPARE,
            PACKAGE,
            PUBLISH;

        }
    }

    static interface ProcessorFunction {
        public void process(PackagerProcessor<Packager<?>> var1) throws PackagerProcessingException;
    }
}

