/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class Env {
    public static final String JRELEASER_ENV_PREFIX = "JRELEASER_";
    public static final String JRELEASER_SYS_PREFIX = "jreleaser.";

    private Env() {
    }

    public static String toVar(String str) {
        return str.replace(" ", "_").replace("-", "_").replace(".", "_").toUpperCase(Locale.ENGLISH);
    }

    public static String envKey(String key) {
        if (!key.startsWith(JRELEASER_ENV_PREFIX)) {
            key = JRELEASER_ENV_PREFIX + key;
        }
        return Env.toVar(key);
    }

    public static String sysKey(String key) {
        if (!key.startsWith(JRELEASER_SYS_PREFIX)) {
            key = JRELEASER_SYS_PREFIX + key;
        }
        return key.replace(" ", ".").replace("-", ".").replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public static String env(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return System.getenv(Env.envKey(key));
    }

    public static String env(Collection<String> keys, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return keys.stream().map(Env::envKey).filter(key -> System.getenv().containsKey(key)).map(System::getenv).findFirst().orElse(null);
    }

    public static String sys(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return System.getProperty(Env.sysKey(key));
    }

    public static String sys(Collection<String> keys, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return keys.stream().map(Env::sysKey).filter(key -> System.getProperties().containsKey(key)).map(System::getProperty).findFirst().orElse(null);
    }

    public static String resolve(String key, String value) {
        return Env.env(key, Env.sys(key, value));
    }

    public static String resolveOrDefault(String key, String value, String defaultValue) {
        String result = Env.env(key, Env.sys(key, value));
        return StringUtils.isNotBlank(result) ? result : defaultValue;
    }

    public static String check(String key, String value, String property, String dsl, String configFilePath, Errors errors) {
        if (StringUtils.isBlank(value)) {
            String envKey = Env.envKey(key);
            String sysKey = Env.sysKey(key);
            errors.configuration(RB.$((String)"ERROR_environment_property_check", (Object[])new Object[]{property, dsl, sysKey, envKey, configFilePath, envKey}));
        }
        return value;
    }

    public static String check(Collection<String> keys, Properties values, String property, String dsl, String configFilePath, Errors errors) {
        List sysKeys = keys.stream().map(Env::sysKey).collect(Collectors.toList());
        List envKeys = keys.stream().map(Env::envKey).collect(Collectors.toList());
        String value = sysKeys.stream().filter(System.getProperties()::containsKey).map(System::getProperty).findFirst().orElse(null);
        if (StringUtils.isBlank(value)) {
            value = envKeys.stream().filter(values::containsKey).map(values::getProperty).findFirst().orElse(null);
        }
        if (StringUtils.isBlank(value)) {
            errors.configuration(RB.$((String)"ERROR_environment_property_check2", (Object[])new Object[]{property, dsl, sysKeys, envKeys, configFilePath, envKeys}));
        }
        return value;
    }
}

