/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Flatpak;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Icon;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.packagers.AbstractAppdataPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class FlatpakPackager
extends AbstractAppdataPackager<org.jreleaser.model.api.packagers.FlatpakPackager, FlatpakPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 1676752377583110248L;
    private final FlatpakRepository repository = new FlatpakRepository();
    private final Set<String> sdkExtensions = new LinkedHashSet<String>();
    private final Set<String> finishArgs = new LinkedHashSet<String>();
    private Flatpak.Runtime runtime;
    private String runtimeVersion;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.FlatpakPackager immutable = new org.jreleaser.model.api.packagers.FlatpakPackager(){
        private static final long serialVersionUID = 157728126284625211L;
        private List<? extends org.jreleaser.model.api.common.Screenshot> screenshots;
        private List<? extends Icon> icons;

        public String getComponentId() {
            return FlatpakPackager.this.getComponentId();
        }

        public List<String> getCategories() {
            return Collections.unmodifiableList(FlatpakPackager.this.getCategories());
        }

        public String getDeveloperName() {
            return FlatpakPackager.this.getDeveloperName();
        }

        public Flatpak.Runtime getRuntime() {
            return FlatpakPackager.this.runtime;
        }

        public String getRuntimeVersion() {
            return FlatpakPackager.this.runtimeVersion;
        }

        public Set<String> getSdkExtensions() {
            return Collections.unmodifiableSet(FlatpakPackager.this.sdkExtensions);
        }

        public Set<String> getFinishArgs() {
            return Collections.unmodifiableSet(FlatpakPackager.this.finishArgs);
        }

        public List<? extends org.jreleaser.model.api.common.Screenshot> getScreenshots() {
            if (null == this.screenshots) {
                this.screenshots = FlatpakPackager.this.getScreenshots().stream().map(Screenshot::asImmutable).collect(Collectors.toList());
            }
            return this.screenshots;
        }

        public List<? extends Icon> getIcons() {
            if (null == this.icons) {
                this.icons = FlatpakPackager.this.getIcons().stream().map(org.jreleaser.model.internal.common.Icon::asImmutable).collect(Collectors.toList());
            }
            return this.icons;
        }

        public Set<String> getSkipReleases() {
            return Collections.unmodifiableSet(FlatpakPackager.this.getSkipReleases());
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return FlatpakPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return FlatpakPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return FlatpakPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(FlatpakPackager.this.getSkipTemplates());
        }

        public String getType() {
            return FlatpakPackager.this.getType();
        }

        public String getDownloadUrl() {
            return FlatpakPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return FlatpakPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return FlatpakPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return FlatpakPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return FlatpakPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return FlatpakPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return FlatpakPackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return FlatpakPackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return FlatpakPackager.this.getActive();
        }

        public boolean isEnabled() {
            return FlatpakPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FlatpakPackager.this.asMap(full));
        }

        public String getPrefix() {
            return FlatpakPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FlatpakPackager.this.getExtraProperties());
        }
    };

    public FlatpakPackager() {
        super("flatpak");
    }

    @Override
    public org.jreleaser.model.api.packagers.FlatpakPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FlatpakPackager source) {
        super.merge(source);
        this.runtime = this.merge(this.runtime, source.runtime);
        this.runtimeVersion = this.merge(this.runtimeVersion, source.runtimeVersion);
        this.setSdkExtensions(this.merge(this.sdkExtensions, source.sdkExtensions));
        this.setFinishArgs(this.merge(this.finishArgs, source.finishArgs));
        this.setRepository(source.repository);
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return CollectionUtils.setOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP});
    }

    public Flatpak.Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Flatpak.Runtime runtime) {
        this.runtime = runtime;
    }

    public void setRuntime(String runtime) {
        this.setRuntime(Flatpak.Runtime.of((String)runtime));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public Set<String> getSdkExtensions() {
        return this.sdkExtensions;
    }

    public void setSdkExtensions(Set<String> sdkExtensions) {
        this.sdkExtensions.clear();
        this.sdkExtensions.addAll(sdkExtensions);
    }

    public Set<String> getFinishArgs() {
        return this.finishArgs;
    }

    public void setFinishArgs(Set<String> finishArgs) {
        this.finishArgs.clear();
        this.finishArgs.addAll(finishArgs);
    }

    public FlatpakRepository getRepository() {
        return this.repository;
    }

    public void setRepository(FlatpakRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> map) {
        super.asMap(full, map);
        map.put("runtime", this.runtime);
        map.put("runtimeVersion", this.runtimeVersion);
        map.put("sdkExtensions", this.sdkExtensions);
        map.put("finishArgs", this.finishArgs);
        map.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipFlatpak"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class FlatpakRepository
    extends PackagerRepository {
        private static final long serialVersionUID = 6821986475211460731L;

        public FlatpakRepository() {
            super("flatpak", "flatpak");
        }
    }
}

